/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render.template;

import io.gatling.commons.util.StringHelper$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.render.DumpedBody;
import io.gatling.recorder.render.RequestBody;
import io.gatling.recorder.render.RequestBodyParams;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.template.ExtractedUris;
import io.gatling.recorder.render.template.RenderingFormat;
import io.gatling.recorder.render.template.RenderingFormat$Kotlin$;
import io.gatling.recorder.render.template.RequestTemplate$;
import io.gatling.recorder.render.template.SimulationTemplate$;
import io.gatling.recorder.render.template.package$;
import io.gatling.recorder.render.template.package$TemplateString$;
import java.io.Serializable;
import java.util.Locale;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dsAB\r\u001b\u0011\u0003aBE\u0002\u0004'5!\u0005Ad\n\u0005\u0006]\u0005!\t\u0001\r\u0005\u0006c\u0005!\tA\r\u0005\b\u0001\u0006\u0011\r\u0011\"\u0003B\u0011\u0019\t\u0016\u0001)A\u0005\u0005\"9!+\u0001b\u0001\n\u0013\u0019\u0006BB,\u0002A\u0003%AKB\u0003'5\u0001a\u0002\f\u0003\u0005Z\u0011\t\u0005\t\u0015!\u0003[\u0011!\t\u0007B!A!\u0002\u0013Q\u0006\u0002\u00032\t\u0005\u0003\u0005\u000b\u0011B2\t\u000b9BA\u0011\u00015\t\u000f5D!\u0019!C\u0005]\"1!\u000f\u0003Q\u0001\n=Dqa\u001d\u0005C\u0002\u0013%A\u000f\u0003\u0004v\u0011\u0001\u0006IA\u0013\u0005\u0006m\"!Ia\u001e\u0005\b\u0003\u000bAA\u0011BA\u0004\u0011\u001d\tY\u0001\u0003C\u0005\u0003\u001bAq!!\u0005\t\t\u0013\t\u0019\u0002C\u0004\u0002\u0018!!I!!\u0007\t\u000f\u0005\r\u0002\u0002\"\u0003\u0002&!9\u0011\u0011\u0006\u0005\u0005\n\u0005-\u0002BB\u000f\t\t\u0003\ty#A\bSKF,Xm\u001d;UK6\u0004H.\u0019;f\u0015\tYB$\u0001\u0005uK6\u0004H.\u0019;f\u0015\tib$\u0001\u0004sK:$WM\u001d\u0006\u0003?\u0001\n\u0001B]3d_J$WM\u001d\u0006\u0003C\t\nqaZ1uY&twMC\u0001$\u0003\tIw\u000e\u0005\u0002&\u00035\t!DA\bSKF,Xm\u001d;UK6\u0004H.\u0019;f'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA%\u0001\ftC:LG/\u001b>f%\u0016\fX/Z:u!>\u001cHOZ5y)\t\u0019d\b\u0005\u00025w9\u0011Q'\u000f\t\u0003m)j\u0011a\u000e\u0006\u0003q=\na\u0001\u0010:p_Rt\u0014B\u0001\u001e+\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iR\u0003\"B \u0004\u0001\u0004\u0019\u0014a\u00029pgR4\u0017\u000e_\u0001\u0013\u0005VLG\u000e^%o\u0011R$\b/T3uQ>$7/F\u0001C!\r\u0019\u0005JS\u0007\u0002\t*\u0011QIR\u0001\nS6lW\u000f^1cY\u0016T!a\u0012\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002J\t\n!A*[:u!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003mC:<'\"A(\u0002\t)\fg/Y\u0005\u0003y1\u000b1CQ;jYRLe\u000e\u0013;ua6+G\u000f[8eg\u0002\na\"T1y\u0019&$XM]1m'&TX-F\u0001U!\tIS+\u0003\u0002WU\t\u0019\u0011J\u001c;\u0002\u001f5\u000b\u0007\u0010T5uKJ\fGnU5{K\u0002\u001a\"\u0001\u0003\u0015\u0002\u001bI,\u0017/^3ti\n{G-[3t!\u0011!4\fV/\n\u0005qk$aA'baB\u0011alX\u0007\u00029%\u0011\u0001\r\b\u0002\u000b\tVl\u0007/\u001a3C_\u0012L\u0018A\u0004:fgB|gn]3C_\u0012LWm]\u0001\u0007G>tg-[4\u0011\u0005\u00114W\"A3\u000b\u0005\tt\u0012BA4f\u0005U\u0011VmY8sI\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:$B!\u001b6lYB\u0011Q\u0005\u0003\u0005\u000632\u0001\rA\u0017\u0005\u0006C2\u0001\rA\u0017\u0005\u0006E2\u0001\raY\u0001\u0007M>\u0014X.\u0019;\u0016\u0003=\u0004\"!\n9\n\u0005ET\"a\u0004*f]\u0012,'/\u001b8h\r>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u00059\u0011n]\"iK\u000e\\W#\u0001&\u0002\u0011%\u001c8\t[3dW\u0002\nAB]3oI\u0016\u0014X*\u001a;i_\u0012$2a\r=~\u0011\u0015I\u0018\u00031\u0001{\u0003\u001d\u0011X-];fgR\u0004\"AX>\n\u0005qd\"A\u0004*fcV,7\u000f^#mK6,g\u000e\u001e\u0005\u0006}F\u0001\ra`\u0001\rKb$(/Y2uK\u0012,&/\u001b\t\u0004K\u0005\u0005\u0011bAA\u00025\tiQ\t\u001f;sC\u000e$X\rZ+sSN\fQB]3oI\u0016\u0014\b*Z1eKJ\u001cHcA\u001a\u0002\n!)\u0011P\u0005a\u0001u\u0006\u0011\"/\u001a8eKJ\u0014u\u000eZ=PeB\u000b'/Y7t)\r\u0019\u0014q\u0002\u0005\u0006sN\u0001\rA_\u0001\u001be\u0016tG-\u001a:CCNL7-Q;uQ\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0004g\u0005U\u0001\"B=\u0015\u0001\u0004Q\u0018a\u0004:f]\u0012,'OU3t_V\u00148-Z:\u0015\u000fM\nY\"a\b\u0002\"!1\u0011QD\u000bA\u0002M\nqb]5nk2\fG/[8o\u00072\f7o\u001d\u0005\u0006sV\u0001\rA\u001f\u0005\u0006}V\u0001\ra`\u0001\u0012e\u0016tG-\u001a:Ti\u0006$Xo]\"iK\u000e\\GcA\u001a\u0002(!)\u0011P\u0006a\u0001u\u00069\"/\u001a8eKJ\u0014Vm\u001d9p]N,'i\u001c3z\u0007\",7m\u001b\u000b\u0004g\u00055\u0002\"B=\u0018\u0001\u0004QHcB\u001a\u00022\u0005M\u0012Q\u0007\u0005\u0007\u0003;A\u0002\u0019A\u001a\t\u000beD\u0002\u0019\u0001>\t\u000byD\u0002\u0019A@)\u000fa\tI$a\u0010\u0002BA\u00191*a\u000f\n\u0007\u0005uBJ\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg\u0006)a/\u00197vK2\u0012\u00111I\u0011\u0003\u0003\u000b\nqd\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f*fGV\u00148/[8o\u0001")
public class RequestTemplate {
    private final Map<Object, DumpedBody> requestBodies;
    private final Map<Object, DumpedBody> responseBodies;
    private final RecorderConfiguration config;
    private final RenderingFormat format;
    private final String isCheck;

    public static String sanitizeRequestPostfix(String postfix) {
        return RequestTemplate$.MODULE$.sanitizeRequestPostfix(postfix);
    }

    private RenderingFormat format() {
        return this.format;
    }

    private String isCheck() {
        return this.isCheck;
    }

    private String renderMethod(RequestElement request, ExtractedUris extractedUri) {
        String renderedUrl;
        String string = request.printedUrl();
        String string2 = request.uri();
        String string3 = !(string != null ? !string.equals(string2) : string2 != null) ? extractedUri.renderUri(request.uri()) : (renderedUrl = package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(request.printedUrl()), this.format()));
        if (RequestTemplate$.MODULE$.io$gatling$recorder$render$template$RequestTemplate$$BuiltInHttpMethods().contains((Object)request.method())) {
            return request.method().toLowerCase(Locale.ROOT) + "(" + renderedUrl + ")";
        }
        return "httpRequest(\"" + request.method() + "\", " + renderedUrl + ")";
    }

    private String renderHeaders(RequestElement request) {
        Option<Object> option = request.filteredHeadersId();
        if (option instanceof Some) {
            Some some = (Some)option;
            int id = BoxesRunTime.unboxToInt((Object)some.value());
            return ".headers(" + SimulationTemplate$.MODULE$.headersBlockName(id) + ")";
        }
        return "";
    }

    private String renderBodyOrParams(RequestElement request) {
        Some some;
        RequestBody requestBody;
        Option<RequestBody> option = request.body();
        if (option instanceof Some && (requestBody = (RequestBody)(some = (Some)option).value()) instanceof RequestBodyParams) {
            RequestBodyParams requestBodyParams = (RequestBodyParams)requestBody;
            List<Tuple2<String, String>> params = requestBodyParams.params();
            return params.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(".formParam(" + package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(key), this.format()) + ", " + this.renderLongString$1(value) + ")"));
                }
                throw new MatchError((Object)tuple2);
            }).mkString(StringHelper$.MODULE$.Eol() + "  ");
        }
        Option option2 = this.requestBodies.get((Object)BoxesRunTime.boxToInteger((int)request.id()));
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            DumpedBody dumpedBody = (DumpedBody)some2.value();
            return ".body(RawFileBody(\"" + dumpedBody.classPathLocation() + "\"))";
        }
        return "";
    }

    private String renderBasicAuthCredentials(RequestElement request) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = request.basicAuthCredentials();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            return ".basicAuth(" + package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(username), this.format()) + "," + package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(password), this.format()) + ")";
        }
        return "";
    }

    private String renderResources(String simulationClass, RequestElement request, ExtractedUris extractedUri) {
        if (request.nonEmbeddedResources().nonEmpty()) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(".resources(\n         |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(((List)request.nonEmbeddedResources().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    RequestElement resource = (RequestElement)tuple2._1();
                    return this.render(simulationClass, resource, extractedUri);
                }
                throw new MatchError((Object)tuple2);
            }).mkString("," + StringHelper$.MODULE$.Eol())), 2) + "\n         |)"));
        }
        return "";
    }

    private String renderStatusCheck(RequestElement request) {
        if (!HttpHelper$.MODULE$.isOk(request.statusCode())) {
            return ".check(status" + this.format().parameterlessMethodCall() + "." + this.isCheck() + "(" + request.statusCode() + "))";
        }
        return "";
    }

    private String renderResponseBodyCheck(RequestElement request) {
        Option option = this.responseBodies.get((Object)BoxesRunTime.boxToInteger((int)request.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            DumpedBody dumpedBody = (DumpedBody)some.value();
            return ".check(bodyBytes" + this.format().parameterlessMethodCall() + "." + this.isCheck() + "(RawFileBody(\"" + dumpedBody.classPathLocation() + "\")))";
        }
        return "";
    }

    public String render(String simulationClass, RequestElement request, ExtractedUris extractedUri) {
        String prefix = this.config.http().useSimulationAsPrefix() ? simulationClass : "request";
        String postfix = this.config.http().useMethodAndUriAsPostfix() ? ":" + RequestTemplate$.MODULE$.sanitizeRequestPostfix(request.method() + "_" + request.uri()) : "";
        return package$TemplateString$.MODULE$.noEmptyLines$extension(package$.MODULE$.TemplateString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("http(\"" + prefix + "_" + request.id() + postfix + "\")\n       |  ." + this.renderMethod(request, extractedUri) + "\n       |  " + this.renderHeaders(request) + "\n       |  " + this.renderBodyOrParams(request) + "\n       |  " + this.renderBasicAuthCredentials(request) + "\n       |  " + this.renderStatusCheck(request) + "\n       |  " + this.renderResponseBodyCheck(request) + "\n       |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderResources(simulationClass, request, extractedUri)), 2)))));
    }

    private final String renderLongString$1(String value) {
        if (value.length() > RequestTemplate$.MODULE$.io$gatling$recorder$render$template$RequestTemplate$$MaxLiteralSize()) {
            return "Seq(" + StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(value), RequestTemplate$.MODULE$.io$gatling$recorder$render$template$RequestTemplate$$MaxLiteralSize()).map((Function1 & Serializable)x$1 -> package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString((String)x$1), this.format())).mkString(", ") + ").mkString";
        }
        return package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(value), this.format());
    }

    public RequestTemplate(Map<Object, DumpedBody> requestBodies, Map<Object, DumpedBody> responseBodies, RecorderConfiguration config) {
        this.requestBodies = requestBodies;
        this.responseBodies = responseBodies;
        this.config = config;
        this.format = config.core().format();
        RenderingFormat renderingFormat = this.format();
        this.isCheck = RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat) ? "shouldBe" : "is";
    }
}

