/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.har;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.filter.Filters;
import io.gatling.core.filter.Filters$;
import io.gatling.recorder.har.HarParser;
import io.gatling.recorder.har.HarParser$;
import io.gatling.recorder.har.HttpTransaction;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.AsciiString;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Locale;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

public final class HarReader$ {
    public static final HarReader$ MODULE$ = new HarReader$();
    private static final Regex WrappedValue = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"(.*)\""));

    public Seq<HttpTransaction> readFile(String path, Option<Filters> filters) {
        return (Seq)Using$.MODULE$.resource((Object)new BufferedInputStream(new FileInputStream(path)), (Function1 & Serializable)x$1 -> MODULE$.readStream((InputStream)x$1, filters), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Seq<HttpTransaction> readStream(InputStream is, Option<Filters> filters) {
        Seq<HarParser.HarEntry> harEntries = HarParser$.MODULE$.parseHarEntries(is);
        Seq filteredHarEntries = (Seq)harEntries.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)filters.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$readStream$2(entry, x$2)))));
        return this.buildHttpTransactions((Seq<HarParser.HarEntry>)filteredHarEntries);
    }

    private long parseMillisFromIso8601DateTime(String time) {
        return ZonedDateTime.parse(time).toInstant().toEpochMilli();
    }

    private Seq<HttpTransaction> buildHttpTransactions(Seq<HarParser.HarEntry> harEntries) {
        return (Seq)harEntries.iterator().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$1(x$3))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$2(x$4))).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$3(entry))).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)HarReader$.MODULE$.isValidURL(entry.request().url()))).map((Function1 & Serializable)entry -> MODULE$.buildHttpTransaction((HarParser.HarEntry)entry)).toVector().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)HarReader$.$anonfun$buildHttpTransactions$7(x$5)), (Ordering)Ordering.Long$.MODULE$);
    }

    private boolean isValidURL(String url) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new URL(url)).isSuccess();
    }

    private HttpTransaction buildHttpTransaction(HarParser.HarEntry entry) {
        long start = this.parseMillisFromIso8601DateTime(entry.startedDateTime());
        long time = (long)BoxesRunTime.unboxToDouble((Object)entry.time().orElse((Function0 & Serializable)() -> entry.timings().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6.time()))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Neither time nor timings");
        }));
        long end = start + time;
        return new HttpTransaction(this.buildRequest(entry.request(), start), this.buildResponse(entry.response(), end));
    }

    private Regex WrappedValue() {
        return WrappedValue;
    }

    private String unwrap(String raw) {
        String unwrapped;
        Option option;
        String string = raw;
        String string2 = string != null && !(option = this.WrappedValue().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 ? (unwrapped = (String)((LinearSeqOps)option.get()).apply(0)) : raw;
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private HttpHeaders buildHeaders(Seq<HarParser.HarHeader> harHeaders) {
        void var2_2;
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        harHeaders.foreach((Function1 & Serializable)harHeader -> headers.add(harHeader.name(), (Object)MODULE$.unwrap(harHeader.value())));
        return var2_2;
    }

    private HttpRequest buildRequest(HarParser.HarRequest request, long timestamp) {
        HttpHeaders headers = this.buildHeaders(request.headers());
        byte[] body = (byte[])request.postData().flatMap((Function1 & Serializable)x$7 -> MODULE$.buildRequestBody((HarParser.HarRequestPostData)x$7, headers)).getOrElse((Function0 & Serializable)() -> (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()));
        return new HttpRequest(request.httpVersion(), request.method(), request.url(), headers, body, timestamp);
    }

    private String encode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
    }

    private Option<byte[]> buildRequestBody(HarParser.HarRequestPostData postData, HttpHeaders requestHeaders) {
        None$ none$;
        Option option = postData.text().flatMap((Function1 & Serializable)x$8 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$8)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.value();
            none$ = new Some((Object)string.getBytes(StandardCharsets.UTF_8));
        } else {
            none$ = postData.params().nonEmpty() && Option$.MODULE$.apply((Object)requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildRequestBody$2(x$9))) ? new Some((Object)((IterableOnceOps)postData.params().map((Function1 & Serializable)postParam -> new StringBuilder(1).append(MODULE$.encode(postParam.name())).append("=").append(MODULE$.encode(MODULE$.unwrap(postParam.value()))).toString())).mkString("&").getBytes(StandardCharsets.UTF_8)) : None$.MODULE$;
        }
        return none$;
    }

    private HttpResponse buildResponse(HarParser.HarResponse response, long timestamp) {
        return new HttpResponse(response.status(), response.statusText(), this.buildHeaders(response.headers()), (byte[])this.buildResponseBody(response.content()).getOrElse((Function0 & Serializable)() -> (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), timestamp);
    }

    private Option<byte[]> buildResponseBody(HarParser.HarResponseContent content) {
        return content.text().flatMap((Function1 & Serializable)x$10 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$10))).withFilter((Function1 & Serializable)text -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildResponseBody$2(content, text))).withFilter((Function1 & Serializable)text -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildResponseBody$3(content, text))).map((Function1 & Serializable)text -> {
            Some some;
            String string;
            Option option = content.encoding().flatMap((Function1 & Serializable)x$11 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$11)));
            byte[] byArray = option instanceof Some && "base64".equals(string = (String)(some = (Some)option).value()) ? Base64.getDecoder().decode((String)text) : text.getBytes(StandardCharsets.UTF_8);
            return byArray;
        });
    }

    public static final /* synthetic */ boolean $anonfun$readStream$2(HarParser.HarEntry entry$1, Filters x$2) {
        return x$2.accept(entry$1.request().url()) && Filters$.MODULE$.BrowserNoiseFilters().accept(entry$1.request().url());
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$1(HarParser.HarEntry x$3) {
        return x$3.response().status() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$2(HarParser.HarEntry x$4) {
        return x$4.request().url().toString().toLowerCase(Locale.ROOT).startsWith("http");
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$4(HarParser.HarHeader header) {
        return AsciiString.contentEqualsIgnoreCase((CharSequence)header.name(), (CharSequence)HttpHeaderValues.UPGRADE);
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$3(HarParser.HarEntry entry) {
        String string = entry.request().method();
        String string2 = HttpMethod.CONNECT.name();
        return (string == null ? string2 != null : !string.equals(string2)) && !entry.request().headers().exists((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$4(header)));
    }

    public static final /* synthetic */ long $anonfun$buildHttpTransactions$7(HttpTransaction x$5) {
        return x$5.request().timestamp();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequestBody$2(String x$9) {
        return AsciiString.contains((CharSequence)x$9, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
    }

    public static final /* synthetic */ boolean $anonfun$buildResponseBody$2(HarParser.HarResponseContent content$1, String text) {
        return !content$1.mimeType().contains((Object)"x-unknown");
    }

    public static final /* synthetic */ boolean $anonfun$buildResponseBody$3(HarParser.HarResponseContent content$1, String text) {
        return content$1.comment().isEmpty();
    }

    private HarReader$() {
    }
}

