/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.scanner;

import io.gatling.internal.asm.ClassReader;
import io.gatling.internal.asm.ClassVisitor;
import io.gatling.internal.asm.tree.ClassNode;
import io.gatling.scanner.AsmClass;
import io.gatling.scanner.HighestJavaVersionClass;
import io.gatling.scanner.SimulationScanResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class AsmSimulationScanner {
    private static final String MODULE_INFO_NAME = "module-info";
    private static final String JAR_ENTRY_CLASS_SUFFIX = ".class";
    private static final byte[] JAVA_CLASS_MAGIC_BYTES = new byte[]{-54, -2, -70, -66};
    private static final String ROOT_CLASS_NAME = "java/lang/Object";
    private static final List<String> SIMULATION_CLASSES = Arrays.asList("io/gatling/javaapi/core/Simulation", "io/gatling/core/scenario/Simulation");
    private static final byte[] TO_BYTE_ARRAY_BUFFER = new byte[8192];

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n;
            while ((n = inputStream.read(TO_BYTE_ARRAY_BUFFER)) != -1) {
                byteArrayOutputStream.write(TO_BYTE_ARRAY_BUFFER, 0, n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static Optional<byte[]> bytesFromJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarEntry.getName().endsWith(JAR_ENTRY_CLASS_SUFFIX)) {
            return Optional.of(AsmSimulationScanner.toByteArray(new BufferedInputStream(jarFile.getInputStream(jarEntry))));
        }
        return Optional.empty();
    }

    private static boolean checkJavaClassMagicBytes(byte[] byArray) {
        if (byArray.length < JAVA_CLASS_MAGIC_BYTES.length) {
            return false;
        }
        for (int i = 0; i < JAVA_CLASS_MAGIC_BYTES.length; ++i) {
            if (byArray[i] == JAVA_CLASS_MAGIC_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    private static Optional<ClassNode> classNodeFromBytes(byte[] byArray) {
        if (AsmSimulationScanner.checkJavaClassMagicBytes(byArray)) {
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 1);
            return Optional.of(classNode);
        }
        return Optional.empty();
    }

    private static Optional<AsmClass> candidateFromJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        return AsmSimulationScanner.bytesFromJarEntry(jarFile, jarEntry).flatMap(AsmSimulationScanner::classNodeFromBytes).filter(classNode -> !classNode.name.equals(MODULE_INFO_NAME) && classNode.superName != null && !classNode.superName.equals(ROOT_CLASS_NAME)).map(AsmClass::new);
    }

    private static Map.Entry<AsmClass, Map<String, AsmClass>> candidatesWithHighestJavaVersion(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        HashMap<String, AsmClass> hashMap = new HashMap<String, AsmClass>();
        AsmClass asmClass = null;
        while (enumeration.hasMoreElements()) {
            AsmClass asmClass2 = AsmSimulationScanner.candidateFromJarEntry(jarFile, enumeration.nextElement()).orElse(null);
            if (asmClass2 == null) continue;
            hashMap.put(asmClass2.name, asmClass2);
            if (asmClass != null && asmClass.javaVersion >= asmClass2.javaVersion) continue;
            asmClass = asmClass2;
        }
        return new AbstractMap.SimpleEntry(asmClass, hashMap);
    }

    private static boolean isAncestorSimulation(AsmClass asmClass2, Map<String, AsmClass> map) {
        return SIMULATION_CLASSES.contains(asmClass2.parentName) || Optional.ofNullable(map.get(asmClass2.parentName)).map(asmClass -> AsmSimulationScanner.isAncestorSimulation(asmClass, map)).orElse(false) != false;
    }

    public static SimulationScanResult scan(JarFile jarFile) throws IOException {
        Map.Entry<AsmClass, Map<String, AsmClass>> entry = AsmSimulationScanner.candidatesWithHighestJavaVersion(jarFile);
        HighestJavaVersionClass highestJavaVersionClass = Optional.ofNullable(entry.getKey()).map(asmClass -> new HighestJavaVersionClass(asmClass.name, asmClass.javaVersion)).orElse(null);
        Map<String, AsmClass> map = entry.getValue();
        List<String> list = map.values().stream().filter(asmClass -> asmClass.concrete && AsmSimulationScanner.isAncestorSimulation(asmClass, map)).map(AsmClass::fullyQualifiedName).collect(Collectors.toList());
        return new SimulationScanResult(list, highestJavaVersionClass);
    }

    public static SimulationScanResult scan(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            SimulationScanResult simulationScanResult = AsmSimulationScanner.scan(jarFile);
            return simulationScanResult;
        }
    }
}

