/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.pool;

import io.gatling.http.client.proxy.HttpProxyServer;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.uri.Uri;

public class RemoteKey {
    private final String targetHostBaseUrl;
    private final String virtualHost;
    private final String proxyHost;
    private final int proxyPort;

    public static RemoteKey newKey(Uri uri, String string, ProxyServer proxyServer) {
        String string2 = uri.getBaseUrl();
        if (proxyServer == null) {
            return new RemoteKey(string2, string, null, 0);
        }
        return new RemoteKey(string2, string, proxyServer.getHost(), uri.isSecured() && proxyServer instanceof HttpProxyServer ? ((HttpProxyServer)proxyServer).getSecuredPort() : proxyServer.getPort());
    }

    private RemoteKey(String string, String string2, String string3, int n) {
        this.targetHostBaseUrl = string;
        this.virtualHost = string2;
        this.proxyHost = string3;
        this.proxyPort = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RemoteKey remoteKey = (RemoteKey)object;
        if (this.proxyPort != remoteKey.proxyPort) {
            return false;
        }
        if (!this.targetHostBaseUrl.equals(remoteKey.targetHostBaseUrl)) {
            return false;
        }
        if (this.virtualHost != null ? !this.virtualHost.equals(remoteKey.virtualHost) : remoteKey.virtualHost != null) {
            return false;
        }
        return this.proxyHost != null ? this.proxyHost.equals(remoteKey.proxyHost) : remoteKey.proxyHost == null;
    }

    public int hashCode() {
        int n = this.targetHostBaseUrl.hashCode();
        n = 31 * n + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
        n = 31 * n + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        n = 31 * n + this.proxyPort;
        return n;
    }

    public String toString() {
        return "RemoteKey{targetHostBaseUrl='" + this.targetHostBaseUrl + '\'' + ", virtualHost='" + this.virtualHost + '\'' + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
    }
}

