/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005I3Qa\u0003\u0007\u0003\u001dYA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tU\u0001\u0011\t\u0011)A\u0005;!A1\u0006\u0001B\u0001B\u0003%Q\u0004\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b9\u0003A\u0011I(\t\u000bA\u0003A\u0011B(\t\u000bE\u0003A\u0011I(\u0003)\r{WO\u001c;t!\u0016\u00148+Z2UK6\u0004H.\u0019;f\u0015\tia\"\u0001\u0005uK6\u0004H.\u0019;f\u0015\ty\u0001#\u0001\u0006iS\u001eD7\r[1siNT!!\u0005\n\u0002\r\rD\u0017M\u001d;t\u0015\t\u0019B#A\u0004hCRd\u0017N\\4\u000b\u0003U\t!![8\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u0005a\u0011B\u0001\u000e\r\u0005!!V-\u001c9mCR,\u0017AC2iCJ$H+\u001b;mK\u000e\u0001\u0001C\u0001\u0010(\u001d\tyR\u0005\u0005\u0002!G5\t\u0011E\u0003\u0002#9\u00051AH]8pizR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011aeI\u0001\u000bs\u0006C\u0018n\u001d+ji2,\u0017!D2p]R\f\u0017N\\3s\u001d\u0006lW-\u0001\u0005sk:\u001cF/\u0019:u!\tqs&D\u0001$\u0013\t\u00014E\u0001\u0003M_:<\u0017AC2pk:$8\u000fR1uCB\u00191\u0007O\u001e\u000f\u0005Q2dB\u0001\u00116\u0013\u0005!\u0013BA\u001c$\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\u0007M+\u0017O\u0003\u00028GA\u0011AhP\u0007\u0002{)\u0011a\bE\u0001\u0006gR\fGo]\u0005\u0003\u0001v\u0012\u0001cQ8v]R\u001chk\u001d+j[\u0016\u0004Fn\u001c;\u0002\r!\f7\u000fU5f!\tq3)\u0003\u0002EG\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0004H\u0011&S5\nT'\u0011\u0005a\u0001\u0001\"B\u000e\b\u0001\u0004i\u0002\"\u0002\u0016\b\u0001\u0004i\u0002\"B\u0016\b\u0001\u0004i\u0002\"\u0002\u0017\b\u0001\u0004i\u0003\"B\u0019\b\u0001\u0004\u0011\u0004\"B!\b\u0001\u0004\u0011\u0015A\u00016t+\u0005i\u0012\u0001\u0007:f]\u0012,'oQ8v]R\u001c\b+\u001a:TK\u000e\u001cVM]5fg\u0006!\u0001\u000e^7m\u0001")
public final class CountsPerSecTemplate
extends Template {
    private final String chartTitle;
    private final String yAxisTitle;
    private final String containerName;
    private final long runStart;
    private final Seq<CountsVsTimePlot> countsData;
    private final boolean hasPie;

    @Override
    public String js() {
        return "\nnew Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerName + "',\n    zoomType: 'x',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: -65,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  rangeSelector: {\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n         },\n         select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  plotOptions: {\n    series: {\n      dataGrouping: { enabled: false }\n    },\n    area: {\n      stacking: 'normal'\n    }\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis:[\n    {\n      min: 0,\n      title: { text: '" + this.yAxisTitle + "' },\n      opposite: false,\n      reversedStacks: false\n    }\n  ],\n  series: [\n    " + this.renderCountsPerSecSeries() + "\n  ]\n});\n";
    }

    private String renderCountsPerSecSeries() {
        if (this.hasPie) {
            return this.renderCountsPerSecSeries$1((Function1 & Serializable)plot -> BoxesRunTime.boxToInteger((int)CountsPerSecTemplate.$anonfun$renderCountsPerSecSeries$4(plot)), Series$.MODULE$.All(), Color.Requests$.MODULE$.All(), false) + ",\n" + this.renderCountsPerSecSeries$1((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.oks()), Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok(), true) + ",\n" + this.renderCountsPerSecSeries$1((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.kos()), Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko(), true) + ",\n" + this.renderPieSeries$1();
        }
        return String.valueOf(this.renderCountsPerSecSeries$1((Function1 & Serializable)plot -> BoxesRunTime.boxToInteger((int)CountsPerSecTemplate.$anonfun$renderCountsPerSecSeries$7(plot)), Series$.MODULE$.All(), Color.Requests$.MODULE$.All(), true));
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n                <div id=\"" + this.containerName + "\" class=\"geant\"></div>\n            </div>\n";
    }

    private final String renderCountsPerSecSeries$1(Function1 f, String name, Color color, boolean area) {
        return "{\ncolor: '" + color + "',\nname: '" + name + "',\ndata: " + ((IterableOnceOps)this.countsData.map((Function1 & Serializable)plot -> "[" + ($this.runStart + (long)plot.time()) + ", " + f.apply(plot) + "]")).mkString("[", ", ", "]") + ",\ntooltip: { yDecimals: 0, ySuffix: '', valueDecimals: 0 }\n" + (area ? ",type: 'area'" : "") + "\n}";
    }

    private final String renderPieSeries$1() {
        return "{\ntype: 'pie',\nname: '" + Series$.MODULE$.Distribution() + "',\ndata: [\n  {name: '" + Series$.MODULE$.OK() + "', y: " + Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(this.countsData), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.oks()), (Numeric)Numeric.IntIsIntegral$.MODULE$) + ", color: '" + Color.Requests$.MODULE$.Ok() + "'},\n  {name: '" + Series$.MODULE$.KO() + "', y: " + Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(this.countsData), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.kos()), (Numeric)Numeric.IntIsIntegral$.MODULE$) + ", color: '" + Color.Requests$.MODULE$.Ko() + "'}\n],\ncenter: [775, -40],\nsize: 70,\nshowInLegend: false,\ndataLabels: { enabled: false },\ndataGrouping: { enabled: false }\n}";
    }

    public static final /* synthetic */ int $anonfun$renderCountsPerSecSeries$4(CountsVsTimePlot plot) {
        return plot.oks() + plot.kos();
    }

    public static final /* synthetic */ int $anonfun$renderCountsPerSecSeries$7(CountsVsTimePlot plot) {
        return plot.oks() + plot.kos();
    }

    public CountsPerSecTemplate(String chartTitle, String yAxisTitle, String containerName, long runStart, Seq<CountsVsTimePlot> countsData, boolean hasPie) {
        this.chartTitle = chartTitle;
        this.yAxisTitle = yAxisTitle;
        this.containerName = containerName;
        this.runStart = runStart;
        this.countsData = countsData;
        this.hasPie = hasPie;
    }
}

