/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005U3Qa\u0003\u0007\u0003\u001dYA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tU\u0001\u0011\t\u0011)A\u0005;!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d9\u0005A1A\u0005\n!Ca\u0001\u0015\u0001!\u0002\u0013I\u0005\"B)\u0001\t\u0003\u0012\u0006\"B*\u0001\t\u0013\u0011\u0006\"\u0002+\u0001\t\u0003\u0012&a\u0007)fe\u000e,g\u000e^5mKN|e/\u001a:US6,G+Z7qY\u0006$XM\u0003\u0002\u000e\u001d\u0005AA/Z7qY\u0006$XM\u0003\u0002\u0010!\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005E\u0011\u0012AB2iCJ$8O\u0003\u0002\u0014)\u00059q-\u0019;mS:<'\"A\u000b\u0002\u0005%|7C\u0001\u0001\u0018!\tA\u0012$D\u0001\r\u0013\tQBB\u0001\u0005UK6\u0004H.\u0019;f\u0003\u0015!\u0018\u000e\u001e7f\u0007\u0001\u0001\"AH\u0014\u000f\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u001d\u0003\u0019a$o\\8u})\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13%A\u0005z\u0003bL7OT1nK\u0006A!/\u001e8Ti\u0006\u0014H\u000f\u0005\u0002.]5\t1%\u0003\u00020G\t!Aj\u001c8h\u0003\u0011!\u0017\r^1\u0011\u0007I:$H\u0004\u00024k9\u0011\u0001\u0005N\u0005\u0002I%\u0011agI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014HA\u0002TKFT!AN\u0012\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0002\u0012!B:uCR\u001c\u0018BA =\u0005U\u0001VM]2f]RLG.Z:WgRKW.\u001a)m_R\fa\u0001P5oSRtD#\u0002\"D\t\u00163\u0005C\u0001\r\u0001\u0011\u0015YR\u00011\u0001\u001e\u0011\u0015QS\u00011\u0001\u001e\u0011\u0015YS\u00011\u0001-\u0011\u0015\u0001T\u00011\u00012\u0003-\u0019wN\u001c;bS:,'/\u00133\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\tA3*\u0001\u0007d_:$\u0018-\u001b8fe&#\u0007%\u0001\u0002kgV\tQ$A\fsK:$WM\u001d)fe\u000e,g\u000e^5mKN\u001cVM]5fg\u0006!\u0001\u000e^7m\u0001")
public final class PercentilesOverTimeTemplate
extends Template {
    private final String title;
    private final String yAxisName;
    private final long runStart;
    private final Seq<PercentilesVsTimePlot> data;
    private final String containerId;

    private String containerId() {
        return this.containerId;
    }

    @Override
    public String js() {
        return "\nnew Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerId() + "',\n    zoomType: 'x',\n    marginBottom: 60\n  },\n  colors: [" + Color.Requests$.MODULE$.Percentiles().map((Function1 & Serializable)color -> "'" + color + "'").mkString(", ") + "],\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: -65,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title chart_title_\">" + this.title + "</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false,\n    baseSeries: 9\n  },\n  rangeSelector: {\n    rangeSelector: { align: \"left\" },\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis:[\n    {\n      min: 0,\n      title: { text: '" + this.yAxisName + " (ms)' },\n      opposite: false\n    }\n  ],\n  plotOptions: {\n    arearange: { lineWidth: 1 },\n    series: {\n      dataGrouping: { enabled: false }\n    }\n  },\n  series: [\n  " + this.renderPercentilesSeries() + "\n  ]\n});\n";
    }

    private String renderPercentilesSeries() {
        if (this.data.nonEmpty()) {
            return "\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.percentile0()), "min", 10) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.percentile25()), "25%", 9) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.percentile50()), "50%", 8) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.percentile75()), "75%", 7) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.percentile80()), "80%", 6) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.percentile85()), "85%", 5) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.percentile90()), "90%", 4) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.percentile95()), "95%", 3) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.percentile99()), "99%", 2) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.percentile100()), "max", 1) + "}";
        }
        return "";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId() + "\" class=\"geant\"></div>\n            </div>\n";
    }

    private final String renderPercentileSeries$1(Function1 f, String name, int zIndex) {
        return "\npointInterval: 1000,\nname: '" + name + "',\ndata: " + ((IterableOnceOps)this.data.map((Function1 & Serializable)plot -> "[" + this.truncateTimestampToSecond($this.runStart + (long)plot.time()) + ", " + plot.percentiles().map((Function1 & Serializable)percentiles -> f.apply(percentiles).toString()).getOrElse((Function0 & Serializable)() -> "null") + "]")).mkString("[", ", ", "]") + ",\ntooltip: { yDecimals: 0, ySuffix: 'ms' },\ntype : 'area',\nyAxis: 0,\nzIndex: " + zIndex + "\n";
    }

    public PercentilesOverTimeTemplate(String title, String yAxisName, long runStart, Seq<PercentilesVsTimePlot> data) {
        this.title = title;
        this.yAxisName = yAxisName;
        this.runStart = runStart;
        this.data = data;
        this.containerId = title.replaceAll("[ ()]", "").toLowerCase(Locale.ROOT) + "PercentilesContainer";
    }
}

