/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005I3Qa\u0003\u0007\u0003\u001dYA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tU\u0001\u0011\t\u0011)A\u0005;!A1\u0006\u0001B\u0001B\u0003%Q\u0004\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b9\u0003A\u0011I(\t\u000bA\u0003A\u0011B(\t\u000bE\u0003A\u0011I(\u0003)\r{WO\u001c;t!\u0016\u00148+Z2UK6\u0004H.\u0019;f\u0015\tia\"\u0001\u0005uK6\u0004H.\u0019;f\u0015\ty\u0001#\u0001\u0006iS\u001eD7\r[1siNT!!\u0005\n\u0002\r\rD\u0017M\u001d;t\u0015\t\u0019B#A\u0004hCRd\u0017N\\4\u000b\u0003U\t!![8\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u0005a\u0011B\u0001\u000e\r\u0005!!V-\u001c9mCR,\u0017aC2p]R\f\u0017N\\3s\u0013\u0012\u001c\u0001\u0001\u0005\u0002\u001fO9\u0011q$\n\t\u0003A\rj\u0011!\t\u0006\u0003Eq\ta\u0001\u0010:p_Rt$\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u0012\u0002\u0015\rD\u0017M\u001d;USRdW-\u0001\u0006z\u0003bL7\u000fV5uY\u0016\f\u0001B];o'R\f'\u000f\u001e\t\u0003]=j\u0011aI\u0005\u0003a\r\u0012A\u0001T8oO\u0006Q1m\\;oiN$\u0015\r^1\u0011\u0007MB4H\u0004\u00025m9\u0011\u0001%N\u0005\u0002I%\u0011qgI\u0001\ba\u0006\u001c7.Y4f\u0013\tI$HA\u0002TKFT!aN\u0012\u0011\u0005qzT\"A\u001f\u000b\u0005y\u0002\u0012!B:uCR\u001c\u0018B\u0001!>\u0005A\u0019u.\u001e8ugZ\u001bH+[7f!2|G/\u0001\u0004iCN\u0004\u0016.\u001a\t\u0003]\rK!\u0001R\u0012\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"ra\u0012%J\u0015.cU\n\u0005\u0002\u0019\u0001!)1d\u0002a\u0001;!)!f\u0002a\u0001;!)1f\u0002a\u0001;!)Af\u0002a\u0001[!)\u0011g\u0002a\u0001e!)\u0011i\u0002a\u0001\u0005\u0006\u0011!n]\u000b\u0002;\u0005A\"/\u001a8eKJ\u001cu.\u001e8ugB+'oU3d'\u0016\u0014\u0018.Z:\u0002\t!$X\u000e\u001c")
public final class CountsPerSecTemplate
extends Template {
    private final String containerId;
    private final String chartTitle;
    private final String yAxisTitle;
    private final long runStart;
    private final Seq<CountsVsTimePlot> countsData;
    private final boolean hasPie;

    @Override
    public String js() {
        return "\nnew Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    zoomType: 'x',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: -65,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  rangeSelector: {\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n         },\n         select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  plotOptions: {\n    series: {\n      dataGrouping: { enabled: false }\n    },\n    area: {\n      stacking: 'normal'\n    }\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis:[\n    {\n      min: 0,\n      title: { text: '" + this.yAxisTitle + "' },\n      opposite: false,\n      reversedStacks: false\n    }\n  ],\n  series: [\n    " + this.renderCountsPerSecSeries() + "\n  ]\n});\n";
    }

    private String renderCountsPerSecSeries() {
        if (this.hasPie) {
            return this.renderCountsPerSecSeries$1((Function1 & Serializable)plot -> BoxesRunTime.boxToInteger((int)CountsPerSecTemplate.$anonfun$renderCountsPerSecSeries$4(plot)), Series$.MODULE$.All(), Color.Requests$.MODULE$.All(), false) + ",\n" + this.renderCountsPerSecSeries$1((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.oks()), Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok(), true) + ",\n" + this.renderCountsPerSecSeries$1((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.kos()), Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko(), true) + ",\n" + this.renderPieSeries$1();
        }
        return String.valueOf(this.renderCountsPerSecSeries$1((Function1 & Serializable)plot -> BoxesRunTime.boxToInteger((int)CountsPerSecTemplate.$anonfun$renderCountsPerSecSeries$7(plot)), Series$.MODULE$.All(), Color.Requests$.MODULE$.All(), true));
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n                <div id=\"" + this.containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }

    private final String renderCountsPerSecSeries$1(Function1 f, String name, Color color, boolean area) {
        return "{\ncolor: '" + color + "',\nname: '" + name + "',\ndata: " + ((IterableOnceOps)this.countsData.map((Function1 & Serializable)plot -> "[" + this.truncateTimestampToSecond($this.runStart + (long)plot.time()) + ", " + f.apply(plot) + "]")).mkString("[", ", ", "]") + ",\ntooltip: { yDecimals: 0, ySuffix: '', valueDecimals: 0 }\n" + (area ? ",type: 'area'" : "") + "\n}";
    }

    private final String renderPieSeries$1() {
        return "{\ntype: 'pie',\nname: '" + Series$.MODULE$.Distribution() + "',\ndata: [\n  {name: '" + Series$.MODULE$.OK() + "', y: " + Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(this.countsData), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.oks()), (Numeric)Numeric.IntIsIntegral$.MODULE$) + ", color: '" + Color.Requests$.MODULE$.Ok() + "'},\n  {name: '" + Series$.MODULE$.KO() + "', y: " + Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable(this.countsData), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.kos()), (Numeric)Numeric.IntIsIntegral$.MODULE$) + ", color: '" + Color.Requests$.MODULE$.Ko() + "'}\n],\ncenter: [775, -40],\nsize: 70,\nshowInLegend: false,\ndataLabels: { enabled: false },\ndataGrouping: { enabled: false }\n}";
    }

    public static final /* synthetic */ int $anonfun$renderCountsPerSecSeries$4(CountsVsTimePlot plot) {
        return plot.oks() + plot.kos();
    }

    public static final /* synthetic */ int $anonfun$renderCountsPerSecSeries$7(CountsVsTimePlot plot) {
        return plot.oks() + plot.kos();
    }

    public CountsPerSecTemplate(String containerId, String chartTitle, String yAxisTitle, long runStart, Seq<CountsVsTimePlot> countsData, boolean hasPie) {
        this.containerId = containerId;
        this.chartTitle = chartTitle;
        this.yAxisTitle = yAxisTitle;
        this.runStart = runStart;
        this.countsData = countsData;
        this.hasPie = hasPie;
    }
}

