/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.highcharts.template;

import io.gatling.charts.report.Container$;
import io.gatling.highcharts.template.Template;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E2Aa\u0002\u0005\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\t\r9\u0002\u0001\u0015!\u0003$\u0011\u001dy\u0003A1A\u0005\u0002\tBa\u0001\r\u0001!\u0002\u0013\u0019#\u0001\u0007(v[\n,'o\u00144SKF,Xm\u001d;t)\u0016l\u0007\u000f\\1uK*\u0011\u0011BC\u0001\ti\u0016l\u0007\u000f\\1uK*\u00111\u0002D\u0001\u000bQ&<\u0007n\u00195beR\u001c(BA\u0007\u000f\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aD\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0011%\u0011Q\u0003\u0003\u0002\t)\u0016l\u0007\u000f\\1uK\u0006!b.^7cKJ|eMU3rk\u0016\u001cHOT1nKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u00111!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u0003'\u0001AQA\u0006\u0002A\u0002]\t!A[:\u0016\u0003\r\u0002\"\u0001J\u0016\u000f\u0005\u0015J\u0003C\u0001\u0014\u001a\u001b\u00059#B\u0001\u0015\u0011\u0003\u0019a$o\\8u}%\u0011!&G\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+3\u0005\u0019!n\u001d\u0011\u0002\t!$X\u000e\\\u0001\u0006QRlG\u000e\t")
public class NumberOfRequestsTemplate
extends Template {
    private final String js;
    private final String html;

    @Override
    public String js() {
        return this.js;
    }

    @Override
    public String html() {
        return this.html;
    }

    public NumberOfRequestsTemplate(int numberOfRequestNames) {
        this.js = new StringBuilder(1577).append("\nfunction numberOfRequestsDataForGroup(group) {\n  var data = {names: [], oks: [], kos: []};\n\n  $.each(group.contents, function(contentName, content) {\n    if (content.type == '").append(Container$.MODULE$.Group()).append("') {\n      var result = numberOfRequestsDataForGroup(content);\n      data.names = data.names.concat(result.names);\n      data.oks = data.oks.concat(result.oks);\n      data.kos = data.kos.concat(result.kos);\n    }\n    else if (content.type == '").append(Container$.MODULE$.Request()).append("') {\n      data.names.push(content.path);\n      data.oks.push(parseInt(content.stats.numberOfRequests.ok));\n      data.kos.push(parseInt(content.stats.numberOfRequests.ko));\n    }\n  });\n\n  return data;\n}\n\nvar numberOfRequestsData = numberOfRequestsDataForGroup(stats);\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo:'container_number_of_requests',\n    polar:true,\n    type:'column',\n    height:330\n  },\n  credits:{\n    enabled:false\n  },\n  title:{\n    text:'<span class=\"chart_title\">Number of requests</span>',\n    useHTML: true\n  },\n  xAxis:{\n    tickmarkPlacement:'on',\n    tickInterval: ").append((int)package$.MODULE$.ceil((double)numberOfRequestNames / (double)1000)).append(",\n    categories:numberOfRequestsData.names,\n    labels:{ enabled:false }\n  },\n  yAxis:{\n    min:0\n  },\n  plotOptions:{\n    series:{\n      stacking:'normal',\n      groupPadding:0,\n      pointPlacement:'on',\n      shadow: true\n    }\n  },\n  legend: {\n    \tborderWidth: 0.5,\n      borderRadius: 3,\n      borderColor: 'black',\n      itemStyle: { fontWeight: \"normal\" }\n  },\n  series:[\n    {\n      name:'KO',\n      data:numberOfRequestsData.kos,\n      color:\"#FF0000\"\n    },\n    {\n      name:'OK',\n      data:numberOfRequestsData.oks,\n      color:\"#4572A7\"\n    }\n  ]\n});\n").toString();
        this.html = "\n            <div class=\"schema polar\">\n              <div id=\"container_number_of_requests\"></div>\n            </div>\n";
    }
}

