/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.highcharts.template;

import io.gatling.charts.util.Colors;
import io.gatling.highcharts.series.NumberPerSecondSeries;
import io.gatling.highcharts.template.Template;
import io.gatling.highcharts.template.Template$;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005y2AAB\u0004\u0001!!AQ\u0003\u0001B\u0001B\u0003%a\u0003\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015\u0019\u0004\u0001\"\u00115\u0011\u0015i\u0004\u0001\"\u00115\u0005M\t5\r^5wKV\u001bXM]:UK6\u0004H.\u0019;f\u0015\tA\u0011\"\u0001\u0005uK6\u0004H.\u0019;f\u0015\tQ1\"\u0001\u0006iS\u001eD7\r[1siNT!\u0001D\u0007\u0002\u000f\u001d\fG\u000f\\5oO*\ta\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\b\u0013\t!rA\u0001\u0005UK6\u0004H.\u0019;f\u0003!\u0011XO\\*uCJ$\bCA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"\u0001\u0002'p]\u001e\faa]3sS\u0016\u001c\bc\u0001\u0010'S9\u0011q\u0004\n\b\u0003A\rj\u0011!\t\u0006\u0003E=\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005\u0015B\u0012a\u00029bG.\fw-Z\u0005\u0003O!\u00121aU3r\u0015\t)\u0003\u0004\u0005\u0002+Y5\t1F\u0003\u0002\u001d\u0013%\u0011Qf\u000b\u0002\u0016\u001dVl'-\u001a:QKJ\u001cVmY8oIN+'/[3t\u0003\u0019a\u0014N\\5u}Q\u0019\u0001'\r\u001a\u0011\u0005I\u0001\u0001\"B\u000b\u0004\u0001\u00041\u0002\"\u0002\u000f\u0004\u0001\u0004i\u0012A\u00016t+\u0005)\u0004C\u0001\u001c;\u001d\t9\u0004\b\u0005\u0002!1%\u0011\u0011\bG\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:1\u0005!\u0001\u000e^7m\u0001")
public class ActiveUsersTemplate
extends Template {
    private final long runStart;
    private final Seq<NumberPerSecondSeries> series;

    @Override
    public String js() {
        return new StringBuilder(1667).append("\nallUsersData.yAxis = 0;\n\nvar allUsersChart = new Highcharts.StockChart({\n  chart: {\n    renderTo: 'container_active_users',\n    zoomType: 'x'\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    align: 'right',\n    verticalAlign: 'top',\n    layout: 'vertical',\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" }\n  },\n  title: { text: 'A title to let highcharts reserve the place for the title set later' },\n  rangeSelector: {\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '").append(Colors.LightGrey$.MODULE$).append("',\n      padding: 1,\n      stroke: '").append(Colors.Black$.MODULE$).append("',\n      'stroke-width': 0.25,\n      style: {\n        color: '").append(Colors.Black$.MODULE$).append("',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '").append(Colors.Black$.MODULE$).append("',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '").append(Colors.DarkGrey$.MODULE$).append("',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '").append(Colors.DarkOrange$.MODULE$).append("',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis: {\n    title: { text: 'Number of Active Users' },\n    opposite: false,\n    min: 0\n  },\n  series: [\n    ").append(((IterableOnceOps)this.series.flatMap((Function1 & Serializable)serie -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"{", Template$.MODULE$.renderUsersPerSecondSeries($this.runStart, (NumberPerSecondSeries)serie), "},\n"})))).mkString()).append("\n    allUsersData\n  ]\n});\n\n\nallUsersChart.setTitle({\n  text: '<span class=\"chart_title\">Active Users along the Simulation</span>',\n  useHTML: true\n});\n\nallUsersData.yAxis = 1;\n").toString();
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <a name=\"active_users\"></a>\n              <div id=\"container_active_users\" class=\"geant\"></div>\n            </div>\n";
    }

    public ActiveUsersTemplate(long runStart, Seq<NumberPerSecondSeries> series) {
        this.runStart = runStart;
        this.series = series;
    }
}

