/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.series.StackedColumnSeries;
import io.gatling.charts.highcharts.template.Template;
import java.util.Locale;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q3Q\u0001E\t\u0003'mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t_\u0001\u0011\t\u0011)A\u0005E!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00032\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001dy\u0004A1A\u0005\n\u0001Ca\u0001\u0013\u0001!\u0002\u0013\t\u0005bB%\u0001\u0005\u0004%I\u0001\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011B!\t\u000f-\u0003!\u0019!C\u0005\u0001\"1A\n\u0001Q\u0001\n\u0005Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004Y\u0001\u0001\u0006Ia\u0014\u0005\u00063\u0002!\tE\u0017\u0005\u00067\u0002!\tE\u0017\u0002\u0015\t&\u001cHO]5ckRLwN\u001c+f[Bd\u0017\r^3\u000b\u0005I\u0019\u0012\u0001\u0003;f[Bd\u0017\r^3\u000b\u0005Q)\u0012A\u00035jO\"\u001c\u0007.\u0019:ug*\u0011acF\u0001\u0007G\"\f'\u000f^:\u000b\u0005aI\u0012aB4bi2Lgn\u001a\u0006\u00025\u0005\u0011\u0011n\\\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u0003EI!aH\t\u0003\u0011Q+W\u000e\u001d7bi\u0016\fQ\u0001^5uY\u0016\u001c\u0001\u0001\u0005\u0002$Y9\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0003O\u0005\na\u0001\u0010:p_Rt$\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B\u0013A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0015\u0002\u0013e\f\u00050[:OC6,\u0017!D:vG\u000e,7o]*fe&,7\u000f\u0005\u00023k5\t1G\u0003\u00025'\u000511/\u001a:jKNL!AN\u001a\u0003'M#\u0018mY6fI\u000e{G.^7o'\u0016\u0014\u0018.Z:\u0002\u001b\u0019\f\u0017\u000e\\;sKN+'/[3t\u0003\u0019a\u0014N\\5u}Q)!h\u000f\u001f>}A\u0011Q\u0004\u0001\u0005\u0006A\u0015\u0001\rA\t\u0005\u0006_\u0015\u0001\rA\t\u0005\u0006a\u0015\u0001\r!\r\u0005\u0006o\u0015\u0001\r!M\u0001\u0007UNt\u0015-\\3\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\ti3)A\u0004kg:\u000bW.\u001a\u0011\u0002\u0013\rD\u0017M\u001d;OC6,\u0017AC2iCJ$h*Y7fA\u0005Y1m\u001c8uC&tWM]%e\u00031\u0019wN\u001c;bS:,'/\u00133!\u0003)\u0019\u0017\r^3h_JLWm]\u000b\u0002\u001fB\u0019\u0001+\u0016\u0012\u000f\u0005E\u001bfBA\u0013S\u0013\u0005I\u0013B\u0001+)\u0003\u001d\u0001\u0018mY6bO\u0016L!AV,\u0003\u0011%#XM]1cY\u0016T!\u0001\u0016\u0015\u0002\u0017\r\fG/Z4pe&,7\u000fI\u0001\u0003UN,\u0012AI\u0001\u0005QRlG\u000e")
public final class DistributionTemplate
extends Template {
    private final String title;
    private final String yAxisName;
    private final StackedColumnSeries successSeries;
    private final StackedColumnSeries failureSeries;
    private final String jsName;
    private final String chartName;
    private final String containerId;
    private final Iterable<String> categories;

    private String jsName() {
        return this.jsName;
    }

    private String chartName() {
        return this.chartName;
    }

    private String containerId() {
        return this.containerId;
    }

    private Iterable<String> categories() {
        return this.categories;
    }

    @Override
    public String js() {
        return new StringBuilder(993).append("\nvar ").append(this.chartName()).append(" = new Highcharts.Chart({\n  chart: {\n    renderTo: '").append(this.containerId()).append("',\n    type: 'column',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 5,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: { text: 'A title to let highcharts reserve the place for the title set later' },\n  navigator: {\n    maskInside: false\n  },\n  xAxis: {\n    categories: ['").append(this.categories().mkString("', '")).append("'],\n    tickInterval: 20\n  },\n  yAxis: {\n    min: 0,\n    title: { text: 'Percentage of ").append(this.yAxisName).append("' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      return '<b>'+ this.x +' ms</b><br/>'+\n      this.series.name +': '+ this.y +' %<br/>'+\n      'Total: '+ this.point.stackTotal + ' %';\n    }\n  },\n  plotOptions: {\n    series: {\n      groupPadding: 0,\n      stacking: 'normal',\n\t    shadow: true\n    }\n  },\n  series: [\n  \t{").append(this.renderStackedColumnSeries(this.successSeries)).append("},\n  \t{").append(this.renderStackedColumnSeries(this.failureSeries)).append("}\n  ]\n});\n\n").append(this.chartName()).append(".setTitle({\n  text: '<span class=\"chart_title\">").append(this.title).append(" Distribution</span>',\n  useHTML: true\n});\n").toString();
    }

    @Override
    public String html() {
        return new StringBuilder(105).append("\n            <div class=\"schema geant\">\n              <div id=\"").append(this.containerId()).append("\" class=\"geant\"></div>\n            </div>\n").toString();
    }

    public DistributionTemplate(String title, String yAxisName, StackedColumnSeries successSeries, StackedColumnSeries failureSeries) {
        this.title = title;
        this.yAxisName = yAxisName;
        this.successSeries = successSeries;
        this.failureSeries = failureSeries;
        this.jsName = new StringBuilder(12).append(title.replace(" ", "").toLowerCase(Locale.ROOT)).append("Distribution").toString();
        this.chartName = new StringBuilder(5).append(this.jsName()).append("Chart").toString();
        this.containerId = new StringBuilder(9).append(this.jsName()).append("Container").toString();
        this.categories = successSeries.getXValues().nonEmpty() ? successSeries.getXValues() : failureSeries.getXValues();
    }
}

