/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Module;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResolutionParams
implements Serializable {
    private Integer maxIterations = null;
    private final HashMap<Module, String> forceVersions = new HashMap();
    private final HashMap<String, String> forcedProperties = new HashMap();
    private final HashSet<String> profiles = new HashSet();
    private final HashSet<Map.Entry<String, String>> exclusions = new HashSet();
    private boolean useSystemOsInfo = true;
    private boolean useSystemJdkVersion = true;

    private ResolutionParams() {
    }

    public boolean equals(Object object) {
        if (object instanceof ResolutionParams) {
            ResolutionParams resolutionParams = (ResolutionParams)object;
            return Objects.equals(this.maxIterations, resolutionParams.maxIterations) && this.forcedProperties.equals(resolutionParams.forcedProperties) && this.profiles.equals(resolutionParams.profiles) && this.exclusions.equals(resolutionParams.exclusions) && Objects.equals(this.useSystemOsInfo, resolutionParams.useSystemOsInfo) && Objects.equals(this.useSystemJdkVersion, resolutionParams.useSystemJdkVersion);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (17 + Objects.hashCode(this.maxIterations)) + this.forceVersions.hashCode()) + this.forcedProperties.hashCode()) + this.profiles.hashCode()) + this.exclusions.hashCode()) + Boolean.hashCode(this.useSystemOsInfo)) + Boolean.hashCode(this.useSystemJdkVersion);
    }

    public String toString() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder("ResolutionParams(");
        boolean bl2 = false;
        if (this.maxIterations != null) {
            stringBuilder.append("maxIterations=");
            stringBuilder.append(this.maxIterations.toString());
            bl2 = true;
        }
        if (!this.forceVersions.isEmpty()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            stringBuilder.append("forceVersions=[");
            bl = true;
            for (Map.Entry<Module, String> object : this.forceVersions.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object.getKey().toString());
                stringBuilder.append(":");
                stringBuilder.append(object.getValue());
            }
            stringBuilder.append("]");
        }
        if (!this.forcedProperties.isEmpty()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            stringBuilder.append("forcedProperties=[");
            bl = true;
            for (Map.Entry entry : this.forcedProperties.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append((String)entry.getValue());
            }
            stringBuilder.append("]");
        }
        if (!this.profiles.isEmpty()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            stringBuilder.append("profiles=[");
            bl = true;
            for (String string : this.profiles) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("]");
        }
        if (!this.exclusions.isEmpty()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            stringBuilder.append("exclusions=[");
            bl = true;
            for (Map.Entry entry : this.exclusions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(":");
                stringBuilder.append((String)entry.getValue());
            }
            stringBuilder.append("]");
        }
        if (bl2) {
            stringBuilder.append(", ");
        } else {
            bl2 = true;
        }
        stringBuilder.append("useSystemOsInfo=");
        stringBuilder.append(this.useSystemOsInfo);
        if (bl2) {
            stringBuilder.append(", ");
        } else {
            bl2 = true;
        }
        stringBuilder.append("useSystemJdkVersion=");
        stringBuilder.append(this.useSystemJdkVersion);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static ResolutionParams create() {
        return new ResolutionParams();
    }

    public static ResolutionParams of(ResolutionParams resolutionParams) {
        return new ResolutionParams().withMaxIterations(resolutionParams.maxIterations).withForceProperties(resolutionParams.forcedProperties).withForceVersions(resolutionParams.forceVersions).withProfiles(resolutionParams.profiles).withExclusions(resolutionParams.exclusions).withUseSystemOsInfo(resolutionParams.useSystemOsInfo).withUseSystemJdkVersion(resolutionParams.useSystemJdkVersion);
    }

    public ResolutionParams withMaxIterations(Integer n) {
        this.maxIterations = n;
        return this;
    }

    public ResolutionParams forceProperty(String string, String string2) {
        this.forcedProperties.put(string, string2);
        return this;
    }

    public ResolutionParams forceProperties(Map<String, String> map) {
        this.forcedProperties.putAll(map);
        return this;
    }

    public ResolutionParams withForceProperties(Map<String, String> map) {
        this.forcedProperties.clear();
        this.forcedProperties.putAll(map);
        return this;
    }

    public ResolutionParams forceVersion(Module module, String string) {
        this.forceVersions.put(module, string);
        return this;
    }

    public ResolutionParams forceVersions(Map<Module, String> map) {
        this.forceVersions.putAll(map);
        return this;
    }

    public ResolutionParams withForceVersions(Map<Module, String> map) {
        this.forceVersions.clear();
        this.forceVersions.putAll(map);
        return this;
    }

    public ResolutionParams addProfile(String string) {
        this.profiles.add(string);
        return this;
    }

    public ResolutionParams removeProfile(String string) {
        this.profiles.remove(string);
        return this;
    }

    public ResolutionParams withProfiles(Set<String> set) {
        this.profiles.clear();
        this.profiles.addAll(set);
        return this;
    }

    public ResolutionParams addExclusion(String string, String string2) {
        this.exclusions.add(new AbstractMap.SimpleEntry<String, String>(string, string2));
        return this;
    }

    public ResolutionParams removeExclusion(String string, String string2) {
        this.exclusions.remove(new AbstractMap.SimpleEntry<String, String>(string, string2));
        return this;
    }

    public ResolutionParams withExclusions(Set<Map.Entry<String, String>> set) {
        this.exclusions.clear();
        this.exclusions.addAll(set);
        return this;
    }

    public ResolutionParams withUseSystemOsInfo(boolean bl) {
        this.useSystemOsInfo = bl;
        return this;
    }

    public ResolutionParams withUseSystemJdkVersion(boolean bl) {
        this.useSystemJdkVersion = bl;
        return this;
    }

    public Integer getMaxIterations() {
        return this.maxIterations;
    }

    public Map<String, String> getForcedProperties() {
        return Collections.unmodifiableMap(this.forcedProperties);
    }

    public Map<Module, String> getForceVersions() {
        return Collections.unmodifiableMap(this.forceVersions);
    }

    public Set<String> getProfiles() {
        return Collections.unmodifiableSet(this.profiles);
    }

    public Set<Map.Entry<String, String>> getExclusions() {
        return Collections.unmodifiableSet(this.exclusions);
    }

    public boolean getUseSystemOsInfo() {
        return this.useSystemOsInfo;
    }

    public boolean getUseSystemJdkVersion() {
        return this.useSystemJdkVersion;
    }
}

