/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.terminal;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Attributes {
    final EnumSet<InputFlag> iflag = EnumSet.noneOf(InputFlag.class);
    final EnumSet<OutputFlag> oflag = EnumSet.noneOf(OutputFlag.class);
    final EnumSet<ControlFlag> cflag = EnumSet.noneOf(ControlFlag.class);
    final EnumSet<LocalFlag> lflag = EnumSet.noneOf(LocalFlag.class);
    final EnumMap<ControlChar, Integer> cchars = new EnumMap(ControlChar.class);

    public Attributes() {
    }

    public Attributes(Attributes attr) {
        this.copy(attr);
    }

    public EnumSet<InputFlag> getInputFlags() {
        return this.iflag;
    }

    public void setInputFlags(EnumSet<InputFlag> flags) {
        this.iflag.clear();
        this.iflag.addAll(flags);
    }

    public boolean getInputFlag(InputFlag flag) {
        return this.iflag.contains((Object)flag);
    }

    public void setInputFlag(InputFlag flag, boolean value) {
        if (value) {
            this.iflag.add(flag);
        } else {
            this.iflag.remove((Object)flag);
        }
    }

    public EnumSet<OutputFlag> getOutputFlags() {
        return this.oflag;
    }

    public void setOutputFlags(EnumSet<OutputFlag> flags) {
        this.oflag.clear();
        this.oflag.addAll(flags);
    }

    public boolean getOutputFlag(OutputFlag flag) {
        return this.oflag.contains((Object)flag);
    }

    public void setOutputFlag(OutputFlag flag, boolean value) {
        if (value) {
            this.oflag.add(flag);
        } else {
            this.oflag.remove((Object)flag);
        }
    }

    public EnumSet<ControlFlag> getControlFlags() {
        return this.cflag;
    }

    public void setControlFlags(EnumSet<ControlFlag> flags) {
        this.cflag.clear();
        this.cflag.addAll(flags);
    }

    public boolean getControlFlag(ControlFlag flag) {
        return this.cflag.contains((Object)flag);
    }

    public void setControlFlag(ControlFlag flag, boolean value) {
        if (value) {
            this.cflag.add(flag);
        } else {
            this.cflag.remove((Object)flag);
        }
    }

    public EnumSet<LocalFlag> getLocalFlags() {
        return this.lflag;
    }

    public void setLocalFlags(EnumSet<LocalFlag> flags) {
        this.lflag.clear();
        this.lflag.addAll(flags);
    }

    public boolean getLocalFlag(LocalFlag flag) {
        return this.lflag.contains((Object)flag);
    }

    public void setLocalFlag(LocalFlag flag, boolean value) {
        if (value) {
            this.lflag.add(flag);
        } else {
            this.lflag.remove((Object)flag);
        }
    }

    public EnumMap<ControlChar, Integer> getControlChars() {
        return this.cchars;
    }

    public void setControlChars(EnumMap<ControlChar, Integer> chars) {
        this.cchars.clear();
        this.cchars.putAll(chars);
    }

    public int getControlChar(ControlChar c) {
        Integer v = this.cchars.get((Object)c);
        return v != null ? v : -1;
    }

    public void setControlChar(ControlChar c, int value) {
        this.cchars.put(c, value);
    }

    public void copy(Attributes attributes) {
        this.setControlFlags(attributes.getControlFlags());
        this.setInputFlags(attributes.getInputFlags());
        this.setLocalFlags(attributes.getLocalFlags());
        this.setOutputFlags(attributes.getOutputFlags());
        this.setControlChars(attributes.getControlChars());
    }

    public String toString() {
        return "Attributes[lflags: " + this.append(this.lflag) + ", iflags: " + this.append(this.iflag) + ", oflags: " + this.append(this.oflag) + ", cflags: " + this.append(this.cflag) + ", cchars: " + this.append(EnumSet.allOf(ControlChar.class), this::display) + "]";
    }

    private String display(ControlChar c) {
        int ch = this.getControlChar(c);
        String value = c == ControlChar.VMIN || c == ControlChar.VTIME ? Integer.toString(ch) : (ch < 0 ? "<undef>" : (ch < 32 ? "^" + (char)(ch + 65 - 1) : (ch == 127 ? "^?" : (ch >= 128 ? String.format("\\u%04x", ch) : String.valueOf((char)ch)))));
        return c.name().toLowerCase().substring(1) + "=" + value;
    }

    private <T extends Enum<T>> String append(EnumSet<T> set) {
        return this.append(set, e -> e.name().toLowerCase());
    }

    private <T extends Enum<T>> String append(EnumSet<T> set, Function<T, String> toString) {
        return set.stream().map(toString).collect(Collectors.joining(" "));
    }

    public static final class LocalFlag
    extends Enum<LocalFlag> {
        public static final /* enum */ LocalFlag ECHOKE = new LocalFlag();
        public static final /* enum */ LocalFlag ECHOE = new LocalFlag();
        public static final /* enum */ LocalFlag ECHOK = new LocalFlag();
        public static final /* enum */ LocalFlag ECHO = new LocalFlag();
        public static final /* enum */ LocalFlag ECHONL = new LocalFlag();
        public static final /* enum */ LocalFlag ECHOPRT = new LocalFlag();
        public static final /* enum */ LocalFlag ECHOCTL = new LocalFlag();
        public static final /* enum */ LocalFlag ISIG = new LocalFlag();
        public static final /* enum */ LocalFlag ICANON = new LocalFlag();
        public static final /* enum */ LocalFlag ALTWERASE = new LocalFlag();
        public static final /* enum */ LocalFlag IEXTEN = new LocalFlag();
        public static final /* enum */ LocalFlag EXTPROC = new LocalFlag();
        public static final /* enum */ LocalFlag TOSTOP = new LocalFlag();
        public static final /* enum */ LocalFlag FLUSHO = new LocalFlag();
        public static final /* enum */ LocalFlag NOKERNINFO = new LocalFlag();
        public static final /* enum */ LocalFlag PENDIN = new LocalFlag();
        public static final /* enum */ LocalFlag NOFLSH = new LocalFlag();
        private static final /* synthetic */ LocalFlag[] $VALUES;

        public static LocalFlag[] values() {
            return (LocalFlag[])$VALUES.clone();
        }

        static {
            $VALUES = new LocalFlag[]{ECHOKE, ECHOE, ECHOK, ECHO, ECHONL, ECHOPRT, ECHOCTL, ISIG, ICANON, ALTWERASE, IEXTEN, EXTPROC, TOSTOP, FLUSHO, NOKERNINFO, PENDIN, NOFLSH};
        }
    }

    public static final class ControlFlag
    extends Enum<ControlFlag> {
        public static final /* enum */ ControlFlag CIGNORE = new ControlFlag();
        public static final /* enum */ ControlFlag CS5 = new ControlFlag();
        public static final /* enum */ ControlFlag CS6 = new ControlFlag();
        public static final /* enum */ ControlFlag CS7 = new ControlFlag();
        public static final /* enum */ ControlFlag CS8 = new ControlFlag();
        public static final /* enum */ ControlFlag CSTOPB = new ControlFlag();
        public static final /* enum */ ControlFlag CREAD = new ControlFlag();
        public static final /* enum */ ControlFlag PARENB = new ControlFlag();
        public static final /* enum */ ControlFlag PARODD = new ControlFlag();
        public static final /* enum */ ControlFlag HUPCL = new ControlFlag();
        public static final /* enum */ ControlFlag CLOCAL = new ControlFlag();
        public static final /* enum */ ControlFlag CCTS_OFLOW = new ControlFlag();
        public static final /* enum */ ControlFlag CRTS_IFLOW = new ControlFlag();
        public static final /* enum */ ControlFlag CDTR_IFLOW = new ControlFlag();
        public static final /* enum */ ControlFlag CDSR_OFLOW = new ControlFlag();
        public static final /* enum */ ControlFlag CCAR_OFLOW = new ControlFlag();
        private static final /* synthetic */ ControlFlag[] $VALUES;

        public static ControlFlag[] values() {
            return (ControlFlag[])$VALUES.clone();
        }

        static {
            $VALUES = new ControlFlag[]{CIGNORE, CS5, CS6, CS7, CS8, CSTOPB, CREAD, PARENB, PARODD, HUPCL, CLOCAL, CCTS_OFLOW, CRTS_IFLOW, CDTR_IFLOW, CDSR_OFLOW, CCAR_OFLOW};
        }
    }

    public static final class OutputFlag
    extends Enum<OutputFlag> {
        public static final /* enum */ OutputFlag OPOST = new OutputFlag();
        public static final /* enum */ OutputFlag ONLCR = new OutputFlag();
        public static final /* enum */ OutputFlag OXTABS = new OutputFlag();
        public static final /* enum */ OutputFlag ONOEOT = new OutputFlag();
        public static final /* enum */ OutputFlag OCRNL = new OutputFlag();
        public static final /* enum */ OutputFlag ONOCR = new OutputFlag();
        public static final /* enum */ OutputFlag ONLRET = new OutputFlag();
        public static final /* enum */ OutputFlag OFILL = new OutputFlag();
        public static final /* enum */ OutputFlag NLDLY = new OutputFlag();
        public static final /* enum */ OutputFlag TABDLY = new OutputFlag();
        public static final /* enum */ OutputFlag CRDLY = new OutputFlag();
        public static final /* enum */ OutputFlag FFDLY = new OutputFlag();
        public static final /* enum */ OutputFlag BSDLY = new OutputFlag();
        public static final /* enum */ OutputFlag VTDLY = new OutputFlag();
        public static final /* enum */ OutputFlag OFDEL = new OutputFlag();
        private static final /* synthetic */ OutputFlag[] $VALUES;

        public static OutputFlag[] values() {
            return (OutputFlag[])$VALUES.clone();
        }

        static {
            $VALUES = new OutputFlag[]{OPOST, ONLCR, OXTABS, ONOEOT, OCRNL, ONOCR, ONLRET, OFILL, NLDLY, TABDLY, CRDLY, FFDLY, BSDLY, VTDLY, OFDEL};
        }
    }

    public static final class InputFlag
    extends Enum<InputFlag> {
        public static final /* enum */ InputFlag IGNBRK = new InputFlag();
        public static final /* enum */ InputFlag BRKINT = new InputFlag();
        public static final /* enum */ InputFlag IGNPAR = new InputFlag();
        public static final /* enum */ InputFlag PARMRK = new InputFlag();
        public static final /* enum */ InputFlag INPCK = new InputFlag();
        public static final /* enum */ InputFlag ISTRIP = new InputFlag();
        public static final /* enum */ InputFlag INLCR = new InputFlag();
        public static final /* enum */ InputFlag IGNCR = new InputFlag();
        public static final /* enum */ InputFlag ICRNL = new InputFlag();
        public static final /* enum */ InputFlag IXON = new InputFlag();
        public static final /* enum */ InputFlag IXOFF = new InputFlag();
        public static final /* enum */ InputFlag IXANY = new InputFlag();
        public static final /* enum */ InputFlag IMAXBEL = new InputFlag();
        public static final /* enum */ InputFlag IUTF8 = new InputFlag();
        private static final /* synthetic */ InputFlag[] $VALUES;

        public static InputFlag[] values() {
            return (InputFlag[])$VALUES.clone();
        }

        static {
            $VALUES = new InputFlag[]{IGNBRK, BRKINT, IGNPAR, PARMRK, INPCK, ISTRIP, INLCR, IGNCR, ICRNL, IXON, IXOFF, IXANY, IMAXBEL, IUTF8};
        }
    }

    public static final class ControlChar
    extends Enum<ControlChar> {
        public static final /* enum */ ControlChar VEOF = new ControlChar();
        public static final /* enum */ ControlChar VEOL = new ControlChar();
        public static final /* enum */ ControlChar VEOL2 = new ControlChar();
        public static final /* enum */ ControlChar VERASE = new ControlChar();
        public static final /* enum */ ControlChar VWERASE = new ControlChar();
        public static final /* enum */ ControlChar VKILL = new ControlChar();
        public static final /* enum */ ControlChar VREPRINT = new ControlChar();
        public static final /* enum */ ControlChar VINTR = new ControlChar();
        public static final /* enum */ ControlChar VQUIT = new ControlChar();
        public static final /* enum */ ControlChar VSUSP = new ControlChar();
        public static final /* enum */ ControlChar VDSUSP = new ControlChar();
        public static final /* enum */ ControlChar VSTART = new ControlChar();
        public static final /* enum */ ControlChar VSTOP = new ControlChar();
        public static final /* enum */ ControlChar VLNEXT = new ControlChar();
        public static final /* enum */ ControlChar VDISCARD = new ControlChar();
        public static final /* enum */ ControlChar VMIN = new ControlChar();
        public static final /* enum */ ControlChar VTIME = new ControlChar();
        public static final /* enum */ ControlChar VSTATUS = new ControlChar();
        private static final /* synthetic */ ControlChar[] $VALUES;

        public static ControlChar[] values() {
            return (ControlChar[])$VALUES.clone();
        }

        static {
            $VALUES = new ControlChar[]{VEOF, VEOL, VEOL2, VERASE, VWERASE, VKILL, VREPRINT, VINTR, VQUIT, VSUSP, VDSUSP, VSTART, VSTOP, VLNEXT, VDISCARD, VMIN, VTIME, VSTATUS};
        }
    }
}

