/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.impl;

import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.Attributes;
import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.MouseEvent;
import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.Terminal;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.Curses;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.InfoCmp;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.Log;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.Status;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractTerminal
implements Terminal {
    protected final String name;
    protected final String type;
    protected final Charset encoding;
    protected final Map<Terminal.Signal, Terminal.SignalHandler> handlers = new HashMap<Terminal.Signal, Terminal.SignalHandler>();
    protected final Set<InfoCmp.Capability> bools = new HashSet<InfoCmp.Capability>();
    protected final Map<InfoCmp.Capability, Integer> ints = new HashMap<InfoCmp.Capability, Integer>();
    protected final Map<InfoCmp.Capability, String> strings = new HashMap<InfoCmp.Capability, String>();
    protected Status status;
    private MouseEvent lastMouseEvent = new MouseEvent(MouseEvent.Type.Moved, MouseEvent.Button.NoButton, EnumSet.noneOf(MouseEvent.Modifier.class), 0, 0);

    public AbstractTerminal(String name, String type, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        this.name = name;
        this.type = type;
        this.encoding = encoding != null ? encoding : Charset.defaultCharset();
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
    }

    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        Terminal.SignalHandler handler = this.handlers.get((Object)signal);
        if (handler != Terminal.SignalHandler.SIG_DFL && handler != Terminal.SignalHandler.SIG_IGN) {
            handler.handle(signal);
        }
        if (this.status != null && signal == Terminal.Signal.WINCH) {
            this.status.resize();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.status != null) {
            this.status.update(null);
            this.flush();
        }
    }

    protected void echoSignal(Terminal.Signal signal) {
        int vcc;
        Attributes.ControlChar cc = null;
        switch (signal) {
            case INT: {
                cc = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                cc = Attributes.ControlChar.VQUIT;
                break;
            }
            case TSTP: {
                cc = Attributes.ControlChar.VSUSP;
            }
        }
        if (cc != null && (vcc = this.getAttributes().getControlChar(cc)) > 0 && vcc < 32) {
            this.writer().write(new char[]{'^', (char)(vcc + 64)}, 0, 2);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Charset encoding() {
        return this.encoding;
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    public boolean puts(InfoCmp.Capability capability, Object ... params) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        Curses.tputs(this.writer(), str, params);
        return true;
    }

    @Override
    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(InfoCmp.Capability capability) {
        return this.strings.get((Object)capability);
    }

    protected void parseInfoCmp() {
        String capabilities = null;
        if (this.type != null) {
            try {
                capabilities = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception e) {
                Log.warn("Unable to retrieve infocmp for type " + this.type, e);
            }
        }
        if (capabilities == null) {
            capabilities = InfoCmp.getLoadedInfoCmp("ansi");
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }

    public void pause() {
    }

    public void resume() {
    }
}

