/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.utils;

import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedCharSequence;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedString;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AttributedStringBuilder
extends AttributedCharSequence
implements Appendable {
    private char[] buffer;
    private int[] style;
    private int length;
    private TabStops tabs = new TabStops(0);
    private int lastLineLength = 0;
    private AttributedStyle current = AttributedStyle.DEFAULT;

    public AttributedStringBuilder() {
        this(64);
    }

    public AttributedStringBuilder(int capacity) {
        this.buffer = new char[capacity];
        this.style = new int[capacity];
        this.length = 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public AttributedStyle styleAt(int index) {
        return new AttributedStyle(this.style[index], this.style[index]);
    }

    @Override
    int styleCodeAt(int index) {
        return this.style[index];
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return 0;
    }

    @Override
    public AttributedString subSequence(int start, int end) {
        return new AttributedString(Arrays.copyOfRange(this.buffer, start, end), Arrays.copyOfRange(this.style, start, end), 0, end - start);
    }

    @Override
    public AttributedStringBuilder append(CharSequence csq) {
        return this.append(new AttributedString(csq, this.current));
    }

    @Override
    public AttributedStringBuilder append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public AttributedStringBuilder append(char c) {
        return this.append(Character.toString(c));
    }

    public AttributedStringBuilder append(CharSequence csq, AttributedStyle style) {
        return this.append(new AttributedString(csq, style));
    }

    public AttributedStringBuilder append(AttributedString str) {
        return this.append(str, 0, str.length());
    }

    public AttributedStringBuilder append(AttributedCharSequence str, int start, int end) {
        this.ensureCapacity(this.length + end - start);
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            int s = str.styleCodeAt(i) & ~this.current.getMask() | this.current.getStyle();
            if (this.tabs.defined() && c == '\t') {
                this.insertTab(new AttributedStyle(s, 0));
                continue;
            }
            this.ensureCapacity(this.length + 1);
            this.buffer[this.length] = c;
            this.style[this.length] = s;
            this.lastLineLength = c == '\n' ? 0 : ++this.lastLineLength;
            ++this.length;
        }
        return this;
    }

    protected void ensureCapacity(int nl) {
        if (nl > this.buffer.length) {
            int s;
            for (s = Math.max(this.buffer.length, 1); s <= nl; s *= 2) {
            }
            this.buffer = Arrays.copyOf(this.buffer, s);
            this.style = Arrays.copyOf(this.style, s);
        }
    }

    protected void insertTab(AttributedStyle s) {
        int nb = this.tabs.spaces(this.lastLineLength);
        this.ensureCapacity(this.length + nb);
        for (int i = 0; i < nb; ++i) {
            this.buffer[this.length] = 32;
            this.style[this.length] = s.getStyle();
            ++this.length;
        }
        this.lastLineLength += nb;
    }

    private class TabStops {
        private List<Integer> tabs = new ArrayList<Integer>();
        private int lastStop = 0;
        private int lastSize = 0;

        public TabStops(int tabs) {
            this.lastSize = tabs;
        }

        boolean defined() {
            return this.lastSize > 0;
        }

        int spaces(int lastLineLength) {
            int out = 0;
            if (lastLineLength >= this.lastStop) {
                out = this.lastSize - (lastLineLength - this.lastStop) % this.lastSize;
            } else {
                for (int s : this.tabs) {
                    if (s <= lastLineLength) continue;
                    out = s - lastLineLength;
                    break;
                }
            }
            return out;
        }
    }
}

