/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.utils;

import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingInputStream;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingInputStreamImpl;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingPumpInputStream;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class NonBlocking {
    public static NonBlockingPumpInputStream nonBlockingPumpInputStream(int size) {
        return new NonBlockingPumpInputStream(size);
    }

    public static NonBlockingInputStream nonBlocking(String name, InputStream inputStream) {
        if (inputStream instanceof NonBlockingInputStream) {
            return (NonBlockingInputStream)inputStream;
        }
        return new NonBlockingInputStreamImpl(name, inputStream);
    }

    public static NonBlockingReader nonBlocking(String name, InputStream inputStream, Charset encoding) {
        return new NonBlockingInputStreamReader(NonBlocking.nonBlocking(name, inputStream), encoding);
    }

    private static class NonBlockingInputStreamReader
    extends NonBlockingReader {
        private final NonBlockingInputStream input;
        private final CharsetDecoder decoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        public NonBlockingInputStreamReader(NonBlockingInputStream inputStream, Charset encoding) {
            this(inputStream, (encoding != null ? encoding : Charset.defaultCharset()).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        public NonBlockingInputStreamReader(NonBlockingInputStream input, CharsetDecoder decoder) {
            this.input = input;
            this.decoder = decoder;
            this.bytes = ByteBuffer.allocate(4);
            this.chars = CharBuffer.allocate(2);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        protected int read(long timeout, boolean isPeek) throws IOException {
            boolean isInfinite;
            boolean bl = isInfinite = timeout <= 0L;
            while (!this.chars.hasRemaining() && (isInfinite || timeout > 0L)) {
                int b;
                long start = 0L;
                if (!isInfinite) {
                    start = System.currentTimeMillis();
                }
                if ((b = this.input.read(timeout)) == -1) {
                    return -1;
                }
                if (b >= 0) {
                    if (!this.bytes.hasRemaining()) {
                        this.bytes.position(0);
                        this.bytes.limit(0);
                    }
                    int l = this.bytes.limit();
                    this.bytes.array()[this.bytes.arrayOffset() + l] = (byte)b;
                    this.bytes.limit(l + 1);
                    this.chars.clear();
                    this.decoder.decode(this.bytes, this.chars, false);
                    this.chars.flip();
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
            if (this.chars.hasRemaining()) {
                if (isPeek) {
                    return this.chars.get(this.chars.position());
                }
                return this.chars.get();
            }
            return -2;
        }

        @Override
        public void shutdown() {
            this.input.shutdown();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

