/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.Cache;
import coursierapi.shaded.coursier.cache.CacheChecksum$;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CachePolicy$FetchMissing$;
import coursierapi.shaded.coursier.cache.CachePolicy$ForceDownload$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnlyIfValid$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdate$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import coursierapi.shaded.coursier.cache.CachePolicy$UpdateChanging$;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.cache.FileCache$;
import coursierapi.shaded.coursier.cache.internal.FileUtil;
import coursierapi.shaded.coursier.cache.internal.FileUtil$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.EitherT;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.coursier.util.WebPage$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Predef$ArrowAssoc$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.Tuple3;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Seq$;
import coursierapi.shaded.scala.collection.immutable.Set;
import coursierapi.shaded.scala.concurrent.ExecutionContext$;
import coursierapi.shaded.scala.concurrent.ExecutionContextExecutorService;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.math.Ordering$String$;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.LazyRef;
import coursierapi.shaded.scala.runtime.ObjectRef;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class FileCache<F>
extends Cache<F>
implements Serializable,
Product {
    private Seq<DirectCredentials> allCredentials0;
    private ExecutionContextExecutorService ec;
    private final File location;
    private final Seq<CachePolicy> cachePolicies;
    private final Seq<Option<String>> checksums;
    private final Seq<Credentials> credentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int retry;
    private final int bufferSize;
    private final Sync<F> sync;
    private final Seq<Option<String>> checksums0;
    private volatile byte bitmap$0;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public File location() {
        return this.location;
    }

    public Seq<CachePolicy> cachePolicies() {
        return this.cachePolicies;
    }

    public Seq<Option<String>> checksums() {
        return this.checksums;
    }

    public Seq<Credentials> credentials() {
        return this.credentials;
    }

    public CacheLogger logger() {
        return this.logger;
    }

    public ExecutorService pool() {
        return this.pool;
    }

    public Option<Duration> ttl() {
        return this.ttl;
    }

    public boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public int sslRetry() {
        return this.sslRetry;
    }

    public Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public int retry() {
        return this.retry;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Seq<DirectCredentials> allCredentials0$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allCredentials0 = (Seq)this.credentials().flatMap((Function1<Credentials, Seq> & Serializable)x$1 -> x$1.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allCredentials0;
    }

    private Seq<DirectCredentials> allCredentials0() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.allCredentials0$lzycompute() : this.allCredentials0;
    }

    public F allCredentials() {
        return this.S().delay((Function0<Seq> & Serializable)() -> this.allCredentials0());
    }

    public FileCache<F> noCredentials() {
        return this.withCredentials(Nil$.MODULE$);
    }

    public File localFile(String url, Option<String> user) {
        return FileCache$.MODULE$.localFile0(url, this.location(), user, this.localArtifactsShouldBeCached());
    }

    public Some<CacheLogger> loggerOpt() {
        return new Some<CacheLogger>(this.logger());
    }

    private F download(Artifact artifact, Set<String> checksums, CachePolicy cachePolicy) {
        CachePolicy cachePolicy2;
        LazyRef referenceFileOpt$lzy = new LazyRef();
        boolean cacheErrors = artifact.changing() && artifact.extra().contains("cache-errors");
        CachePolicy cachePolicy3 = cachePolicy;
        if (CachePolicy$UpdateChanging$.MODULE$.equals(cachePolicy3) && !artifact.changing()) {
            cachePolicy2 = CachePolicy$FetchMissing$.MODULE$;
        } else {
            boolean bl = CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy3) ? true : CachePolicy$LocalOnlyIfValid$.MODULE$.equals(cachePolicy3);
            cachePolicy2 = bl && !artifact.changing() ? CachePolicy$LocalOnly$.MODULE$ : cachePolicy3;
        }
        CachePolicy$FetchMissing$ cachePolicy0 = cachePolicy2;
        Object mainTask = this.res$1(artifact.url(), true, artifact, cachePolicy0, cacheErrors, referenceFileOpt$lzy);
        return (F)this.S().bind(mainTask, arg_0 -> FileCache.$anonfun$download$70(this, checksums, artifact, cachePolicy0, cacheErrors, referenceFileOpt$lzy, arg_0));
    }

    public EitherT<F, ArtifactError, BoxedUnit> validateChecksum(Artifact artifact, String sumType) {
        File localFile0 = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$24 -> x$24.user()));
        Seq headerSumFile = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{FileCache$.MODULE$.auxiliaryFile(localFile0, sumType)}));
        Option downloadedSumFile = artifact.checksumUrls().get(sumType).map((Function1<String, File> & Serializable)sumUrl -> this.localFile((String)sumUrl, artifact.authentication().map((Function1<Authentication, String> & Serializable)x$25 -> x$25.user())));
        return new EitherT(this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            Left left;
            Option option = ((IterableOnceOps)headerSumFile.$plus$plus(Option$.MODULE$.option2Iterable(downloadedSumFile).toSeq())).find((Function1<File, Object> & Serializable)x$26 -> BoxesRunTime.boxToBoolean(x$26.exists()));
            if (option instanceof Some) {
                Either either;
                Some some = (Some)option;
                File sumFile = (File)some.value();
                Option<BigInteger> sumOpt = CacheChecksum$.MODULE$.parseRawChecksum(Files.readAllBytes(sumFile.toPath()));
                Option<BigInteger> option2 = sumOpt;
                if (None$.MODULE$.equals(option2)) {
                    either = package$.MODULE$.Left().apply(new ArtifactError.ChecksumFormatError(sumType, sumFile.getPath()));
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    BigInteger sum = (BigInteger)some2.value();
                    MessageDigest md = MessageDigest.getInstance(sumType);
                    try (FileInputStream is = null;){
                        is = new FileInputStream(localFile0);
                        FileUtil$.MODULE$.withContent(is, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
                    }
                    byte[] digest = md.digest();
                    BigInteger calculatedSum = new BigInteger(1, digest);
                    either = BoxesRunTime.equalsNumNum(sum, calculatedSum) ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(new ArtifactError.WrongChecksum(sumType, calculatedSum.toString(16), sum.toString(16), localFile0.getPath(), sumFile.getPath()));
                } else {
                    throw new MatchError(option2);
                }
                left = either;
            } else if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply(new ArtifactError.ChecksumNotFound(sumType, localFile0.getPath()));
            } else {
                throw new MatchError(option);
            }
            return left;
        }));
    }

    private Seq<Option<String>> checksums0() {
        return this.checksums0;
    }

    private EitherT<F, ArtifactError, File> filePerPolicy(Artifact artifact, CachePolicy policy, int retry) {
        F artifact0 = this.S().map(this.allCredentials(), (Function1<Seq, Artifact> & Serializable)allCredentials -> {
            Artifact artifact;
            if (artifact.authentication().isEmpty()) {
                Option<Authentication> authOpt = allCredentials.find((Function1<DirectCredentials, Object> & Serializable)x$27 -> BoxesRunTime.boxToBoolean(x$27.autoMatches(artifact.url(), None$.MODULE$))).map((Function1<DirectCredentials, Authentication> & Serializable)x$28 -> x$28.authentication());
                artifact = artifact.withAuthentication(authOpt);
            } else {
                artifact = artifact;
            }
            return artifact;
        });
        return new EitherT(this.S().map(artifact0, (Function1<Artifact, Right> & Serializable)x$29 -> package$.MODULE$.Right().apply(x$29))).flatMap((Function1<Artifact, EitherT> & Serializable)a -> this.filePerPolicy0((Artifact)a, policy, retry), this.sync());
    }

    private EitherT<F, ArtifactError, File> filePerPolicy0(Artifact artifact, CachePolicy policy, int retry) {
        return new EitherT(this.S().map(this.download(artifact, ((IterableOnceOps)this.checksums0().collect(new Serializable(null){

            public final <A1 extends Option<String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    String c = (String)some.value();
                    object = c;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Option<String> x1) {
                Option<String> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        })).toSet(), policy), (Function1<Seq, Either> & Serializable)results -> {
            Either res;
            Tuple2 tuple2;
            Option<Option<String>> checksum;
            Seq checksumResults;
            block3: {
                Tuple2 tuple22;
                block2: {
                    Map resultsMap = ((IterableOnceOps)results.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                        Either b;
                        Tuple2 tuple2;
                        block3: {
                            Tuple2 tuple22;
                            block2: {
                                tuple22 = x0$1;
                                if (tuple22 == null) break block2;
                                tuple2 = (Tuple2)tuple22._1();
                                b = (Either)tuple22._2();
                                if (tuple2 != null) break block3;
                            }
                            throw new MatchError(tuple22);
                        }
                        String u = (String)tuple2._2();
                        Tuple2<String, Either> tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(u), b);
                        return tuple23;
                    })).toMap($less$colon$less$.MODULE$.refl());
                    checksumResults = (Seq)this.checksums0().map((Function1<Option, Option> & Serializable)x0$2 -> {
                        Option option;
                        Option option2 = x0$2;
                        if (None$.MODULE$.equals(option2)) {
                            option = None$.MODULE$;
                        } else if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            String c = (String)some.value();
                            String url = (String)artifact.checksumUrls().getOrElse(c, (Function0<String> & Serializable)() -> new StringBuilder(1).append(artifact.url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(c.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$30 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy0$6(BoxesRunTime.unboxToChar(x$30))))).toString());
                            option = new Some(new Tuple3(c, url, resultsMap.get(url)));
                        } else {
                            throw new MatchError(option2);
                        }
                        return option;
                    });
                    checksum = checksumResults.collectFirst(new Serializable(null){

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Some some;
                            Tuple3 tuple3;
                            void var3_7;
                            A1 A1 = x2;
                            if (None$.MODULE$.equals(A1)) {
                                None$ none$ = None$.MODULE$;
                                return var3_7;
                            }
                            if (A1 instanceof Some && (tuple3 = (Tuple3)(some = (Some)A1).value()) != null) {
                                Some some2;
                                Either either;
                                String c = (String)tuple3._1();
                                Option option = (Option)tuple3._3();
                                if (option instanceof Some && (either = (Either)(some2 = (Some)option).value()) instanceof Right) {
                                    Right right = (Right)either;
                                    BoxedUnit boxedUnit = (BoxedUnit)right.value();
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    BoxedUnit boxedUnit3 = boxedUnit;
                                    if (!(boxedUnit2 != null ? !((Object)boxedUnit2).equals(boxedUnit3) : boxedUnit3 != null)) {
                                        Some<String> some3 = new Some<String>(c);
                                        return var3_7;
                                    }
                                }
                            }
                            B1 B1 = function1.apply(x2);
                            return var3_7;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>> x2) {
                            Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>> option = x2;
                            if (None$.MODULE$.equals(option)) {
                                return true;
                            }
                            if (!(option instanceof Some)) return false;
                            Some some = (Some)option;
                            Tuple3 tuple3 = (Tuple3)some.value();
                            if (tuple3 == null) return false;
                            Option option2 = (Option)tuple3._3();
                            if (!(option2 instanceof Some)) return false;
                            Some some2 = (Some)option2;
                            Either either = (Either)some2.value();
                            if (!(either instanceof Right)) return false;
                            Right right = (Right)either;
                            BoxedUnit boxedUnit = (BoxedUnit)right.value();
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            BoxedUnit boxedUnit3 = boxedUnit;
                            if (boxedUnit2 != null) {
                                if (!((Object)boxedUnit2).equals(boxedUnit3)) return false;
                                return true;
                            }
                            if (boxedUnit3 == null) return true;
                            return false;
                        }
                    });
                    tuple22 = (Tuple2)results.head();
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    res = (Either)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple22);
            }
            File f = (File)tuple2._1();
            Tuple2<File, Either> tuple23 = new Tuple2<File, Either>(f, res);
            Tuple2<File, Either> tuple24 = tuple23;
            File f2 = tuple24._1();
            Either res2 = tuple24._2();
            return res2.flatMap((Function1<BoxedUnit, Either> & Serializable)x$32 -> {
                Either either;
                Option option = checksum;
                if (None$.MODULE$.equals(option)) {
                    either = package$.MODULE$.Left().apply(new ArtifactError.ChecksumErrors(FileCache.checksumErrors$1(checksumResults)));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Option c = (Option)some.value();
                    either = package$.MODULE$.Right().apply(new Tuple2<File, Option>(f2, c));
                } else {
                    throw new MatchError(option);
                }
                return either;
            });
        })).flatMap((Function1<Tuple2, EitherT> & Serializable)x0$3 -> {
            void var3_8;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                File f = (File)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    EitherT eitherT = new EitherT(this.S().point(package$.MODULE$.Right().apply(f)));
                    return var3_8;
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            File f = (File)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) throw new MatchError(tuple2);
            Some some = (Some)option;
            String c = (String)some.value();
            EitherT eitherT = this.validateChecksum(artifact, c).map((Function1<BoxedUnit, File> & Serializable)x$33 -> f, this.sync());
            return var3_8;
        }, this.sync()).leftFlatMap((Function1<ArtifactError, EitherT> & Serializable)x0$4 -> {
            EitherT eitherT;
            ArtifactError artifactError = x0$4;
            if (artifactError instanceof ArtifactError.WrongChecksum) {
                ArtifactError.WrongChecksum wrongChecksum = (ArtifactError.WrongChecksum)artifactError;
                File badFile = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$34 -> x$34.user()));
                File badChecksumFile = new File(wrongChecksum.sumFile());
                String location0 = new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.location().getCanonicalPath()), "/")).append("/").toString();
                boolean foundBadFileInCache = badFile.getCanonicalPath().startsWith(location0) && badChecksumFile.getCanonicalPath().startsWith(location0);
                eitherT = retry <= 0 || !foundBadFileInCache ? new EitherT(this.S().point(package$.MODULE$.Left().apply(wrongChecksum))) : new EitherT(this.S().schedule(this.pool(), (Function0<Right> & Serializable)() -> {
                    Predef$.MODULE$.assert(foundBadFileInCache);
                    badFile.delete();
                    badChecksumFile.delete();
                    FileCache$.MODULE$.coursier$cache$FileCache$$clearAuxiliaryFiles(badFile);
                    this.logger().removedCorruptFile(artifact.url(), new Some<String>(wrongChecksum.describe()));
                    return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
                })).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$35 -> this.filePerPolicy0(artifact, policy, retry - 1), this.sync());
            } else {
                eitherT = new EitherT(this.S().point(package$.MODULE$.Left().apply(artifactError)));
            }
            return eitherT;
        }, this.sync());
    }

    @Override
    public EitherT<F, ArtifactError, File> file(Artifact artifact) {
        return this.file(artifact, this.retry());
    }

    public EitherT<F, ArtifactError, File> file(Artifact artifact, int retry) {
        return ((IterableOnceOps)((IterableOps)this.cachePolicies().tail()).map((Function1<CachePolicy, EitherT> & Serializable)x$36 -> this.filePerPolicy(artifact, (CachePolicy)x$36, retry))).foldLeft(this.filePerPolicy(artifact, (CachePolicy)this.cachePolicies().head(), retry), (Function2<EitherT, EitherT, EitherT> & Serializable)(x$37, x$38) -> x$37.orElse((Function0<EitherT> & Serializable)() -> x$38, this.sync()));
    }

    private int filePerPolicy$default$3() {
        return this.retry();
    }

    private EitherT<F, String, String> fetchPerPolicy(Artifact artifact, CachePolicy policy) {
        Tuple2<Artifact, Boolean> tuple2;
        Tuple2<Artifact, Boolean> tuple22 = tuple2 = artifact.url().endsWith("/.links") ? new Tuple2<Artifact, Boolean>(artifact.withUrl(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(artifact.url()), ".links")), BoxesRunTime.boxToBoolean(true)) : new Tuple2<Artifact, Boolean>(artifact, BoxesRunTime.boxToBoolean(false));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Artifact artifact0 = (Artifact)tuple2._1();
        boolean links = tuple2._2$mcZ$sp();
        Tuple2<Artifact, Boolean> tuple23 = new Tuple2<Artifact, Boolean>(artifact0, BoxesRunTime.boxToBoolean(links));
        Tuple2<Artifact, Boolean> tuple24 = tuple23;
        Artifact artifact02 = tuple24._1();
        boolean links2 = tuple24._2$mcZ$sp();
        return this.filePerPolicy(artifact02, policy, this.filePerPolicy$default$3()).leftMap((Function1<ArtifactError, String> & Serializable)x$40 -> x$40.describe(), this.sync()).flatMap((Function1<File, EitherT> & Serializable)f -> {
            Either either;
            if (f.exists()) {
                if (f.isDirectory()) {
                    if (artifact02.url().startsWith("file:")) {
                        String string;
                        if (links2) {
                            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                                void var1_1;
                                String name = c.getName();
                                return c.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : var1_1;
                            }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)).mkString("\n");
                        } else {
                            String elements = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                                void var1_1;
                                String name = c.getName();
                                return c.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : var1_1;
                            }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)), (Function1<String, String> & Serializable)name0 -> new StringBuilder(24).append("<li><a href=\"").append((String)name0).append("\">").append((String)name0).append("</a></li>").toString(), ClassTag$.MODULE$.apply(String.class))).mkString();
                            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(249).append("<!DOCTYPE html>\n                   |<html>\n                   |<head></head>\n                   |<body>\n                   |<ul>\n                   |").append(elements).append("\n                   |</ul>\n                   |</body>\n                   |</html>\n                 ").toString()));
                        }
                        String content = string;
                        either = package$.MODULE$.Right().apply(content);
                    } else {
                        File f0 = new File((File)f, ".directory");
                        either = f0.exists() ? (f0.isDirectory() ? package$.MODULE$.Left().apply(new StringBuilder(22).append("Woops: ").append(f.getCanonicalPath()).append(" is a directory").toString()) : FileCache.read$1(f0, links2, artifact02)) : FileCache.notFound$1(f0);
                    }
                } else {
                    either = FileCache.read$1(f, links2, artifact02);
                }
            } else {
                either = FileCache.notFound$1(f);
            }
            Left res = either;
            return new EitherT(this.S().point(res));
        }, this.sync());
    }

    @Override
    public Function1<Artifact, EitherT<F, String, String>> fetch() {
        return (Function1<Artifact, EitherT> & Serializable)a -> ((IterableOnceOps)this.cachePolicies().tail()).foldLeft(this.fetchPerPolicy((Artifact)a, (CachePolicy)this.cachePolicies().head()), (Function2<EitherT, CachePolicy, EitherT> & Serializable)(x$41, x$42) -> x$41.orElse((Function0<EitherT> & Serializable)() -> this.fetchPerPolicy((Artifact)a, (CachePolicy)x$42), this.sync()));
    }

    @Override
    public Seq<Function1<Artifact, EitherT<F, String, String>>> fetchs() {
        return (Seq)this.cachePolicies().map((Function1<CachePolicy, Function1> & Serializable)p -> (Function1<Artifact, EitherT> & Serializable)a -> this.fetchPerPolicy((Artifact)a, (CachePolicy)p));
    }

    private ExecutionContextExecutorService ec$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(this.pool());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ec;
    }

    @Override
    public ExecutionContextExecutorService ec() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ec$lzycompute() : this.ec;
    }

    public FileCache<F> withLocation(File location) {
        return new FileCache<F>(location, this.cachePolicies(), this.checksums(), this.credentials(), this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.sync());
    }

    public FileCache<F> withCredentials(Seq<Credentials> credentials) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), credentials, this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.sync());
    }

    public FileCache<F> withLogger(CacheLogger logger) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), this.credentials(), logger, this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.sync());
    }

    public FileCache<F> withPool(ExecutorService pool) {
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), this.credentials(), this.logger(), pool, this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.sync());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FileCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicies()));
        b.append(", ");
        b.append(String.valueOf(this.checksums()));
        b.append(", ");
        b.append(String.valueOf(this.credentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.retry()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof FileCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!this.canEqual(obj)) return false;
        FileCache other = (FileCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Seq<CachePolicy> seq = this.cachePolicies();
        Seq<CachePolicy> seq2 = other.cachePolicies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Option<String>> seq3 = this.checksums();
        Seq<Option<String>> seq4 = other.checksums();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Credentials> seq5 = this.credentials();
        Seq<Credentials> seq6 = other.credentials();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        CacheLogger cacheLogger = this.logger();
        CacheLogger cacheLogger2 = other.logger();
        if (cacheLogger == null) {
            if (cacheLogger2 != null) {
                return false;
            }
        } else if (!cacheLogger.equals(cacheLogger2)) return false;
        ExecutorService executorService = this.pool();
        ExecutorService executorService2 = other.pool();
        if (executorService == null) {
            if (executorService2 != null) {
                return false;
            }
        } else if (!executorService.equals(executorService2)) return false;
        Option<Duration> option = this.ttl();
        Option<Duration> option2 = other.ttl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Option<Object> option3 = this.maxRedirections();
        Option<Object> option4 = other.maxRedirections();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.sslRetry() != other.sslRetry()) return false;
        Option<SSLSocketFactory> option5 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option6 = other.sslSocketFactoryOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<HostnameVerifier> option7 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option8 = other.hostnameVerifierOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (this.retry() != other.retry()) return false;
        if (this.bufferSize() != other.bufferSize()) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("FileCache");
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.cachePolicies());
        code = 37 * code + Statics.anyHash(this.checksums());
        code = 37 * code + Statics.anyHash(this.credentials());
        code = 37 * code + Statics.anyHash(this.logger());
        code = 37 * code + Statics.anyHash(this.pool());
        code = 37 * code + Statics.anyHash(this.ttl());
        code = 37 * code + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = 37 * code + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = 37 * code + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.maxRedirections());
        code = 37 * code + this.sslRetry();
        code = 37 * code + Statics.anyHash(this.sslSocketFactoryOpt());
        code = 37 * code + Statics.anyHash(this.hostnameVerifierOpt());
        code = 37 * code + this.retry();
        code = 37 * code + this.bufferSize();
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "FileCache";
    }

    @Override
    public int productArity() {
        return 17;
    }

    @Override
    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this.location();
                break;
            }
            case 1: {
                object = this.cachePolicies();
                break;
            }
            case 2: {
                object = this.checksums();
                break;
            }
            case 3: {
                object = this.credentials();
                break;
            }
            case 4: {
                object = this.logger();
                break;
            }
            case 5: {
                object = this.pool();
                break;
            }
            case 6: {
                object = this.ttl();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
                break;
            }
            case 9: {
                object = BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
                break;
            }
            case 10: {
                object = this.maxRedirections();
                break;
            }
            case 11: {
                object = BoxesRunTime.boxToInteger(this.sslRetry());
                break;
            }
            case 12: {
                object = this.sslSocketFactoryOpt();
                break;
            }
            case 13: {
                object = this.hostnameVerifierOpt();
                break;
            }
            case 14: {
                object = BoxesRunTime.boxToInteger(this.retry());
                break;
            }
            case 15: {
                object = BoxesRunTime.boxToInteger(this.bufferSize());
                break;
            }
            case 16: {
                object = this.sync();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n2)).toString());
            }
        }
        return object;
    }

    private final /* synthetic */ Option referenceFileOpt$lzycompute$1(LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        Option option;
        LazyRef lazyRef = referenceFileOpt$lzy$1;
        synchronized (lazyRef) {
            option = referenceFileOpt$lzy$1.initialized() ? (Option)referenceFileOpt$lzy$1.value() : referenceFileOpt$lzy$1.initialize(artifact$1.extra().get("metadata").map((Function1<Artifact, File> & Serializable)a -> this.localFile(a.url(), a.authentication().map((Function1<Authentication, String> & Serializable)x$2 -> x$2.user()))));
        }
        return option;
    }

    private final Option referenceFileOpt$1(LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        return referenceFileOpt$lzy$1.initialized() ? (Option)referenceFileOpt$lzy$1.value() : this.referenceFileOpt$lzycompute$1(referenceFileOpt$lzy$1, artifact$1);
    }

    private final boolean cacheErrors0$1(boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        return cacheErrors$1 || this.referenceFileOpt$1(referenceFileOpt$lzy$1, artifact$1).exists((Function1<File, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.exists()));
    }

    private final EitherT fileLastModified$1(File file) {
        return new EitherT(this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            long lastModified;
            return package$.MODULE$.Right().apply((lastModified = file.lastModified()) > 0L ? new Some<Long>(BoxesRunTime.boxToLong(lastModified)) : None$.MODULE$);
        }));
    }

    private final EitherT urlLastModified$1(String url, Option currentLastModifiedOpt, CacheLogger logger, Artifact artifact$1) {
        return new EitherT(this.S().bind(this.allCredentials(), (Function1<Seq, Object> & Serializable)allCredentials0 -> this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            Left left;
            block15: {
                URLConnection conn = null;
                try {
                    try {
                        Either either;
                        URLConnection uRLConnection = conn = CacheUrl$.MODULE$.urlConnection(url, artifact$1.authentication(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), (Seq<DirectCredentials>)allCredentials0, this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), "HEAD", this.maxRedirections());
                        if (uRLConnection instanceof HttpURLConnection) {
                            Right right;
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            logger.checkingUpdates(url, currentLastModifiedOpt);
                            boolean success = false;
                            try {
                                long remoteLastModified = httpURLConnection.getLastModified();
                                Option res = remoteLastModified > 0L ? new Some<Long>(BoxesRunTime.boxToLong(remoteLastModified)) : None$.MODULE$;
                                success = true;
                                logger.checkingUpdatesResult(url, currentLastModifiedOpt, res);
                                right = package$.MODULE$.Right().apply(res);
                            }
                            finally {
                                if (!success) {
                                    logger.checkingUpdatesResult(url, currentLastModifiedOpt, None$.MODULE$);
                                }
                            }
                            either = right;
                        } else {
                            either = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                        }
                        left = either;
                    }
                    catch (Throwable throwable) {
                        ArtifactError.DownloadError ex;
                        Option<Throwable> option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = option.get();
                            ex = new ArtifactError.DownloadError(new StringBuilder(44).append("Caught ").append(e).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$4 -> new StringBuilder(3).append(" (").append((String)x$4).append(")").toString())).append(" while getting last modified time of ").append(url).toString(), new Some<Throwable>(e));
                            if (Boolean.getBoolean("coursierapi.shaded.coursier.cache.throw-exceptions")) {
                                throw ex;
                            }
                        } else {
                            throw throwable;
                        }
                        Left left2 = package$.MODULE$.Left().apply(ex);
                        left = left2;
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        CacheUrl$.MODULE$.closeConn(conn);
                    }
                    throw throwable;
                }
                if (conn == null) break block15;
                CacheUrl$.MODULE$.closeConn(conn);
            }
            return left;
        })));
    }

    private final Object fileExists$1(File file) {
        return this.S().schedule(this.pool(), () -> file.exists());
    }

    private static final File ttlFile$1(File file) {
        return new File(file.getParent(), new StringBuilder(9).append(".").append(file.getName()).append(".checked").toString());
    }

    private final Object lastCheck$1(File file) {
        File ttlFile0 = FileCache.ttlFile$1(file);
        return this.S().schedule(this.pool(), (Function0<Option> & Serializable)() -> ttlFile0.exists() ? new Some<Long>(BoxesRunTime.boxToLong(ttlFile0.lastModified())).filter(x$5 -> x$5 > 0L) : None$.MODULE$);
    }

    private static final void doTouchCheckFile$1(File file, String url, boolean updateLinks) {
        block12: {
            Serializable serializable;
            long ts = System.currentTimeMillis();
            File f = FileCache.ttlFile$1(file);
            if (f.exists()) {
                serializable = BoxesRunTime.boxToBoolean(f.setLastModified(ts));
            } else {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
                fos.close();
                serializable = BoxedUnit.UNIT;
            }
            if (!updateLinks) break block12;
            String string = file.getName();
            String string2 = ".directory";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                boolean succeeded;
                boolean bl;
                File linkFile = FileCache$.MODULE$.auxiliaryFile(file, "links");
                try {
                    String content = WebPage$.MODULE$.listElements(url, new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8)).mkString("\n");
                    try (FileOutputStream fos = null;){
                        fos = new FileOutputStream(linkFile);
                        fos.write(content.getBytes(StandardCharsets.UTF_8));
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    boolean bl2 = false;
                    bl = succeeded = bl2;
                }
                if (!succeeded) {
                    Files.deleteIfExists(linkFile.toPath());
                }
            }
        }
    }

    private final EitherT checkErrFile$1(File errFile0$1, String url$2, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        return new EitherT(this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            Either either;
            if (this.referenceFileOpt$1(referenceFileOpt$lzy$1, artifact$1).exists((Function1<File, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.exists())) && errFile0$1.exists()) {
                either = package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$2, new Some<Object>(BoxesRunTime.boxToBoolean(true))));
            } else if (cacheErrors$1 && errFile0$1.exists()) {
                long ts = errFile0$1.lastModified();
                long now = System.currentTimeMillis();
                either = ts > 0L && now < ts + BoxesRunTime.unboxToLong(this.ttl().fold(() -> 0L, (Function1<Duration, Object> & Serializable)x$7 -> BoxesRunTime.boxToLong(x$7.toMillis()))) ? package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$2, ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2())) : package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            } else {
                either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            }
            return either;
        }));
    }

    private final Object checkNeeded$1(File file$3) {
        return this.ttl().fold((Function0<Object> & Serializable)() -> this.S().point(BoxesRunTime.boxToBoolean(true)), (Function1<Duration, Object> & Serializable)ttl -> ttl.isFinite() ? this.S().bind(this.lastCheck$1(file$3), (Function1<Option, Object> & Serializable)x0$1 -> {
            Object f;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                f = this.S().point(BoxesRunTime.boxToBoolean(true));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long ts = BoxesRunTime.unboxToLong(some.value());
                f = this.S().map(this.S().schedule(this.pool(), () -> System.currentTimeMillis()), x$8 -> x$8 > ts + ttl.toMillis());
            } else {
                throw new MatchError(option);
            }
            return f;
        }) : this.S().point(BoxesRunTime.boxToBoolean(false)));
    }

    public static final /* synthetic */ boolean $anonfun$download$22(Option fileLastModOpt$1, Option urlLastModOpt) {
        Option<Object> fromDatesOpt = fileLastModOpt$1.flatMap((Function1<Object, Option> & Serializable)fileLastMod -> urlLastModOpt.map(urlLastMod -> fileLastMod < urlLastMod));
        return BoxesRunTime.unboxToBoolean(fromDatesOpt.getOrElse(() -> true));
    }

    private final EitherT check$1(File file$3, String url$2, Artifact artifact$1) {
        return this.fileLastModified$1(file$3).flatMap((Function1<Option, EitherT> & Serializable)fileLastModOpt -> this.urlLastModified$1(url$2, (Option)fileLastModOpt, this.logger(), artifact$1).map((Function1<Option, Object> & Serializable)urlLastModOpt -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$download$22(fileLastModOpt, urlLastModOpt)), this.sync()), this.sync());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$download$28(FileCache $this, boolean checkRemote$1, File file$3, String url$2, Artifact artifact$1, boolean x0$2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = x0$2;
        if (!bl3) {
            return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false)));
        }
        if (bl3) {
            bl = true;
            bl2 = bl3;
            if (!checkRemote$1) {
                return $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
            }
        }
        if (!bl) throw new MatchError(BoxesRunTime.boxToBoolean(bl3));
        if (!checkRemote$1) throw new MatchError(BoxesRunTime.boxToBoolean(bl3));
        return $this.S().bind($this.check$1(file$3, url$2, artifact$1).run(), (Function1<Either, Object> & Serializable)x0$3 -> {
            Right right;
            boolean bl;
            Either either = x0$3;
            Object f = either instanceof Right && !(bl = BoxesRunTime.unboxToBoolean((right = (Right)either).value())) ? $this.S().schedule($this.pool(), (Function0<Right> & Serializable)() -> {
                FileCache.doTouchCheckFile$1(file$3, url$2, false);
                return package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(false));
            }) : $this.S().point(either);
            return f;
        });
    }

    public static final /* synthetic */ Object $anonfun$download$27(FileCache $this, boolean checkRemote$1, File file$3, String url$2, Artifact artifact$1, boolean x0$1) {
        Object object;
        boolean bl = x0$1;
        if (!bl) {
            object = $this.S().point(package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(true)));
        } else if (bl) {
            object = $this.S().bind($this.checkNeeded$1(file$3), (Function1<Object, Object> & Serializable)x0$2 -> FileCache.$anonfun$download$28($this, checkRemote$1, file$3, url$2, artifact$1, BoxesRunTime.unboxToBoolean(x0$2)));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return object;
    }

    private final EitherT shouldDownload$1(File file, String url, boolean checkRemote, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        File errFile0 = FileCache.errFile$1(file);
        return this.checkErrFile$1(errFile0, url, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$9 -> new EitherT(this.S().bind(this.fileExists$1(file), (Function1<Object, Object> & Serializable)x0$1 -> FileCache.$anonfun$download$27(this, checkRemote, file, url, artifact$1, BoxesRunTime.unboxToBoolean(x0$1)))), this.sync());
    }

    public static final /* synthetic */ boolean $anonfun$download$43(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final Either doDownload$1(String url$3, File file$4, File tmp$1, Artifact artifact$1, Seq allCredentials0$2, boolean keepHeaderChecksums$1) {
        return FileCache$.MODULE$.coursier$cache$FileCache$$downloading(url$3, file$4, this.sslRetry(), (Function0<Either> & Serializable)() -> {
            Either either;
            block18: {
                URLConnection conn;
                block16: {
                    Some some;
                    Authentication auth;
                    long alreadyDownloaded = tmp$1.length();
                    conn = null;
                    Option<Authentication> option = artifact$1.authentication();
                    Option<Authentication> option2 = option instanceof Some && (auth = (Authentication)(some = (Some)option).value()).userOnly() ? allCredentials0$2.find((Function1<DirectCredentials, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(x$10.matches(url$3, auth.user()))).map((Function1<DirectCredentials, Authentication> & Serializable)x$11 -> x$11.authentication()).orElse((Function0<Option> & Serializable)() -> artifact$1.authentication()) : artifact$1.authentication();
                    Option<Authentication> authenticationOpt = option2;
                    try {
                        BoxedUnit boxedUnit;
                        Map map;
                        Tuple2<URLConnection, Object> tuple2 = CacheUrl$.MODULE$.urlConnectionMaybePartial(url$3, authenticationOpt, alreadyDownloaded, this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), (Seq)allCredentials0$2.filter((Function1<DirectCredentials, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.matchHost())), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), "GET", this.maxRedirections());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        URLConnection conn0 = tuple2._1();
                        boolean partialDownload = tuple2._2$mcZ$sp();
                        Tuple2<URLConnection, Boolean> tuple22 = new Tuple2<URLConnection, Boolean>(conn0, BoxesRunTime.boxToBoolean(partialDownload));
                        Tuple2<URLConnection, Boolean> tuple23 = tuple22;
                        URLConnection conn02 = tuple23._1();
                        boolean partialDownload2 = tuple23._2$mcZ$sp();
                        conn = conn02;
                        Option<Object> respCodeOpt = CacheUrl$.MODULE$.responseCode(conn);
                        if (respCodeOpt.contains(BoxesRunTime.boxToInteger(404))) {
                            either = package$.MODULE$.Left().apply(new ArtifactError.NotFound(url$3, new Some<Object>(BoxesRunTime.boxToBoolean(true))));
                            break block16;
                        }
                        if (respCodeOpt.contains(BoxesRunTime.boxToInteger(401))) {
                            either = package$.MODULE$.Left().apply(new ArtifactError.Unauthorized(url$3, CacheUrl$.MODULE$.realm(conn)));
                            break block16;
                        }
                        Option$.MODULE$.apply(BoxesRunTime.boxToLong(conn.getContentLengthLong())).withFilter(len0 -> len0 >= 0L).foreach(len0 -> {
                            long len = len0 + (partialDownload2 ? alreadyDownloaded : 0L);
                            this.logger().downloadLength(url$3, len, alreadyDownloaded, false);
                        });
                        if (keepHeaderChecksums$1) {
                            Map map2;
                            URLConnection uRLConnection = conn;
                            if (uRLConnection instanceof HttpURLConnection) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                                map2 = ((IterableOnceOps)FileCache$.MODULE$.coursier$cache$FileCache$$checksumHeader().flatMap((Function1<String, Option> & Serializable)c -> {
                                    Option option;
                                    Option<String> option2 = Option$.MODULE$.apply(httpURLConnection.getHeaderField(new StringBuilder(11).append("X-Checksum-").append((String)c).toString()));
                                    if (option2 instanceof Some) {
                                        Some some = (Some)option2;
                                        String str = (String)some.value();
                                        option = new Some<Tuple2<String, byte[]>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), str.getBytes(StandardCharsets.UTF_8)));
                                    } else if (None$.MODULE$.equals(option2)) {
                                        option = None$.MODULE$;
                                    } else {
                                        throw new MatchError(option2);
                                    }
                                    return option;
                                })).toMap($less$colon$less$.MODULE$.refl());
                            } else {
                                map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                            }
                            map = map2;
                        } else {
                            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                        }
                        Map auxiliaryData = map;
                        Option<Long> lastModifiedOpt = Option$.MODULE$.apply(BoxesRunTime.boxToLong(conn.getLastModified())).filter(x$14 -> x$14 > 0L);
                        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream(), this.bufferSize());
                             FileOutputStream out = (FileOutputStream)CacheLocks$.MODULE$.withStructureLock(this.location(), (Function0<FileOutputStream> & Serializable)() -> {
                            Files.createDirectories(tmp$1.toPath().getParent(), new FileAttribute[0]);
                            return new FileOutputStream(tmp$1, partialDownload2);
                        });){
                            FileCache$.MODULE$.coursier$cache$FileCache$$readFullyTo(in, out, this.logger(), url$3, partialDownload2 ? alreadyDownloaded : 0L, this.bufferSize());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit result = boxedUnit;
                        FileCache$.MODULE$.coursier$cache$FileCache$$clearAuxiliaryFiles(file$4);
                        auxiliaryData.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$download$43(check$ifrefutable$1))).foreach((Function1<Tuple2, Path> & Serializable)x$15 -> {
                            Tuple2 tuple2 = x$15;
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            String key = (String)tuple2._1();
                            byte[] data = (byte[])tuple2._2();
                            File dest = FileCache$.MODULE$.auxiliaryFile(file$4, key);
                            File tmpDest = CachePath.temporaryFile(dest);
                            Files.createDirectories(tmpDest.toPath().getParent(), new FileAttribute[0]);
                            Files.write(tmpDest.toPath(), data, new OpenOption[0]);
                            lastModifiedOpt.foreach(lastModified -> tmpDest.setLastModified(lastModified));
                            Files.createDirectories(dest.toPath().getParent(), new FileAttribute[0]);
                            Path path = Files.move(tmpDest.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE);
                            return path;
                        });
                        CacheLocks$.MODULE$.withStructureLock(this.location(), (Function0<Path> & Serializable)() -> {
                            Files.createDirectories(file$4.toPath().getParent(), new FileAttribute[0]);
                            return Files.move(tmp$1.toPath(), file$4.toPath(), StandardCopyOption.ATOMIC_MOVE);
                        });
                        lastModifiedOpt.foreach(lastModified -> file$4.setLastModified(lastModified));
                        FileCache.doTouchCheckFile$1(file$4, url$3, true);
                        either = package$.MODULE$.Right().apply(result);
                    }
                    catch (Throwable throwable) {
                        if (conn != null) {
                            CacheUrl$.MODULE$.closeConn(conn);
                        }
                        throw throwable;
                    }
                }
                if (conn == null) break block18;
                CacheUrl$.MODULE$.closeConn(conn);
            }
            return either;
        });
    }

    private final void progress$1(long currentLen, ObjectRef lenOpt$1, String url$3, Artifact artifact$1, Seq allCredentials0$2) {
        if (((Option)lenOpt$1.elem).isEmpty()) {
            lenOpt$1.elem = new Some(FileCache$.MODULE$.coursier$cache$FileCache$$contentLength(url$3, artifact$1.authentication(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), allCredentials0$2, this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.logger(), this.maxRedirections()).toOption().flatten($less$colon$less$.MODULE$.refl()));
            ((Option)lenOpt$1.elem).foreach((Function1<Option, Object> & Serializable)o -> {
                o.foreach(len -> this.logger().downloadLength(url$3, len, currentLen, true));
                return BoxedUnit.UNIT;
            });
        } else {
            this.logger().downloadProgress(url$3, currentLen);
        }
    }

    private final void done$1(ObjectRef lenOpt$1, String url$3, Artifact artifact$1, Seq allCredentials0$2) {
        if (((Option)lenOpt$1.elem).isEmpty()) {
            lenOpt$1.elem = new Some(FileCache$.MODULE$.coursier$cache$FileCache$$contentLength(url$3, artifact$1.authentication(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), allCredentials0$2, this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.logger(), this.maxRedirections()).toOption().flatten($less$colon$less$.MODULE$.refl()));
            ((Option)lenOpt$1.elem).foreach((Function1<Option, Object> & Serializable)o -> {
                o.foreach(len -> this.logger().downloadLength(url$3, len, len, true));
                return BoxedUnit.UNIT;
            });
        } else {
            ((Option)lenOpt$1.elem).foreach((Function1<Option, Object> & Serializable)o -> {
                o.foreach(len -> this.logger().downloadProgress(url$3, len));
                return BoxedUnit.UNIT;
            });
        }
    }

    private final Option checkDownload$1(ObjectRef lenOpt$1, String url$3, Artifact artifact$1, Seq allCredentials0$2, File file$4, File tmp$1) {
        Option option;
        if (file$4.exists()) {
            Right right;
            this.done$1(lenOpt$1, url$3, artifact$1, allCredentials0$2);
            Option option2 = ((Option)lenOpt$1.elem).flatten($less$colon$less$.MODULE$.refl());
            if (None$.MODULE$.equals(option2)) {
                right = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            } else if (option2 instanceof Some) {
                long fileLen;
                Some some = (Some)option2;
                long len = BoxesRunTime.unboxToLong(some.value());
                right = len == (fileLen = file$4.length()) ? package$.MODULE$.Right().apply(BoxedUnit.UNIT) : package$.MODULE$.Left().apply(new ArtifactError.WrongLength(fileLen, len, file$4.getAbsolutePath()));
            } else {
                throw new MatchError(option2);
            }
            Right res = right;
            option = new Some(res);
        } else {
            Thread.sleep(20L);
            long currentLen = tmp$1.length();
            if (currentLen == 0L && file$4.exists()) {
                this.done$1(lenOpt$1, url$3, artifact$1, allCredentials0$2);
                option = new Some(package$.MODULE$.Right().apply(BoxedUnit.UNIT));
            } else {
                this.progress$1(currentLen, lenOpt$1, url$3, artifact$1, allCredentials0$2);
                option = None$.MODULE$;
            }
        }
        return option;
    }

    private final EitherT remote$1(File file, String url, boolean keepHeaderChecksums, Artifact artifact$1) {
        return new EitherT(this.S().bind(this.allCredentials(), (Function1<Seq, Object> & Serializable)allCredentials0 -> this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            File tmp = CachePath.temporaryFile(file);
            ObjectRef lenOpt = ObjectRef.create(Option$.MODULE$.empty());
            this.logger().downloadingArtifact(url);
            Either res = null;
            try {
                res = (Either)CacheLocks$.MODULE$.withLockOr(this.location(), file, (Function0<Either> & Serializable)() -> this.doDownload$1(url, file, tmp, artifact$1, (Seq)allCredentials0, keepHeaderChecksums), (Function0<Option> & Serializable)() -> this.checkDownload$1(lenOpt, url, artifact$1, (Seq)allCredentials0, file, tmp));
            }
            catch (Throwable throwable) {
                this.logger().downloadedArtifact(url, res != null && res.isRight());
                throw throwable;
            }
            this.logger().downloadedArtifact(url, res != null && res.isRight());
            return res;
        })));
    }

    private static final File errFile$1(File file) {
        return new File(file.getParentFile(), new StringBuilder(7).append(".").append(file.getName()).append(".error").toString());
    }

    private final EitherT createErrFile$1(File errFile0$2, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        return new EitherT(this.S().schedule(this.pool(), (Function0<Right> & Serializable)() -> {
            Object object;
            if (this.cacheErrors0$1(cacheErrors$1, referenceFileOpt$lzy$1, artifact$1)) {
                Path p = errFile0$2.toPath();
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                object = Files.write(p, Array$.MODULE$.emptyByteArray(), new OpenOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        }));
    }

    private final EitherT deleteErrFile$1(File errFile0$2) {
        return new EitherT(this.S().schedule(this.pool(), (Function0<Right> & Serializable)() -> {
            Serializable serializable = errFile0$2.exists() ? BoxesRunTime.boxToBoolean(errFile0$2.delete()) : BoxedUnit.UNIT;
            return package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        }));
    }

    private final EitherT remoteKeepErrors$1(File file, String url, boolean keepHeaderChecksums, Artifact artifact$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1) {
        File errFile0 = FileCache.errFile$1(file);
        return new EitherT(this.S().bind(this.remote$1(file, url, keepHeaderChecksums, artifact$1).run(), (Function1<Either, Object> & Serializable)x0$1 -> {
            ArtifactError.NotFound notFound;
            Left left;
            ArtifactError nf;
            Either either = x0$1;
            Object f = either instanceof Left && (nf = (ArtifactError)(left = (Left)either).value()) instanceof ArtifactError.NotFound && (notFound = (ArtifactError.NotFound)nf).permanent().contains(BoxesRunTime.boxToBoolean(true)) ? this.S().map(this.createErrFile$1(errFile0, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1).run(), (Function1<Either, Either> & Serializable)x$16 -> left) : this.S().map(this.deleteErrFile$1(errFile0).run(), (Function1<Either, Either> & Serializable)x$17 -> either);
            return f;
        }));
    }

    private final EitherT checkFileExists$1(File file, String url, boolean log) {
        return new EitherT(this.S().schedule(this.pool(), (Function0<Either> & Serializable)() -> {
            Either either;
            if (file.exists()) {
                this.logger().foundLocally(url);
                either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
            } else {
                either = package$.MODULE$.Left().apply(new ArtifactError.NotFound(file.toString(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
            }
            return either;
        }));
    }

    private static final boolean checkFileExists$default$3$1() {
        return true;
    }

    public static final /* synthetic */ EitherT $anonfun$download$63(FileCache $this, File file$6, String url$5, boolean keepHeaderChecksums$2, Artifact artifact$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, boolean x0$1) {
        EitherT eitherT;
        boolean bl = x0$1;
        if (bl) {
            eitherT = $this.remoteKeepErrors$1(file$6, url$5, keepHeaderChecksums$2, artifact$1, cacheErrors$1, referenceFileOpt$lzy$1);
        } else if (!bl) {
            eitherT = new EitherT($this.S().point(package$.MODULE$.Right().apply(BoxedUnit.UNIT)));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return eitherT;
    }

    private final EitherT update$1(File file$6, String url$5, boolean keepHeaderChecksums$2, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Artifact artifact$1) {
        return this.shouldDownload$1(file$6, url$5, true, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1).flatMap((Function1<Object, EitherT> & Serializable)x0$1 -> FileCache.$anonfun$download$63(this, file$6, url$5, keepHeaderChecksums$2, artifact$1, cacheErrors$1, referenceFileOpt$lzy$1, BoxesRunTime.unboxToBoolean(x0$1)), this.sync());
    }

    public static final /* synthetic */ EitherT $anonfun$download$66(FileCache $this, File file$6, boolean x0$1) {
        EitherT eitherT;
        boolean bl = x0$1;
        if (bl) {
            eitherT = new EitherT($this.S().point(package$.MODULE$.Left().apply(new ArtifactError.FileTooOldOrNotFound(file$6.toString()))));
        } else if (!bl) {
            eitherT = new EitherT($this.S().point(package$.MODULE$.Right().apply(BoxedUnit.UNIT)));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return eitherT;
    }

    private final Object res$1(String url, boolean keepHeaderChecksums, Artifact artifact$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1) {
        EitherT eitherT;
        File file = this.localFile(url, artifact$1.authentication().map((Function1<Authentication, String> & Serializable)x$18 -> x$18.user()));
        if (url.startsWith("file:/") && !this.localArtifactsShouldBeCached()) {
            eitherT = this.checkFileExists$1(file, url, FileCache.checkFileExists$default$3$1());
        } else {
            EitherT eitherT2;
            CachePolicy cachePolicy = cachePolicy0$1;
            if (CachePolicy$LocalOnly$.MODULE$.equals(cachePolicy)) {
                eitherT2 = this.checkFileExists$1(file, url, FileCache.checkFileExists$default$3$1());
            } else {
                boolean bl = CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(cachePolicy);
                if (bl) {
                    eitherT2 = this.checkFileExists$1(file, url, false).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$19 -> this.update$1(file, url, keepHeaderChecksums, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1), this.sync());
                } else if (CachePolicy$LocalOnlyIfValid$.MODULE$.equals(cachePolicy)) {
                    eitherT2 = this.checkFileExists$1(file, url, false).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$20 -> this.shouldDownload$1(file, url, false, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1).flatMap((Function1<Object, EitherT> & Serializable)x0$1 -> FileCache.$anonfun$download$66(this, file, BoxesRunTime.unboxToBoolean(x0$1)), this.sync()), this.sync());
                } else {
                    boolean bl2 = CachePolicy$UpdateChanging$.MODULE$.equals(cachePolicy) ? true : CachePolicy$Update$.MODULE$.equals(cachePolicy);
                    if (bl2) {
                        eitherT2 = this.update$1(file, url, keepHeaderChecksums, cacheErrors$1, referenceFileOpt$lzy$1, artifact$1);
                    } else if (CachePolicy$FetchMissing$.MODULE$.equals(cachePolicy)) {
                        eitherT2 = this.checkFileExists$1(file, url, FileCache.checkFileExists$default$3$1()).orElse((Function0<EitherT> & Serializable)() -> this.remoteKeepErrors$1(file, url, keepHeaderChecksums, artifact$1, cacheErrors$1, referenceFileOpt$lzy$1), this.sync());
                    } else if (CachePolicy$ForceDownload$.MODULE$.equals(cachePolicy)) {
                        eitherT2 = this.remoteKeepErrors$1(file, url, keepHeaderChecksums, artifact$1, cacheErrors$1, referenceFileOpt$lzy$1);
                    } else {
                        throw new MatchError(cachePolicy);
                    }
                }
            }
            eitherT = eitherT2;
        }
        EitherT res = eitherT;
        return this.S().map(res.run(), (Function1<Either, Tuple2> & Serializable)x$21 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<File, String>(file, url)), x$21));
    }

    private final Option checksumRes$1(String c, Artifact artifact$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1) {
        return artifact$1.checksumUrls().get(c).map((Function1<String, Object> & Serializable)url -> this.res$1((String)url, false, artifact$1, cachePolicy0$1, cacheErrors$1, referenceFileOpt$lzy$1));
    }

    public static final /* synthetic */ boolean $anonfun$download$75(char x$22) {
        return x$22 != '-';
    }

    public static final /* synthetic */ Seq $anonfun$download$73(FileCache $this, String c$1, Artifact artifact$1, File candidate$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, boolean x0$1) {
        Seq seq;
        boolean bl = x0$1;
        if (!bl) {
            seq = Option$.MODULE$.option2Iterable($this.checksumRes$1(c$1, artifact$1, cachePolicy0$1, cacheErrors$1, referenceFileOpt$lzy$1)).toSeq();
        } else if (bl) {
            String url = (String)artifact$1.checksumUrls().getOrElse(c$1, (Function0<String> & Serializable)() -> new StringBuilder(1).append(artifact$1.url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(c$1.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$22 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$download$75(BoxesRunTime.unboxToChar(x$22))))).toString());
            seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{$this.S().point(new Tuple2(new Tuple2<File, String>(candidate$1, url), package$.MODULE$.Right().apply(BoxedUnit.UNIT)))}));
        } else {
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
        return seq;
    }

    public static final /* synthetic */ Object $anonfun$download$71(FileCache $this, File f$1, Artifact artifact$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, String c) {
        File candidate = FileCache$.MODULE$.auxiliaryFile(f$1, c);
        return $this.S().map($this.S().delay(() -> candidate.exists()), (Function1<Object, Seq> & Serializable)x0$1 -> FileCache.$anonfun$download$73($this, c, artifact$1, candidate, cachePolicy0$1, cacheErrors$1, referenceFileOpt$lzy$1, BoxesRunTime.unboxToBoolean(x0$1)));
    }

    public static final /* synthetic */ Object $anonfun$download$76(FileCache $this, Seq l) {
        return $this.S().gather((Seq)l.flatten(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Option $anonfun$download$77(FileCache $this, Artifact artifact$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, String c) {
        return $this.checksumRes$1(c, artifact$1, cachePolicy0$1, cacheErrors$1, referenceFileOpt$lzy$1);
    }

    public static final /* synthetic */ Seq $anonfun$download$78(Tuple2 r$1, Seq x$23) {
        Tuple2 tuple2 = r$1;
        return (Seq)x$23.$plus$colon(tuple2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$download$70(FileCache $this, Set checksums$1, Artifact artifact$1, CachePolicy cachePolicy0$1, boolean cacheErrors$1, LazyRef referenceFileOpt$lzy$1, Tuple2 r) {
        var9_7 = r;
        if (var9_7 == null) ** GOTO lbl-1000
        var10_8 = (Tuple2)var9_7._1();
        var11_9 = (Either)var9_7._2();
        if (var10_8 == null) ** GOTO lbl-1000
        f = (File)var10_8._1();
        if (!(var11_9 instanceof Right)) ** GOTO lbl-1000
        var13_11 = (Right)var11_9;
        var14_12 = (BoxedUnit)var13_11.value();
        v0 = BoxedUnit.UNIT;
        var15_13 = var14_12;
        if (!(v0 != null ? v0.equals(var15_13) == false : var15_13 != null)) {
            l = (Seq)checksums$1.toSeq().map((Function1<String, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$download$71(coursierapi.shaded.coursier.cache.FileCache java.io.File coursierapi.shaded.coursier.util.Artifact coursierapi.shaded.coursier.cache.CachePolicy boolean coursierapi.shaded.scala.runtime.LazyRef java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((FileCache)$this, (File)f, (Artifact)artifact$1, (CachePolicy)cachePolicy0$1, (boolean)cacheErrors$1, (LazyRef)referenceFileOpt$lzy$1));
            var7_15 = $this.S().bind($this.S().gather(l), (Function1<Seq, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$download$76(coursierapi.shaded.coursier.cache.FileCache coursierapi.shaded.scala.collection.immutable.Seq ), (Lcoursierapi/shaded/scala/collection/immutable/Seq;)Ljava/lang/Object;)((FileCache)$this));
        } else lbl-1000:
        // 4 sources

        {
            l = (Seq)checksums$1.toSeq().flatMap((Function1<String, Option> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$download$77(coursierapi.shaded.coursier.cache.FileCache coursierapi.shaded.coursier.util.Artifact coursierapi.shaded.coursier.cache.CachePolicy boolean coursierapi.shaded.scala.runtime.LazyRef java.lang.String ), (Ljava/lang/String;)Lcoursierapi/shaded/scala/Option;)((FileCache)$this, (Artifact)artifact$1, (CachePolicy)cachePolicy0$1, (boolean)cacheErrors$1, (LazyRef)referenceFileOpt$lzy$1));
            var7_15 = $this.S().gather(l);
        }
        l0 = var7_15;
        return $this.S().map(l0, (Function1<Seq, Seq> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$download$78(coursierapi.shaded.scala.Tuple2 coursierapi.shaded.scala.collection.immutable.Seq ), (Lcoursierapi/shaded/scala/collection/immutable/Seq;)Lcoursierapi/shaded/scala/collection/immutable/Seq;)((Tuple2)r));
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy0$6(char x$30) {
        return x$30 != '-';
    }

    private static final Seq checksumErrors$1(Seq checksumResults$1) {
        return (Seq)checksumResults$1.collect(new Serializable(null){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Tuple3 tuple3;
                void var3_13;
                boolean bl = false;
                Some some = null;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    bl = true;
                    some = (Some)A1;
                    Tuple3 tuple32 = (Tuple3)some.value();
                    if (tuple32 != null) {
                        String c = (String)tuple32._1();
                        String url = (String)tuple32._2();
                        Option option = (Option)tuple32._3();
                        if (None$.MODULE$.equals(option)) {
                            Tuple2<String, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), new StringBuilder(15).append(url).append(" not downloaded").toString());
                            return var3_13;
                        }
                    }
                }
                if (bl && (tuple3 = (Tuple3)some.value()) != null) {
                    Some some2;
                    Either either;
                    String c = (String)tuple3._1();
                    Option option = (Option)tuple3._3();
                    if (option instanceof Some && (either = (Either)(some2 = (Some)option).value()) instanceof Left) {
                        Left left = (Left)either;
                        ArtifactError e = (ArtifactError)left.value();
                        Tuple2<String, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), e.describe());
                        return var3_13;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var3_13;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>> x1) {
                boolean bl = false;
                Some some = null;
                Option<Tuple3<String, String, Option<Either<ArtifactError, BoxedUnit>>>> option = x1;
                if (option instanceof Some) {
                    Option option2;
                    bl = true;
                    some = (Some)option;
                    Tuple3 tuple3 = (Tuple3)some.value();
                    if (tuple3 != null && None$.MODULE$.equals(option2 = (Option)tuple3._3())) {
                        return true;
                    }
                }
                if (!bl) return false;
                Tuple3 tuple3 = (Tuple3)some.value();
                if (tuple3 == null) return false;
                Option option3 = (Option)tuple3._3();
                if (!(option3 instanceof Some)) return false;
                Some some2 = (Some)option3;
                Either either = (Either)some2.value();
                if (!(either instanceof Left)) return false;
                return true;
            }
        });
    }

    private static final Left notFound$1(File f) {
        return package$.MODULE$.Left().apply(new StringBuilder(10).append(f.getCanonicalPath()).append(" not found").toString());
    }

    private static final Either read$1(File f, boolean links$1, Artifact artifact0$1) {
        Either either;
        try {
            String string;
            if (links$1) {
                File linkFile = FileCache$.MODULE$.auxiliaryFile(f, "links");
                String string2 = f.getName();
                String string3 = ".directory";
                string = !(string2 != null ? !string2.equals(string3) : string3 != null) && linkFile.isFile() ? new String(Files.readAllBytes(linkFile.toPath()), StandardCharsets.UTF_8) : WebPage$.MODULE$.listElements(artifact0$1.url(), new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8)).mkString("\n");
            } else {
                string = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            }
            String content = string;
            either = package$.MODULE$.Right().apply(content);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = option.get();
            Left left = package$.MODULE$.Left().apply(new StringBuilder(24).append("Could not read (file:").append(f.getCanonicalPath()).append("): ").append(e.getMessage()).toString());
            either = left;
        }
        return either;
    }

    public FileCache(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Sync<F> sync) {
        this.location = location;
        this.cachePolicies = cachePolicies;
        this.checksums = checksums;
        this.credentials = credentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.retry = retry;
        this.bufferSize = bufferSize;
        this.sync = sync;
        Product.$init$(this);
        this.checksums0 = checksums.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new None$[]{None$.MODULE$})) : checksums;
    }
}

