/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.loggers;

import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.loggers.RefreshDisplay;
import coursierapi.shaded.coursier.cache.loggers.RefreshInfo;
import coursierapi.shaded.coursier.cache.loggers.RefreshInfo$CheckUpdateInfo$;
import coursierapi.shaded.coursier.cache.loggers.RefreshInfo$DownloadInfo$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Predef$ArrowAssoc$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Seq$;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.collection.mutable.ArrayBuffer;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.math.Numeric$DoubleIsFractional$;
import coursierapi.shaded.scala.math.Ordering;
import coursierapi.shaded.scala.math.Ordering$DeprecatedDoubleOrdering$;
import coursierapi.shaded.scala.math.Ordering$String$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import java.io.Serializable;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class RefreshLogger
implements CacheLogger {
    private final Writer out;
    private final RefreshDisplay display;
    private final boolean fallbackMode;
    private Option<UpdateDisplayRunnable> updateRunnableOpt;
    private final Object lock;
    private volatile ScheduledExecutorService scheduler;

    @Override
    public void foundLocally(String url) {
        CacheLogger.foundLocally$(this, url);
    }

    @Override
    public void gettingLength(String url) {
        CacheLogger.gettingLength$(this, url);
    }

    @Override
    public void gettingLengthResult(String url, Option<Object> length) {
        CacheLogger.gettingLengthResult$(this, url, length);
    }

    @Override
    public void removedCorruptFile(String url, Option<String> reason) {
        CacheLogger.removedCorruptFile$(this, url, reason);
    }

    @Override
    public Option<Object> init$default$1() {
        return CacheLogger.init$default$1$(this);
    }

    private Option<UpdateDisplayRunnable> updateRunnableOpt() {
        return this.updateRunnableOpt;
    }

    private void updateRunnableOpt_$eq(Option<UpdateDisplayRunnable> x$1) {
        this.updateRunnableOpt = x$1;
    }

    private ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    private void scheduler_$eq(ScheduledExecutorService x$1) {
        this.scheduler = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private UpdateDisplayRunnable updateRunnable() {
        return (UpdateDisplayRunnable)this.updateRunnableOpt().getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new Exception("Uninitialized TermDisplay");
        });
    }

    @Override
    public void init(Option<Object> sizeHint) {
        if (this.scheduler() == null || this.updateRunnableOpt().isEmpty()) {
            Object object = this.lock();
            synchronized (object) {
                Object object2;
                if (this.scheduler() == null) {
                    this.scheduler_$eq(Executors.newSingleThreadScheduledExecutor(new ThreadFactory(null){
                        private final ThreadFactory defaultThreadFactory;

                        private ThreadFactory defaultThreadFactory() {
                            return this.defaultThreadFactory;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public Thread newThread(Runnable r) {
                            void var2_2;
                            Thread t = this.defaultThreadFactory().newThread(r);
                            t.setDaemon(true);
                            t.setName("progress-bar");
                            return var2_2;
                        }
                        {
                            this.defaultThreadFactory = Executors.defaultThreadFactory();
                        }
                    }));
                }
                if (this.updateRunnableOpt().isEmpty()) {
                    this.updateRunnableOpt_$eq(new Some<UpdateDisplayRunnable>(new UpdateDisplayRunnable(this.out, this.display)));
                    sizeHint.foreach(n -> $this.display.sizeHint(n));
                    Duration refreshInterval = this.display.refreshInterval();
                    object2 = this.scheduler().scheduleAtFixedRate(this.updateRunnable(), refreshInterval.length(), refreshInterval.length(), refreshInterval.unit());
                } else {
                    object2 = BoxedUnit.UNIT;
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.scheduler() != null || this.updateRunnableOpt().nonEmpty()) {
            Object object = this.lock();
            synchronized (object) {
                if (this.scheduler() != null) {
                    this.scheduler().shutdown();
                    this.updateRunnableOpt().foreach((Function1<UpdateDisplayRunnable, Object> & Serializable)r -> BoxesRunTime.boxToBoolean(RefreshLogger.$anonfun$stop$1(this, r)));
                    this.scheduler_$eq(null);
                }
                if (this.updateRunnableOpt().nonEmpty()) {
                    this.updateRunnable().stop();
                    this.updateRunnableOpt_$eq(None$.MODULE$);
                }
            }
        }
    }

    @Override
    public void downloadingArtifact(String url) {
        this.updateRunnable().newEntry(url, RefreshInfo$DownloadInfo$.MODULE$.apply(0L, 0L, None$.MODULE$, System.currentTimeMillis(), false, false), (Function0<String> & Serializable)() -> new StringBuilder(13).append("Downloading ").append(url).append("\n").toString());
    }

    @Override
    public void downloadLength(String url, long totalLength, long alreadyDownloaded, boolean watching) {
        RefreshInfo info = this.updateRunnable().infos().get(url);
        Predef$.MODULE$.assert(info != null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(19).append("Incoherent state (").append(url).append(")").toString());
        RefreshInfo refreshInfo = info;
        if (!(refreshInfo instanceof RefreshInfo.DownloadInfo)) {
            throw new Exception(new StringBuilder(29).append("Incoherent display state for ").append(url).toString());
        }
        RefreshInfo.DownloadInfo downloadInfo = (RefreshInfo.DownloadInfo)refreshInfo;
        RefreshInfo.DownloadInfo downloadInfo2 = downloadInfo.withLength(new Some<Object>(BoxesRunTime.boxToLong(totalLength))).withPreviouslyDownloaded(alreadyDownloaded).withWatching(watching);
        RefreshInfo.DownloadInfo newInfo = downloadInfo2;
        this.updateRunnable().infos().put(url, newInfo);
        this.updateRunnable().update();
    }

    @Override
    public void downloadProgress(String url, long downloaded) {
        RefreshInfo info = this.updateRunnable().infos().get(url);
        Predef$.MODULE$.assert(info != null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(19).append("Incoherent state (").append(url).append(")").toString());
        RefreshInfo refreshInfo = info;
        if (!(refreshInfo instanceof RefreshInfo.DownloadInfo)) {
            throw new Exception(new StringBuilder(29).append("Incoherent display state for ").append(url).toString());
        }
        RefreshInfo.DownloadInfo downloadInfo = (RefreshInfo.DownloadInfo)refreshInfo;
        RefreshInfo.DownloadInfo downloadInfo2 = downloadInfo.withDownloaded(downloaded);
        RefreshInfo.DownloadInfo newInfo = downloadInfo2;
        this.updateRunnable().infos().put(url, newInfo);
        this.updateRunnable().update();
    }

    @Override
    public void downloadedArtifact(String url, boolean success) {
        String msg = success ? new StringBuilder(12).append("Downloaded ").append(url).append("\n").toString() : new StringBuilder(20).append("Failed to download ").append(url).append("\n").toString();
        this.updateRunnable().removeEntry(url, success, (Function0<String> & Serializable)() -> msg, (Function1<RefreshInfo, RefreshInfo> & Serializable)x -> x);
    }

    @Override
    public void checkingUpdates(String url, Option<Object> currentTimeOpt) {
        this.updateRunnable().newEntry(url, RefreshInfo$CheckUpdateInfo$.MODULE$.apply(currentTimeOpt, None$.MODULE$, false), (Function0<String> & Serializable)() -> new StringBuilder(10).append("Checking ").append(url).append("\n").toString());
    }

    @Override
    public void checkingUpdatesResult(String url, Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt) {
        boolean newUpdate = remoteTimeOpt.exists(remoteTime -> currentTimeOpt.forall(currentTime -> currentTime < remoteTime));
        this.updateRunnable().removeEntry(url, !newUpdate, (Function0<String> & Serializable)() -> new StringBuilder(9).append("Checked ").append(url).append("\n").toString(), (Function1<RefreshInfo, RefreshInfo> & Serializable)x0$1 -> {
            RefreshInfo refreshInfo = x0$1;
            if (!(refreshInfo instanceof RefreshInfo.CheckUpdateInfo)) {
                throw new Exception(new StringBuilder(29).append("Incoherent display state for ").append(url).toString());
            }
            RefreshInfo.CheckUpdateInfo checkUpdateInfo = (RefreshInfo.CheckUpdateInfo)refreshInfo;
            RefreshInfo.CheckUpdateInfo checkUpdateInfo2 = checkUpdateInfo.withRemoteTimeOpt(remoteTimeOpt).withIsDone(true);
            return checkUpdateInfo2;
        });
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(RefreshLogger $this, UpdateDisplayRunnable r) {
        Duration refreshInterval = r.display().refreshInterval();
        return $this.scheduler().awaitTermination(2L * refreshInterval.length(), refreshInterval.unit());
    }

    public RefreshLogger(Writer out, RefreshDisplay display, boolean fallbackMode) {
        this.out = out;
        this.display = display;
        this.fallbackMode = fallbackMode;
        CacheLogger.$init$(this);
        this.updateRunnableOpt = Option$.MODULE$.empty();
        this.lock = new Object();
    }

    public static class UpdateDisplayRunnable
    implements Runnable {
        private final Writer out;
        private final RefreshDisplay display;
        private boolean printedAnything0;
        private boolean stopped;
        private final AtomicBoolean needsUpdate;
        private final ArrayBuffer<String> downloads;
        private final ArrayBuffer<Tuple2<String, RefreshInfo>> doneQueue;
        private final ConcurrentHashMap<String, RefreshInfo> infos;

        public RefreshDisplay display() {
            return this.display;
        }

        private void printedAnything0_$eq(boolean x$1) {
            this.printedAnything0 = x$1;
        }

        private boolean stopped() {
            return this.stopped;
        }

        private void stopped_$eq(boolean x$1) {
            this.stopped = x$1;
        }

        private AtomicBoolean needsUpdate() {
            return this.needsUpdate;
        }

        public void update() {
            this.needsUpdate().set(true);
        }

        private ArrayBuffer<String> downloads() {
            return this.downloads;
        }

        private ArrayBuffer<Tuple2<String, RefreshInfo>> doneQueue() {
            return this.doneQueue;
        }

        public ConcurrentHashMap<String, RefreshInfo> infos() {
            return this.infos;
        }

        public void newEntry(String url, RefreshInfo info, Function0<String> fallbackMessage) {
            Predef$.MODULE$.assert(!this.infos().containsKey(url), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(39).append("Attempts to download ").append(url).append(" twice in parallel").toString());
            RefreshInfo prev = this.infos().putIfAbsent(url, info);
            Predef$.MODULE$.assert(prev == null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(54).append("Attempts to download ").append(url).append(" twice in parallel (second check)").toString());
            this.display().newEntry(this.out, url, info);
            ArrayBuffer<String> arrayBuffer = this.downloads();
            synchronized (arrayBuffer) {
                ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.downloads().append(url);
            }
            this.update();
        }

        public void removeEntry(String url, boolean success, Function0<String> fallbackMessage, Function1<RefreshInfo, RefreshInfo> update0) {
            RefreshInfo refreshInfo;
            ArrayBuffer<String> arrayBuffer = this.downloads();
            synchronized (arrayBuffer) {
                this.downloads().$minus$eq(url);
                RefreshInfo info = this.infos().remove(url);
                Predef$.MODULE$.assert(info != null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(25).append(url).append(" was not being downloaded").toString());
                Object object = success ? this.doneQueue().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(url), update0.apply(info))) : BoxedUnit.UNIT;
                refreshInfo = info;
            }
            RefreshInfo inf = refreshInfo;
            this.display().removeEntry(this.out, url, inf);
            this.update();
        }

        public void stop() {
            this.display().stop(this.out);
            this.printedAnything0_$eq(false);
            this.stopped_$eq(true);
        }

        @Override
        public void run() {
            block6: {
                Tuple2<Object, Object> tuple2;
                Tuple2<Object, Object> tuple22;
                if (this.stopped()) break block6;
                boolean needsUpdate0 = this.needsUpdate().getAndSet(false);
                if (needsUpdate0) {
                    ArrayBuffer<String> arrayBuffer = this.downloads();
                    synchronized (arrayBuffer) {
                        Vector q = (Vector)this.doneQueue().toVector().sortBy((Function1<Tuple2, String> & Serializable)x0$1 -> {
                            String url;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            String string = url = (String)tuple2._1();
                            return string;
                        }, (Ordering)Ordering$String$.MODULE$);
                        this.doneQueue().clear();
                        Vector dw = (Vector)((SeqOps)this.downloads().toVector().map((Function1<String, Tuple2> & Serializable)url -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(url), this.infos().get(url)))).sortBy((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToDouble(UpdateDisplayRunnable.$anonfun$run$3(x0$2)), Ordering$DeprecatedDoubleOrdering$.MODULE$);
                        Tuple2<Vector, Vector> tuple23 = new Tuple2<Vector, Vector>(q, dw);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var5_2
                        tuple22 = tuple23;
                    }
                } else {
                    tuple22 = new Tuple2<Object, Object>(Seq$.MODULE$.empty(), Seq$.MODULE$.empty());
                }
                if ((tuple2 = tuple22) == null) {
                    throw new MatchError(tuple2);
                }
                Seq done0 = (Seq)tuple2._1();
                Seq downloads0 = (Seq)tuple2._2();
                Tuple2<Seq, Seq> tuple24 = new Tuple2<Seq, Seq>(done0, downloads0);
                Tuple2<Seq, Seq> tuple25 = tuple24;
                Seq done02 = tuple25._1();
                Seq downloads02 = tuple25._2();
                this.display().update(this.out, done02, downloads02, needsUpdate0);
            }
        }

        public static final /* synthetic */ double $anonfun$run$3(Tuple2 x0$2) {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RefreshInfo info = (RefreshInfo)tuple2._2();
            double d = -BoxesRunTime.unboxToDouble(Option$.MODULE$.option2Iterable(info.fraction()).sum(Numeric$DoubleIsFractional$.MODULE$));
            return d;
        }

        public UpdateDisplayRunnable(Writer out, RefreshDisplay display) {
            this.out = out;
            this.display = display;
            this.printedAnything0 = false;
            this.stopped = false;
            this.needsUpdate = new AtomicBoolean(false);
            this.downloads = new ArrayBuffer();
            this.doneQueue = new ArrayBuffer();
            this.infos = new ConcurrentHashMap();
        }
    }
}

