/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.io.github.soc.directories;

import coursierapi.shaded.coursier.cache.shaded.io.github.soc.directories.UnsupportedOperatingSystemException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;

final class Util {
    static final String operatingSystemName = System.getProperty("os.name");
    static final char operatingSystem;
    private static Object base64Encoder;
    private static Method base64EncodeMethod;
    static final String SCRIPT_START_BASE64;

    static void requireNonNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static String defaultIfNullOrEmptyExtended(String string, String string2, String string3, String string4) {
        Util.requireNonNull(string2);
        Util.requireNonNull(string3);
        Util.requireNonNull(string4);
        if (Util.isNullOrEmpty(string)) {
            return Util.ensureSingleSlash(string3, string4);
        }
        return Util.ensureSingleSlash(string, string2);
    }

    static String ensureSingleSlash(String string, String string2) {
        boolean bl = string.endsWith("/");
        boolean bl2 = string2.startsWith("/");
        if (bl && bl2) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() - 1);
            stringBuilder.append(string, 0, string.length() - 1).append(string2);
            return stringBuilder.toString();
        }
        if (!bl && !bl2) {
            return string + '/' + string2;
        }
        return string + string2;
    }

    static String linuxRuntimeDir(String string) {
        String string2 = System.getenv("XDG_RUNTIME_DIR");
        if (Util.isNullOrEmpty(string2)) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        return string2 + '/' + string;
    }

    static String[] getWinDirs(String ... stringArray) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 68);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[Dir]::GetKnownFolderPath(\"");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\")\n");
        }
        String string = SCRIPT_START_BASE64 + Util.toUTF16LEBase64(stringBuilder.toString() + "}");
        return Util.runCommands(n, Charset.forName("UTF-8"), "powershell.exe", "-EncodedCommand", string);
    }

    private static String toUTF16LEBase64(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-16LE"));
        if (base64EncodeMethod == null) {
            Util.initBase64Encoding();
        }
        try {
            return (String)base64EncodeMethod.invoke(base64Encoder, new Object[]{byArray});
        }
        catch (Exception exception) {
            throw new RuntimeException("Base64 encoding failed!", exception);
        }
    }

    private static void initBase64Encoding() {
        try {
            base64Encoder = Class.forName("java.util.Base64").getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
            base64EncodeMethod = base64Encoder.getClass().getMethod("encodeToString", byte[].class);
        }
        catch (Exception exception) {
            try {
                base64EncodeMethod = Class.forName("sun.misc.BASE64Encoder").getMethod("encode", byte[].class);
            }
            catch (Exception exception2) {
                throw new RuntimeException("Could not find any viable Base64 encoder! (java.util.Base64 failed with: " + exception.getMessage() + ")", exception2);
            }
        }
    }

    private static String[] runCommands(int n, Charset charset, String ... stringArray) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String[] stringArray2 = new String[n];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
        try {
            for (int i = 0; i < n; ++i) {
                String string;
                stringArray2[i] = string = bufferedReader.readLine();
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static String macOSApplicationPath(String string, String string2, String string3) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(Math.max(Util.stringLength(string) + Util.stringLength(string2) + Util.stringLength(string3), 0));
        boolean bl2 = !Util.isNullOrEmpty(string);
        boolean bl3 = !Util.isNullOrEmpty(string2);
        boolean bl4 = bl = !Util.isNullOrEmpty(string3);
        if (bl2) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string, "-", false));
            if (bl3 || bl) {
                stringBuilder.append('.');
            }
        }
        if (bl3) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string2, "-", false));
            if (bl) {
                stringBuilder.append('.');
            }
        }
        if (bl) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string3, "-", false));
        }
        return stringBuilder.toString();
    }

    static String windowsApplicationPath(String string, String string2, String string3) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(Math.max(Util.stringLength(string2) + Util.stringLength(string3), 0));
        boolean bl2 = !Util.isNullOrEmpty(string2);
        boolean bl3 = bl = !Util.isNullOrEmpty(string3);
        if (bl2) {
            stringBuilder.append(string2);
            if (bl) {
                stringBuilder.append('\\');
            }
        }
        if (bl) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    static int stringLength(String string) {
        if (string == null) {
            return -1;
        }
        return string.length();
    }

    static String trimLowercaseReplaceWhitespace(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl2 = false;
        int n = string.codePointCount(0, string.length());
        boolean bl3 = !string2.isEmpty();
        for (int i = 0; i < n; ++i) {
            int n2 = string.codePointAt(i);
            if (n2 == 32) {
                if (!bl2 || !bl3 || !Util.codePointExistsAndNotSpace(string, n, i + 1)) continue;
                stringBuilder.append('-');
                bl2 = false;
                continue;
            }
            stringBuilder.appendCodePoint(bl ? Character.toLowerCase(n2) : n2);
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    private static boolean codePointExistsAndNotSpace(String string, int n, int n2) {
        return n2 < n && string.codePointAt(n2) != 32;
    }

    static {
        String string = operatingSystemName.toLowerCase(Locale.ROOT);
        if (string.contains("linux")) {
            operatingSystem = (char)108;
        } else if (string.contains("mac")) {
            operatingSystem = (char)109;
        } else if (string.contains("windows")) {
            operatingSystem = (char)119;
        } else if (string.contains("bsd")) {
            operatingSystem = (char)98;
        } else if (string.contains("sunos")) {
            operatingSystem = (char)115;
        } else {
            throw new UnsupportedOperatingSystemException("directories are not supported on " + operatingSystemName);
        }
        base64Encoder = null;
        base64EncodeMethod = null;
        SCRIPT_START_BASE64 = operatingSystem == 'w' ? Util.toUTF16LEBase64("& {\n[Console]::OutputEncoding = [System.Text.Encoding]::UTF8\nAdd-Type @\"\nusing System;\nusing System.Runtime.InteropServices;\npublic class Dir {\n  [DllImport(\"shell32.dll\")]\n  private static extern int SHGetKnownFolderPath([MarshalAs(UnmanagedType.LPStruct)] Guid rfid, uint dwFlags, IntPtr hToken, out IntPtr pszPath);\n  public static string GetKnownFolderPath(string rfid) {\n    IntPtr pszPath;\n    if (SHGetKnownFolderPath(new Guid(rfid), 0, IntPtr.Zero, out pszPath) != 0) return \"\";\n    string path = Marshal.PtrToStringUni(pszPath);\n    Marshal.FreeCoTaskMem(pszPath);\n    return path;\n  }\n}\n\"@\n") : null;
    }
}

