/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.paths;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;

public class Util {
    private static final Pattern propertyRegex = Pattern.compile(Pattern.quote("${") + "[^" + Pattern.quote("{[()]}") + "]*" + Pattern.quote("}"));
    private static volatile Boolean useAnsiOutput0 = null;

    public static void createDirectories(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    private static boolean computeUseAnsiOutput() {
        boolean bl;
        if (System.console() == null) {
            return false;
        }
        if (System.getenv("INSIDE_EMACS") != null) {
            return false;
        }
        if (System.getenv("CI") != null) {
            return false;
        }
        String string = System.getenv("COURSIER_PROGRESS");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("1"))) {
            bl = false;
        } else if (string != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disable") || string.equalsIgnoreCase("0"))) {
            bl = true;
        } else {
            boolean bl2 = bl = System.getenv("COURSIER_NO_TERM") != null;
        }
        return !bl;
    }

    public static boolean useAnsiOutput() {
        if (useAnsiOutput0 == null) {
            useAnsiOutput0 = Util.computeUseAnsiOutput();
        }
        return useAnsiOutput0;
    }
}

