/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util;

import java.util.ArrayList;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.FilePermission;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.Logger;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.StringUtils;

public class FilePermissionUtils {
    private FilePermissionUtils() {
    }

    public static FilePermission getFilePermissionFromMode(String mode, Logger logger) {
        if (StringUtils.isBlank(mode)) {
            throw new IllegalArgumentException(" file mode cannot be empty");
        }
        if (mode.length() != 3 && mode.length() != 4) {
            throw new IllegalArgumentException(" file mode must be 3 or 4 characters");
        }
        ArrayList<String> modes = new ArrayList<String>(mode.length());
        int size = mode.length();
        for (int i = 0; i < size; ++i) {
            modes.add(String.valueOf(mode.charAt(i)));
        }
        boolean executable = false;
        boolean ownerOnlyExecutable = true;
        boolean ownerOnlyReadable = true;
        boolean readable = false;
        boolean ownerOnlyWritable = true;
        boolean writable = false;
        try {
            int userMode = Integer.valueOf((String)modes.get(mode.length() == 4 ? 1 : 0));
            switch (userMode) {
                case 0: {
                    break;
                }
                case 1: {
                    executable = true;
                    break;
                }
                case 2: {
                    writable = true;
                    break;
                }
                case 3: {
                    writable = true;
                    executable = true;
                    break;
                }
                case 4: {
                    readable = true;
                    break;
                }
                case 5: {
                    readable = true;
                    executable = true;
                    break;
                }
                case 6: {
                    readable = true;
                    writable = true;
                    break;
                }
                case 7: {
                    writable = true;
                    readable = true;
                    executable = true;
                    break;
                }
                default: {
                    logger.warn("ignore file mode " + userMode);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(" file mode must contains only number " + mode);
        }
        try {
            int allMode = Integer.valueOf((String)modes.get(mode.length() == 4 ? 3 : 2));
            switch (allMode) {
                case 0: {
                    break;
                }
                case 1: {
                    executable = true;
                    ownerOnlyExecutable = false;
                    break;
                }
                case 2: {
                    writable = true;
                    ownerOnlyWritable = false;
                    break;
                }
                case 3: {
                    writable = true;
                    executable = true;
                    ownerOnlyExecutable = false;
                    ownerOnlyWritable = false;
                    break;
                }
                case 4: {
                    readable = true;
                    ownerOnlyReadable = false;
                    break;
                }
                case 5: {
                    readable = true;
                    executable = true;
                    ownerOnlyReadable = false;
                    ownerOnlyExecutable = false;
                    break;
                }
                case 6: {
                    readable = true;
                    ownerOnlyReadable = false;
                    writable = true;
                    ownerOnlyWritable = false;
                    break;
                }
                case 7: {
                    writable = true;
                    readable = true;
                    executable = true;
                    ownerOnlyReadable = false;
                    ownerOnlyExecutable = false;
                    ownerOnlyWritable = false;
                    break;
                }
                default: {
                    logger.warn("ignore file mode " + allMode);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(" file mode must contains only number " + mode);
        }
        return new FilePermission(executable, ownerOnlyExecutable, ownerOnlyReadable, readable, ownerOnlyWritable, writable);
    }
}

