/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.component.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.AbstractRecipe;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.ConstructionException;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.ObjectRecipe;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.Option;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.RecipeHelper;
import lmcoursier.internal.shaded.org.codehaus.plexus.ComponentRegistry;
import lmcoursier.internal.shaded.org.codehaus.plexus.MutablePlexusContainer;
import lmcoursier.internal.shaded.org.codehaus.plexus.PlexusContainer;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.MapOrientedComponent;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.builder.ComponentBuildListener;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.builder.ComponentBuilder;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.collections.ComponentList;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.collections.ComponentMap;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurator;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.factory.ComponentFactory;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.factory.ComponentInstantiationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.factory.java.JavaComponentFactory;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.manager.ComponentManager;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentRequirement;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentRequirementList;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import lmcoursier.internal.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import lmcoursier.internal.shaded.org.codehaus.plexus.configuration.PlexusConfigurationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.Logger;
import lmcoursier.internal.shaded.org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.StringUtils;

public class XBeanComponentBuilder<T>
implements ComponentBuilder<T> {
    private static final ThreadLocal<LinkedHashSet<ComponentDescriptor<?>>> STACK = new ThreadLocal<LinkedHashSet<ComponentDescriptor<?>>>(){

        @Override
        protected LinkedHashSet<ComponentDescriptor<?>> initialValue() {
            return new LinkedHashSet();
        }
    };
    private ComponentManager<T> componentManager;

    public XBeanComponentBuilder() {
    }

    public XBeanComponentBuilder(ComponentManager<T> componentManager) {
        this.setComponentManager(componentManager);
    }

    public ComponentManager<T> getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager<T> componentManager) {
        this.componentManager = componentManager;
    }

    protected MutablePlexusContainer getContainer() {
        return this.componentManager.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T build(ComponentDescriptor<T> descriptor, ClassRealm realm2, ComponentBuildListener listener) throws ComponentInstantiationException, ComponentLifecycleException {
        LinkedHashSet<ComponentDescriptor<?>> stack = STACK.get();
        if (stack.contains(descriptor)) {
            ArrayList circularity = new ArrayList(stack);
            circularity.subList(circularity.indexOf(descriptor), circularity.size());
            circularity.add(descriptor);
            String message = "Creation circularity: ";
            for (ComponentDescriptor componentDescriptor : circularity) {
                message = message + "\n\t[" + componentDescriptor.getRole() + ", " + componentDescriptor.getRoleHint() + "]";
            }
            throw new ComponentInstantiationException(message);
        }
        stack.add(descriptor);
        try {
            if (listener != null) {
                listener.beforeComponentCreate(descriptor, realm2);
            }
            T component = this.createComponentInstance(descriptor, realm2);
            if (listener != null) {
                listener.componentCreated(descriptor, component, realm2);
            }
            this.startComponentLifecycle(component, realm2);
            if (listener != null) {
                listener.componentConfigured(descriptor, component, realm2);
            }
            T t = component;
            return t;
        }
        finally {
            stack.remove(descriptor);
        }
    }

    protected T createComponentInstance(ComponentDescriptor<T> descriptor, ClassRealm realm2) throws ComponentInstantiationException, ComponentLifecycleException {
        MutablePlexusContainer container = this.getContainer();
        if (realm2 == null) {
            realm2 = descriptor.getRealm();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(realm2);
        try {
            Object instance;
            ComponentFactory componentFactory = container.getComponentFactoryManager().findComponentFactory(descriptor.getComponentFactory());
            if (JavaComponentFactory.class.equals(componentFactory.getClass())) {
                ObjectRecipe recipe = this.createObjectRecipe(null, descriptor, realm2);
                instance = recipe.create();
            } else {
                instance = componentFactory.newInstance(descriptor, realm2, container);
                ObjectRecipe recipe = this.createObjectRecipe(instance, descriptor, realm2);
                recipe.setProperties(instance);
            }
            if (instance instanceof MapOrientedComponent) {
                MapOrientedComponent mapOrientedComponent = (MapOrientedComponent)instance;
                this.processMapOrientedComponent(descriptor, mapOrientedComponent, realm2);
            }
            Object object = instance;
            return (T)object;
        }
        catch (Exception e) {
            throw new ComponentLifecycleException("Error constructing component " + descriptor.getHumanReadableKey(), e);
        }
        catch (LinkageError e) {
            throw new ComponentLifecycleException("Error constructing component " + descriptor.getHumanReadableKey(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public ObjectRecipe createObjectRecipe(T instance, ComponentDescriptor<T> descriptor, ClassRealm realm2) throws ComponentInstantiationException, PlexusConfigurationException {
        Class<Object> implClass;
        String factoryMethod = null;
        String[] constructorArgNames = null;
        Class[] constructorArgTypes = null;
        Class<Object> clazz = implClass = instance != null ? instance.getClass() : descriptor.getImplementationClass();
        if (implClass == null || implClass == Object.class) {
            try {
                realm2.loadClass(descriptor.getImplementation());
            }
            catch (ClassNotFoundException e) {
                throw new ComponentInstantiationException("Could not load implementation class for component " + descriptor.getHumanReadableKey() + " from class realm " + realm2, e);
            }
            catch (LinkageError e) {
                throw new ComponentInstantiationException("Could not load implementation class for component " + descriptor.getHumanReadableKey() + " from class realm " + realm2, e);
            }
        }
        ObjectRecipe recipe = new ObjectRecipe(implClass, factoryMethod, constructorArgNames, constructorArgTypes);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        if (!MapOrientedComponent.class.isAssignableFrom(implClass)) {
            PlexusConfiguration configuration;
            for (ComponentRequirement requirement : descriptor.getRequirements()) {
                String name = requirement.getFieldName();
                RequirementRecipe<T> requirementRecipe = new RequirementRecipe<T>(descriptor, requirement, this.getContainer(), name == null);
                if (name != null) {
                    recipe.setProperty(name, requirementRecipe);
                    continue;
                }
                recipe.setAutoMatchProperty(requirement.getRole(), requirementRecipe);
            }
            if (this.shouldConfigure(descriptor) && (configuration = descriptor.getConfiguration()) != null) {
                for (String name : configuration.getAttributeNames()) {
                    String value;
                    try {
                        value = configuration.getAttribute(name);
                    }
                    catch (PlexusConfigurationException e) {
                        throw new ComponentInstantiationException("Error getting value for attribute " + name, e);
                    }
                    name = this.fromXML(name);
                    recipe.setProperty(name, (Object)value);
                }
                for (PlexusConfiguration child : configuration.getChildren()) {
                    String name = child.getName();
                    name = this.fromXML(name);
                    if (StringUtils.isNotEmpty(child.getValue(null))) {
                        recipe.setProperty(name, (Object)child.getValue());
                        continue;
                    }
                    recipe.setProperty(name, (Object)new PlexusConfigurationRecipe(child));
                }
            }
        }
        return recipe;
    }

    protected boolean shouldConfigure(ComponentDescriptor<T> descriptor) {
        String configuratorId = descriptor.getComponentConfigurator();
        if (StringUtils.isEmpty(configuratorId)) {
            return true;
        }
        try {
            ComponentConfigurator componentConfigurator = this.getContainer().lookup(ComponentConfigurator.class, configuratorId);
            return componentConfigurator == null || componentConfigurator.getClass().equals(BasicComponentConfigurator.class);
        }
        catch (ComponentLookupException componentLookupException) {
            return true;
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter(StringUtils.removeAndHump(elementName, "-"));
    }

    protected void startComponentLifecycle(Object component, ClassRealm realm2) throws ComponentLifecycleException {
        try {
            this.componentManager.start(component);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error starting component", e);
        }
    }

    private void processMapOrientedComponent(ComponentDescriptor<?> descriptor, MapOrientedComponent mapOrientedComponent, ClassRealm realm2) throws ComponentConfigurationException, ComponentLookupException {
        MutablePlexusContainer container = this.getContainer();
        for (ComponentRequirement requirement : descriptor.getRequirements()) {
            String role = requirement.getRole();
            String hint = requirement.getRoleHint();
            String mappingType = requirement.getFieldMappingType();
            Object value = StringUtils.isNotEmpty(hint) && !hint.equals("default") ? container.lookup(role, hint) : ("single".equals(mappingType) ? container.lookup(role, hint) : ("map".equals(mappingType) ? container.lookupMap(role) : ("set".equals(mappingType) ? new HashSet<Object>(container.lookupList(role)) : container.lookup(role, hint))));
            mapOrientedComponent.addComponentRequirement(requirement, value);
        }
        MapConverter converter = new MapConverter();
        DefaultConverterLookup converterLookup = new DefaultConverterLookup();
        DefaultExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
        PlexusConfiguration configuration = container.getConfigurationSource().getConfiguration(descriptor);
        if (configuration != null) {
            Map context = (Map)converter.fromConfiguration(converterLookup, configuration, null, null, realm2, expressionEvaluator, null);
            mapOrientedComponent.setComponentConfiguration(context);
        }
    }

    private class PlexusConfigurationRecipe
    extends AbstractRecipe {
        private final PlexusConfiguration child;

        public PlexusConfigurationRecipe(PlexusConfiguration child) {
            this.child = child;
        }

        @Override
        public boolean canCreate(Type type) {
            try {
                ConverterLookup lookup = this.createConverterLookup();
                lookup.lookupConverterForType(RecipeHelper.toClass(type));
                return true;
            }
            catch (ComponentConfigurationException e) {
                return false;
            }
        }

        @Override
        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            try {
                ConverterLookup lookup = this.createConverterLookup();
                ConfigurationConverter converter = lookup.lookupConverterForType(RecipeHelper.toClass(expectedType));
                ObjectRecipe caller = (ObjectRecipe)RecipeHelper.getCaller();
                Class parentClass = RecipeHelper.toClass(caller.getType());
                Object value = converter.fromConfiguration(lookup, this.child, RecipeHelper.toClass(expectedType), parentClass, Thread.currentThread().getContextClassLoader(), new DefaultExpressionEvaluator());
                return value;
            }
            catch (ComponentConfigurationException e) {
                throw new ConstructionException("Unable to convert configuration for property " + this.child.getName() + " to " + RecipeHelper.toClass(expectedType).getName());
            }
        }

        private ConverterLookup createConverterLookup() {
            ClassRealm realm2 = (ClassRealm)Thread.currentThread().getContextClassLoader();
            DefaultConverterLookup lookup = new DefaultConverterLookup();
            lookup.registerConverter(new ClassRealmConverter(realm2));
            return lookup;
        }
    }

    public static class RequirementRecipe<T>
    extends AbstractRecipe {
        private ComponentDescriptor<T> componentDescriptor;
        private ComponentRequirement requirement;
        private MutablePlexusContainer container;
        private boolean autoMatch;

        public RequirementRecipe(ComponentDescriptor<T> componentDescriptor, ComponentRequirement requirement, MutablePlexusContainer container, boolean autoMatch) {
            this.componentDescriptor = componentDescriptor;
            this.requirement = requirement;
            this.container = container;
            this.autoMatch = autoMatch;
        }

        @Override
        public boolean canCreate(Type expectedType) {
            if (!this.autoMatch) {
                return true;
            }
            Class propertyType = RecipeHelper.toClass(expectedType);
            if (propertyType.isArray() || Map.class.isAssignableFrom(propertyType) || Collection.class.isAssignableFrom(propertyType) || this.requirement instanceof ComponentRequirementList) {
                return false;
            }
            try {
                ComponentRegistry componentRegistry = this.container.getComponentRegistry();
                return componentRegistry.getComponentDescriptor(propertyType, this.requirement.getRole(), this.requirement.getRoleHint()) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            Class propertyType = RecipeHelper.toClass(expectedType);
            try {
                ComponentList assignment;
                String role = this.requirement.getRole();
                List<String> roleHints = null;
                if (this.requirement instanceof ComponentRequirementList) {
                    roleHints = ((ComponentRequirementList)this.requirement).getRoleHints();
                }
                if (propertyType.isArray()) {
                    assignment = new ArrayList<Object>(this.container.lookupList(role, roleHints));
                } else if (Map.class.equals((Object)propertyType)) {
                    Object keyType = Object.class;
                    Object valueType = Object.class;
                    Type[] typeParameters = RecipeHelper.getTypeParameters(Collection.class, expectedType);
                    if (typeParameters != null && typeParameters.length == 2) {
                        if (typeParameters[0] instanceof Class) {
                            keyType = typeParameters[0];
                        }
                        if (typeParameters[1] instanceof Class) {
                            valueType = typeParameters[1];
                        }
                    }
                    assignment = new ComponentMap(this.container, RecipeHelper.toClass(valueType), role, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (List.class.equals((Object)propertyType)) {
                    Type[] typeParameters = RecipeHelper.getTypeParameters(Collection.class, expectedType);
                    Object componentType = Object.class;
                    if (typeParameters != null && typeParameters.length == 1 && typeParameters[0] instanceof Class) {
                        componentType = typeParameters[0];
                    }
                    assignment = new ComponentList(this.container, RecipeHelper.toClass(componentType), role, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (Set.class.equals((Object)propertyType) || Collection.class.isAssignableFrom(propertyType)) {
                    assignment = this.container.lookupMap(role, roleHints);
                } else if (Logger.class.equals((Object)propertyType)) {
                    assignment = this.container.getLoggerManager().getLoggerForComponent(this.componentDescriptor.getRole());
                } else if (PlexusContainer.class.equals((Object)propertyType)) {
                    assignment = this.container;
                } else {
                    String roleHint = this.requirement.getRoleHint();
                    assignment = this.container.lookup(propertyType, role, roleHint);
                }
                return assignment;
            }
            catch (ComponentLookupException e) {
                if (this.requirement.isOptional()) {
                    return null;
                }
                throw new ConstructionException("Composition failed of field " + this.requirement.getFieldName() + " in object of type " + this.componentDescriptor.getImplementation() + " because the requirement " + this.requirement + " was missing)", e);
            }
        }

        @Override
        public String toString() {
            return "RequirementRecipe[fieldName=" + this.requirement.getFieldName() + ", role=" + this.componentDescriptor.getRole() + "]";
        }
    }
}

