/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.apache.xbean.recipe;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.AbstractRecipe;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.ConstructionException;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.ExecutionContext;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.NoSuchObjectException;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.Recipe;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.RecipeHelper;
import lmcoursier.internal.shaded.org.apache.xbean.recipe.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceRecipe
extends AbstractRecipe {
    private String referenceName;

    public ReferenceRecipe() {
    }

    public ReferenceRecipe(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String name) {
        this.referenceName = name;
    }

    @Override
    public List<Recipe> getNestedRecipes() {
        ExecutionContext context = ExecutionContext.getContext();
        if (!context.containsObject(this.referenceName)) {
            throw new NoSuchObjectException(this.referenceName);
        }
        Object object = ExecutionContext.getContext().getObject(this.referenceName);
        if (object instanceof Recipe) {
            Recipe recipe = (Recipe)object;
            return Collections.singletonList(recipe);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Recipe> getConstructorRecipes() {
        return this.getNestedRecipes();
    }

    @Override
    public boolean canCreate(Type type) {
        if (this.referenceName == null) {
            throw new ConstructionException("Reference name has not been set");
        }
        ExecutionContext context = ExecutionContext.getContext();
        Object object = context.getObject(this.referenceName);
        if (object instanceof Recipe) {
            Recipe recipe = (Recipe)object;
            return recipe.canCreate(type);
        }
        return RecipeHelper.isInstance(type, object);
    }

    @Override
    protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
        Object object;
        if (this.referenceName == null) {
            throw new ConstructionException("Reference name has not been set");
        }
        ExecutionContext context = ExecutionContext.getContext();
        if (!context.containsObject(this.referenceName)) {
            if (!lazyRefAllowed) {
                throw new ConstructionException("Currently no object registered with name " + this.referenceName + " and a lazy reference not allowed");
            }
            Reference reference = new Reference(this.referenceName);
            context.addReference(reference);
            object = reference;
        } else {
            object = context.getObject(this.referenceName);
            if (object instanceof Recipe) {
                if (lazyRefAllowed) {
                    Reference reference = new Reference(this.referenceName);
                    context.addReference(reference);
                    object = reference;
                } else {
                    Recipe recipe = (Recipe)object;
                    object = recipe.create(expectedType, false);
                }
            }
        }
        if (this.getName() != null) {
            if (object instanceof Reference) {
                object = new WrapperReference(this.getName(), (Reference)object);
            } else {
                ExecutionContext.getContext().addObject(this.getName(), object);
            }
        }
        return object;
    }

    private static class WrapperReference
    extends Reference {
        private final Reference delegate;

        private WrapperReference(String name, Reference delegate) {
            super(name);
            this.delegate = delegate;
        }

        public boolean isResolved() {
            return this.delegate.isResolved();
        }

        public Object get() {
            return this.delegate.get();
        }

        public void set(Object object) {
            if (this.isResolved()) {
                throw new ConstructionException("Reference has already been resolved");
            }
            ExecutionContext.getContext().addObject(this.getName(), object);
            this.delegate.set(object);
        }

        public void setAction(Reference.Action action) {
            this.delegate.setAction(action);
        }
    }
}

