/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.ClassWorld;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;

public class ClassRealmUtil {
    public static Set<ClassRealm> getContextRealms(ClassWorld world) {
        LinkedHashSet<ClassRealm> realms = new LinkedHashSet<ClassRealm>();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof ClassRealm)) continue;
            realms.add((ClassRealm)classLoader);
            LinkedList<ClassRealm> queue = new LinkedList<ClassRealm>();
            queue.add((ClassRealm)classLoader);
            while (!queue.isEmpty()) {
                ClassRealm realm2 = (ClassRealm)queue.remove();
                Collection<ClassRealm> importRealms = realm2.getImportRealms();
                for (ClassRealm importRealm : importRealms) {
                    if (!realms.add(importRealm)) continue;
                    queue.add(importRealm);
                }
                ClassRealm parentRealm = realm2.getParentRealm();
                if (parentRealm == null || !realms.add(parentRealm)) continue;
                queue.add(parentRealm);
            }
        }
        if (world != null) {
            Iterator it = realms.iterator();
            while (it.hasNext()) {
                ClassRealm realm3 = (ClassRealm)it.next();
                if (realm3.getWorld() == world) continue;
                it.remove();
            }
        }
        return realms;
    }
}

