/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.snappy;

import java.io.IOException;
import lmcoursier.internal.shaded.javax.inject.Named;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.AbstractArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.snappy.SnappyCompressor;

@Named(value="snappy")
public class SnappyArchiver
extends AbstractArchiver {
    private final SnappyCompressor compressor = new SnappyCompressor();

    @Override
    public void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        ArchiveEntry entry = iter.next();
        if (iter.hasNext()) {
            throw new ArchiverException("There is more than one file in input.");
        }
        this.compressor.setSource(entry.getResource());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected void close() {
        this.compressor.close();
    }

    @Override
    protected String getArchiveType() {
        return "snappy";
    }
}

