/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zstd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.javax.inject.Named;
import lmcoursier.internal.shaded.org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.AbstractUnArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.Streams;

@Named(value="zst")
public class ZstdUnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_ZSTD = "zstd";

    public ZstdUnArchiver() {
    }

    public ZstdUnArchiver(File source) {
        super(source);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(ZstdUnArchiver.getZstdInputStream(Streams.bufferedInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_ZSTD))), Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile(), OPERATION_ZSTD)), OPERATION_ZSTD);
        }
    }

    @Nonnull
    public static ZstdCompressorInputStream getZstdInputStream(InputStream in) throws ArchiverException {
        try {
            return new ZstdCompressorInputStream(in);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Trouble creating Zstd compressor, invalid file ?", ioe);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        throw new UnsupportedOperationException("Targeted execution not supported in zstd format");
    }
}

