/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.components.io.filemappers;

import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.javax.inject.Named;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.filemappers.AbstractFileMapper;

@Named(value="suffix")
public class SuffixFileMapper
extends AbstractFileMapper {
    public static final String ROLE_HINT = "suffix";
    private String suffix;

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("The suffix is null.");
        }
        this.suffix = suffix;
    }

    @Override
    @Nonnull
    public String getMappedFileName(@Nonnull String pName) {
        String dirname;
        String name = super.getMappedFileName(pName);
        if (this.suffix == null) {
            throw new IllegalStateException("The suffix has not been set.");
        }
        int dirSep = Math.max(name.lastIndexOf(47), name.lastIndexOf(92));
        String filename = dirSep > 0 ? name.substring(dirSep + 1) : name;
        String string = dirname = dirSep > 0 ? name.substring(0, dirSep + 1) : "";
        if (filename.contains(".")) {
            String beforeExtension = filename.substring(0, filename.indexOf(46));
            String afterExtension = filename.substring(filename.indexOf(46) + 1);
            return dirname + beforeExtension + this.suffix + "." + afterExtension;
        }
        return name + this.suffix;
    }
}

