/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization;

import lmcoursier.internal.shaded.org.codehaus.plexus.PlexusContainer;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.AbstractCoreComponentInitializationPhase;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import lmcoursier.internal.shaded.org.codehaus.plexus.container.initialization.ContainerInitializationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.Logger;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.LoggerManager;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.console.ConsoleLoggerManager;

public class InitializeLoggerManagerPhase
extends AbstractCoreComponentInitializationPhase {
    @Override
    public void initializeCoreComponent(ContainerInitializationContext context) throws ContainerInitializationException {
        LoggerManager loggerManager = context.getContainer().getLoggerManager();
        if (loggerManager == null) {
            try {
                loggerManager = context.getContainer().lookup(LoggerManager.class);
            }
            catch (ComponentLookupException e) {
                ComponentDescriptor cd = new ComponentDescriptor();
                cd.setRole(LoggerManager.ROLE);
                cd.setRoleHint("default");
                cd.setImplementation(ConsoleLoggerManager.class.getName());
                try {
                    context.getContainer().addComponentDescriptor(cd);
                }
                catch (CycleDetectedInComponentGraphException cre) {
                    throw new ContainerInitializationException("Error setting up logging manager.", cre);
                }
                loggerManager = new ConsoleLoggerManager("info");
            }
            context.getContainer().setLoggerManager(loggerManager);
        }
        Logger logger = loggerManager.getLoggerForComponent(PlexusContainer.class.getName());
        context.getContainer().enableLogging(logger);
    }
}

