/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lmcoursier.internal.shaded.coursier.cache.CacheDefaults$;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger$;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy;
import lmcoursier.internal.shaded.coursier.cache.FileCache;
import lmcoursier.internal.shaded.coursier.cache.internal.FileUtil;
import lmcoursier.internal.shaded.coursier.cache.internal.FileUtil$;
import lmcoursier.internal.shaded.coursier.cache.internal.Retry;
import lmcoursier.internal.shaded.coursier.credentials.Credentials;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.util.Sync;
import lmcoursier.internal.shaded.coursier.util.Task;
import lmcoursier.internal.shaded.coursier.util.Task$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class FileCache$
implements scala.Serializable {
    public static FileCache$ MODULE$;

    static {
        new FileCache$();
    }

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull(Predef$.MODULE$.$conforms()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file) {
        return new StringBuilder(3).append(".").append(file.getName()).append("__").toString();
    }

    public void clearAuxiliaryFiles(File file) {
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.getParentFile().listFiles(filter))).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public File auxiliaryFile(File file, String key) {
        String key0 = (String)new StringOps(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT))).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar((Object)x$21))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file)).append(key0).toString());
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return this.apply(CacheDefaults$.MODULE$.location(), S);
    }

    public BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile, Retry retry) {
        byte[] byArray;
        String location0 = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(location.getCanonicalPath())).stripSuffix(File.separator)).append(File.separator).toString();
        boolean isInCache = localFile.getCanonicalPath().startsWith(location0);
        if (!isInCache) {
            byArray = this.computeDigest(sumType, localFile, retry);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = (byte[])retry.retry((Function0 & Serializable & scala.Serializable)() -> Files.readAllBytes(cacheFilePath), (PartialFunction<Throwable, BoxedUnit>)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                    }
                });
            }
            catch (NoSuchFileException noSuchFileException) {
                byte[] bytes = this.computeDigest(sumType, localFile, retry);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    retry.retry((Function0 & Serializable & scala.Serializable)() -> {
                        Object object;
                        try {
                            object = Files.move(tmpFile, cacheFilePath, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }, (PartialFunction<Throwable, BoxedUnit>)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)function1.apply(x2);
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                        }
                    });
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = bytes;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, digested);
    }

    private byte[] computeDigest(String sumType, File localFile, Retry retry) {
        MessageDigest md = MessageDigest.getInstance(sumType);
        ObjectRef is = ObjectRef.create(null);
        try {
            retry.retry((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                is$1.elem = new FileInputStream(localFile);
            }, (PartialFunction<Throwable, BoxedUnit>)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof FileNotFoundException && Properties$.MODULE$.isWin()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable instanceof FileNotFoundException && Properties$.MODULE$.isWin();
                }
            });
            FileUtil$.MODULE$.withContent((FileInputStream)is.elem, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        finally {
            if ((FileInputStream)is.elem != null) {
                ((FileInputStream)is.elem).close();
            }
        }
        return md.digest();
    }

    public <F> FileCache<F> apply(File location, Sync<F> sync) {
        return new FileCache<F>(location, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.retryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.bufferSize(), (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, (Seq<ClassLoader>)Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, FiniteDuration retryBackoffInitialDelay2, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, retryBackoffInitialDelay2, CacheDefaults$.MODULE$.retryBackoffMultiplier(), sync);
    }

    public <F> FileCache<F> apply(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> sync) {
        return new FileCache<F>(location, cachePolicies, checksums, credentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, retry, bufferSize, classLoaders, clock, retryBackoffInitialDelay2, retryBackoffMultiplier, sync);
    }

    public <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$21) {
        return x$21 != '-';
    }

    private FileCache$() {
        MODULE$ = this;
    }
}

