/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.JsonParseException;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.FeatureSet;
import io.getunleash.event.UnleashEvent;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.repository.BackupHandler;
import io.getunleash.util.UnleashConfig;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBackupHandlerFile
implements BackupHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureBackupHandlerFile.class);
    private final String backupFile;
    private final EventDispatcher eventDispatcher;

    public FeatureBackupHandlerFile(UnleashConfig config) {
        this.backupFile = config.getBackupFile();
        this.eventDispatcher = new EventDispatcher(config);
    }

    @Override
    public Optional<String> read() {
        Optional<String> optional;
        LOG.info("Unleash will try to load feature toggle states from temporary backup");
        BufferedReader reader = new BufferedReader(new FileReader(this.backupFile));
        try {
            String clientFeatures = reader.lines().collect(Collectors.joining("\n"));
            this.eventDispatcher.dispatch(new FeatureBackupRead(clientFeatures));
            optional = Optional.of(clientFeatures);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                LOG.info(" Unleash could not find the backup-file '" + this.backupFile + "'. \nThis is expected behavior the first time unleash runs in a new environment.");
                return Optional.empty();
            }
            catch (JsonParseException | IOException | IllegalStateException e) {
                this.eventDispatcher.dispatch(new UnleashException("Failed to read backup file: " + this.backupFile, e));
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    @Override
    public void write(String features) {
        try (FileWriter writer = new FileWriter(this.backupFile);){
            writer.write(features);
            this.eventDispatcher.dispatch(new FeatureBackupWritten(features));
        }
        catch (IOException e) {
            this.eventDispatcher.dispatch(new UnleashException("Unleash was unable to backup feature toggles to file: " + this.backupFile, e));
        }
    }

    private static class FeatureBackupRead
    implements UnleashEvent {
        private final String featureCollection;

        private FeatureBackupRead(String featureCollection) {
            this.featureCollection = featureCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.featuresBackupRestored(new FeatureSet(this.featureCollection));
        }
    }

    private static class FeatureBackupWritten
    implements UnleashEvent {
        private final String featureCollection;

        private FeatureBackupWritten(String featureCollection) {
            this.featureCollection = featureCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.featuresBackedUp(new FeatureSet(this.featureCollection));
        }
    }
}

