/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.github.detekt.psi.FilePath;
import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.Compactable;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\nH\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/api/Location;", "Lio/gitlab/arturbosch/detekt/api/Compactable;", "source", "Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "text", "Lio/gitlab/arturbosch/detekt/api/TextLocation;", "filePath", "Lio/github/detekt/psi/FilePath;", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Lio/github/detekt/psi/FilePath;)V", "locationString", "", "file", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Ljava/lang/String;Ljava/lang/String;)V", "(Lio/gitlab/arturbosch/detekt/api/SourceLocation;Lio/gitlab/arturbosch/detekt/api/TextLocation;Ljava/lang/String;Lio/github/detekt/psi/FilePath;)V", "getFile", "()Ljava/lang/String;", "getFilePath", "()Lio/github/detekt/psi/FilePath;", "getSource", "()Lio/gitlab/arturbosch/detekt/api/SourceLocation;", "getText", "()Lio/gitlab/arturbosch/detekt/api/TextLocation;", "compact", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "detekt-api"})
public final class Location
implements Compactable {
    @NotNull
    private final SourceLocation source;
    @NotNull
    private final TextLocation text;
    @NotNull
    private final String file;
    @NotNull
    private final FilePath filePath;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String compact() {
        return "" + this.filePath.getAbsolutePath() + ':' + this.source;
    }

    @NotNull
    public final SourceLocation getSource() {
        return this.source;
    }

    @NotNull
    public final TextLocation getText() {
        return this.text;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Deprecated(message="Consider relative path by passing a [FilePath]")
    @JvmOverloads
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.source = source;
        this.text = text;
        this.file = file;
        this.filePath = filePath;
    }

    public /* synthetic */ Location(SourceLocation sourceLocation, TextLocation textLocation, String string, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(file)");
            filePath = FilePath.Companion.fromAbsolute(path);
        }
        this(sourceLocation, textLocation, string, filePath);
    }

    @Deprecated(message="Consider relative path by passing a [FilePath]")
    @JvmOverloads
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file) {
        this(source, text, file, null, 8, null);
    }

    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this(source, text, ((Object)filePath.getAbsolutePath()).toString(), filePath);
    }

    @Deprecated(message="\n        locationString was removed and won't get passed to the main constructor.\n        Use queries on 'ktElement' instead.\n        ", replaceWith=@ReplaceWith(imports={"io.gitlab.arturbosch.detekt.api.Location"}, expression="Location(source, text, file)"))
    public Location(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String locationString, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locationString, (String)"locationString");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(source, text, file, null, 8, null);
    }

    @Override
    @NotNull
    public String compactWithSignature() {
        return Compactable.DefaultImpls.compactWithSignature(this);
    }

    @NotNull
    public final SourceLocation component1() {
        return this.source;
    }

    @NotNull
    public final TextLocation component2() {
        return this.text;
    }

    @NotNull
    public final String component3() {
        return this.file;
    }

    @NotNull
    public final FilePath component4() {
        return this.filePath;
    }

    @NotNull
    public final Location copy(@NotNull SourceLocation source, @NotNull TextLocation text, @NotNull String file, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new Location(source, text, file, filePath);
    }

    public static /* synthetic */ Location copy$default(Location location, SourceLocation sourceLocation, TextLocation textLocation, String string, FilePath filePath, int n, Object object) {
        if ((n & 1) != 0) {
            sourceLocation = location.source;
        }
        if ((n & 2) != 0) {
            textLocation = location.text;
        }
        if ((n & 4) != 0) {
            string = location.file;
        }
        if ((n & 8) != 0) {
            filePath = location.filePath;
        }
        return location.copy(sourceLocation, textLocation, string, filePath);
    }

    @NotNull
    public String toString() {
        return "Location(source=" + this.source + ", text=" + this.text + ", file=" + this.file + ", filePath=" + this.filePath + ")";
    }

    public int hashCode() {
        SourceLocation sourceLocation = this.source;
        TextLocation textLocation = this.text;
        String string = this.file;
        FilePath filePath = this.filePath;
        return (((sourceLocation != null ? ((Object)sourceLocation).hashCode() : 0) * 31 + (textLocation != null ? ((Object)textLocation).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (filePath != null ? filePath.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Location)) break block3;
                Location location = (Location)object;
                if (!Intrinsics.areEqual((Object)this.source, (Object)location.source) || !Intrinsics.areEqual((Object)this.text, (Object)location.text) || !Intrinsics.areEqual((Object)this.file, (Object)location.file) || !Intrinsics.areEqual((Object)this.filePath, (Object)location.filePath)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/api/Location$Companion;", "", "()V", "from", "Lio/gitlab/arturbosch/detekt/api/Location;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "offset", "", "startLineAndColumn", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumn;", "detekt-api"})
    public static final class Companion {
        @NotNull
        public final Location from(@NotNull PsiElement element, int offset) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiDiagnosticUtils.LineAndColumn start = this.startLineAndColumn(element, offset);
            SourceLocation sourceLocation = new SourceLocation(start.getLine(), start.getColumn());
            TextLocation textLocation = new TextLocation(PsiUtilsKt.getStartOffset((PsiElement)element) + offset, PsiUtilsKt.getEndOffset((PsiElement)element) + offset);
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
            return new Location(sourceLocation, textLocation, KtFilesKt.toFilePath((PsiFile)psiFile));
        }

        public static /* synthetic */ Location from$default(Companion companion, PsiElement psiElement, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.from(psiElement, n);
        }

        @NotNull
        public final PsiDiagnosticUtils.LineAndColumn startLineAndColumn(@NotNull PsiElement element, int offset) {
            PsiDiagnosticUtils.LineAndColumn lineAndColumn;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            try {
                TextRange range = element.getTextRange();
                PsiFile psiFile = element.getContainingFile();
                TextRange textRange = range;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                PsiDiagnosticUtils.LineAndColumn lineAndColumn2 = DiagnosticUtils.getLineAndColumnInPsiFile((PsiFile)psiFile, (TextRange)new TextRange(textRange.getStartOffset() + offset, range.getEndOffset() + offset));
                Intrinsics.checkNotNullExpressionValue((Object)lineAndColumn2, (String)"DiagnosticUtils.getLineA\u2026ange.endOffset + offset))");
                lineAndColumn = lineAndColumn2;
            }
            catch (IndexOutOfBoundsException e) {
                lineAndColumn = new PsiDiagnosticUtils.LineAndColumn(-1, -1, null);
            }
            return lineAndColumn;
        }

        public static /* synthetic */ PsiDiagnosticUtils.LineAndColumn startLineAndColumn$default(Companion companion, PsiElement psiElement, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.startLineAndColumn(psiElement, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

