/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.DetektGenerateConfigTask;
import io.gitlab.arturbosch.detekt.DetektPlugin;
import io.gitlab.arturbosch.detekt.DetektPluginKt;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import io.gitlab.arturbosch.detekt.internal.DetektAndroid;
import io.gitlab.arturbosch.detekt.internal.DetektJvm;
import io.gitlab.arturbosch.detekt.internal.DetektMultiplatform;
import io.gitlab.arturbosch.detekt.internal.DetektPlain;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configurePluginDependencies", "extension", "Lio/gitlab/arturbosch/detekt/extensions/DetektExtension;", "setTaskDefaults", "registerDetektAndroidTasks", "registerDetektJvmTasks", "registerDetektMultiplatformTasks", "registerDetektPlainTask", "registerGenerateConfigTask", "Companion", "detekt-gradle-plugin"})
public final class DetektPlugin
implements Plugin<Project> {
    @NotNull
    public static final String DETEKT_TASK_NAME = "detekt";
    @NotNull
    public static final String BASELINE_TASK_NAME = "detektBaseline";
    @NotNull
    public static final String DETEKT_EXTENSION = "detekt";
    private static final String GENERATE_CONFIG = "detektGenerateConfig";
    @NotNull
    private static final List<String> defaultExcludes;
    @NotNull
    private static final List<String> defaultIncludes;
    @NotNull
    public static final String CONFIG_DIR_NAME = "config/detekt";
    @NotNull
    public static final String CONFIG_FILE = "detekt.yml";
    @NotNull
    public static final String DETEKT_ANDROID_DISABLED_PROPERTY = "detekt.android.disabled";
    @NotNull
    public static final String DETEKT_MULTIPLATFORM_DISABLED_PROPERTY = "detekt.multiplatform.disabled";
    @NotNull
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        DetektExtension extension;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPluginManager().apply(ReportingBasePlugin.class);
        DetektExtension detektExtension = extension = (DetektExtension)((Object)project.getExtensions().create("detekt", DetektExtension.class, new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)detektExtension), (String)"extension");
        detektExtension.setReportsDir(((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).file("detekt"));
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        ProjectLayout projectLayout = project2.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.rootProject.layout");
        File defaultConfigFile = project.file((Object)stringBuilder.append(projectLayout.getProjectDirectory().dir(CONFIG_DIR_NAME)).append("/detekt.yml").toString());
        if (defaultConfigFile.exists()) {
            ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{defaultConfigFile});
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(defaultConfigFile)");
            extension.setConfig(configurableFileCollection);
        }
        this.configurePluginDependencies(project, extension);
        this.setTaskDefaults(project);
        this.registerDetektPlainTask(project, extension);
        this.registerDetektJvmTasks(project, extension);
        if (Intrinsics.areEqual((Object)project.findProperty(DETEKT_ANDROID_DISABLED_PROPERTY), (Object)"true") ^ true) {
            this.registerDetektAndroidTasks(project, extension);
        }
        if (Intrinsics.areEqual((Object)project.findProperty(DETEKT_MULTIPLATFORM_DISABLED_PROPERTY), (Object)"true") ^ true) {
            this.registerDetektMultiplatformTasks(project, extension);
        }
        this.registerGenerateConfigTask(project, extension);
    }

    private final void registerDetektJvmTasks(Project $this$registerDetektJvmTasks, DetektExtension extension) {
        $this$registerDetektJvmTasks.getPlugins().withId("org.jetbrains.kotlin.jvm", (Action)new Action<Plugin<Object>>($this$registerDetektJvmTasks, extension){
            final /* synthetic */ Project $this_registerDetektJvmTasks;
            final /* synthetic */ DetektExtension $extension;

            public final void execute(Plugin<Object> it) {
                new DetektJvm(this.$this_registerDetektJvmTasks).registerTasks(this.$extension);
            }
            {
                this.$this_registerDetektJvmTasks = project;
                this.$extension = detektExtension;
            }
        });
    }

    private final void registerDetektMultiplatformTasks(Project $this$registerDetektMultiplatformTasks, DetektExtension extension) {
        $this$registerDetektMultiplatformTasks.getPlugins().withId("org.jetbrains.kotlin.multiplatform", (Action)new Action<Plugin<Object>>($this$registerDetektMultiplatformTasks, extension){
            final /* synthetic */ Project $this_registerDetektMultiplatformTasks;
            final /* synthetic */ DetektExtension $extension;

            public final void execute(Plugin<Object> it) {
                new DetektMultiplatform(this.$this_registerDetektMultiplatformTasks).registerTasks(this.$extension);
            }
            {
                this.$this_registerDetektMultiplatformTasks = project;
                this.$extension = detektExtension;
            }
        });
    }

    private final void registerDetektAndroidTasks(Project $this$registerDetektAndroidTasks, DetektExtension extension) {
        $this$registerDetektAndroidTasks.getPlugins().withId("kotlin-android", (Action)new Action<Plugin<Object>>($this$registerDetektAndroidTasks, extension){
            final /* synthetic */ Project $this_registerDetektAndroidTasks;
            final /* synthetic */ DetektExtension $extension;

            public final void execute(Plugin<Object> it) {
                new DetektAndroid(this.$this_registerDetektAndroidTasks).registerTasks(this.$extension);
            }
            {
                this.$this_registerDetektAndroidTasks = project;
                this.$extension = detektExtension;
            }
        });
    }

    private final void registerDetektPlainTask(Project $this$registerDetektPlainTask, DetektExtension extension) {
        new DetektPlain($this$registerDetektPlainTask).registerTasks(extension);
    }

    private final void registerGenerateConfigTask(Project $this$registerGenerateConfigTask, DetektExtension extension) {
        $this$registerGenerateConfigTask.getTasks().register(GENERATE_CONFIG, DetektGenerateConfigTask.class, (Action)new Action<DetektGenerateConfigTask>($this$registerGenerateConfigTask, extension){
            final /* synthetic */ Project $this_registerGenerateConfigTask;
            final /* synthetic */ DetektExtension $extension;

            public final void execute(DetektGenerateConfigTask it) {
                it.getConfig().setFrom(new Object[]{this.$this_registerGenerateConfigTask.getProject().provider((Callable)new Callable<ConfigurableFileCollection>(this){
                    final /* synthetic */ registerGenerateConfigTask.1 this$0;

                    public final ConfigurableFileCollection call() {
                        return this.this$0.$extension.getConfig();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })});
            }
            {
                this.$this_registerGenerateConfigTask = project;
                this.$extension = detektExtension;
            }
        });
    }

    private final void configurePluginDependencies(Project project, DetektExtension extension) {
        project.getConfigurations().create("detektPlugins", (Action)configurePluginDependencies.1.INSTANCE);
        project.getConfigurations().create("detekt", (Action)new Action<Configuration>(extension, project){
            final /* synthetic */ DetektExtension $extension;
            final /* synthetic */ Project $project;

            public final void execute(Configuration configuration) {
                Configuration configuration2 = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
                configuration2.setVisible(false);
                configuration.setTransitive(true);
                configuration.setDescription("The detekt dependencies to be used for this project.");
                configuration.defaultDependencies((Action)new Action<DependencySet>(this){
                    final /* synthetic */ configurePluginDependencies.2 this$0;

                    public final void execute(DependencySet dependencySet) {
                        String string = this.this$0.$extension.getToolVersion();
                        if (string == null) {
                            ClassLoader classLoader = DetektPlugin.class.getClassLoader();
                            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"DetektPlugin::class.java.classLoader");
                            string = DetektPluginKt.loadDetektVersion(classLoader);
                        }
                        String version = string;
                        dependencySet.add((Object)this.this$0.$project.getDependencies().create((Object)("io.gitlab.arturbosch.detekt:detekt-cli:" + version)));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$extension = detektExtension;
                this.$project = project;
            }
        });
    }

    private final void setTaskDefaults(Project project) {
        project.getTasks().withType(Detekt.class).configureEach((Action)new Action<Detekt>(project){
            final /* synthetic */ Project $project;

            public final void execute(Detekt it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
                it.getPluginClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detektPlugins"));
            }
            {
                this.$project = project;
            }
        });
        project.getTasks().withType(DetektCreateBaselineTask.class).configureEach((Action)new Action<DetektCreateBaselineTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(DetektCreateBaselineTask it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
                it.getPluginClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detektPlugins"));
            }
            {
                this.$project = project;
            }
        });
        project.getTasks().withType(DetektGenerateConfigTask.class).configureEach((Action)new Action<DetektGenerateConfigTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(DetektGenerateConfigTask it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
            }
            {
                this.$project = project;
            }
        });
    }

    static {
        Companion = new Companion(null);
        defaultExcludes = CollectionsKt.listOf((Object)"build/");
        defaultIncludes = CollectionsKt.listOf((Object[])new String[]{"**/*.kt", "**/*.kts"});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin$Companion;", "", "()V", "BASELINE_TASK_NAME", "", "CONFIG_DIR_NAME", "CONFIG_FILE", "DETEKT_ANDROID_DISABLED_PROPERTY", "DETEKT_EXTENSION", "DETEKT_MULTIPLATFORM_DISABLED_PROPERTY", "DETEKT_TASK_NAME", "GENERATE_CONFIG", "defaultExcludes", "", "getDefaultExcludes$detekt_gradle_plugin", "()Ljava/util/List;", "defaultIncludes", "getDefaultIncludes$detekt_gradle_plugin", "detekt-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final List<String> getDefaultExcludes$detekt_gradle_plugin() {
            return defaultExcludes;
        }

        @NotNull
        public final List<String> getDefaultIncludes$detekt_gradle_plugin() {
            return defaultIncludes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

