/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.internal;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import io.gitlab.arturbosch.detekt.internal.DetektJvm;
import io.gitlab.arturbosch.detekt.internal.FileManglingKt;
import io.gitlab.arturbosch.detekt.internal.SharedTasksKt;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n*\u00020\nH\u0002J\u001c\u0010\f\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/internal/DetektJvm;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "registerTasks", "", "extension", "Lio/gitlab/arturbosch/detekt/extensions/DetektExtension;", "existingFiles", "Lorg/gradle/api/file/FileCollection;", "kotlin.jvm.PlatformType", "registerJvmCreateBaselineTask", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "registerJvmDetektTask", "detekt-gradle-plugin"})
public final class DetektJvm {
    private final Project project;

    public final void registerTasks(@NotNull DetektExtension extension) {
        Intrinsics.checkNotNullParameter((Object)((Object)extension), (String)"extension");
        this.project.afterEvaluate((Action)new Action<Project>(this, extension){
            final /* synthetic */ DetektJvm this$0;
            final /* synthetic */ DetektExtension $extension;

            public final void execute(Project it) {
                Object object = DetektJvm.access$getProject$p(this.this$0).getConvention().getPlugin(JavaPluginConvention.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.convention.getPl\u2026inConvention::class.java)");
                ((JavaPluginConvention)object).getSourceSets().all((Action)new Action<SourceSet>(this){
                    final /* synthetic */ registerTasks.1 this$0;

                    public final void execute(SourceSet sourceSet) {
                        DetektJvm detektJvm = this.this$0.this$0;
                        Project project = DetektJvm.access$getProject$p(this.this$0.this$0);
                        DetektExtension detektExtension = this.this$0.$extension;
                        SourceSet sourceSet2 = sourceSet;
                        Intrinsics.checkNotNullExpressionValue((Object)sourceSet2, (String)"sourceSet");
                        DetektJvm.access$registerJvmDetektTask(detektJvm, project, detektExtension, sourceSet2);
                        DetektJvm.access$registerJvmCreateBaselineTask(this.this$0.this$0, DetektJvm.access$getProject$p(this.this$0.this$0), this.this$0.$extension, sourceSet);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = detektJvm;
                this.$extension = detektExtension;
            }
        });
    }

    private final void registerJvmDetektTask(Project $this$registerJvmDetektTask, DetektExtension extension, SourceSet sourceSet) {
        SourceSet sourceSet2 = sourceSet;
        if (sourceSet2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.HasConvention");
        }
        Convention convention = ((HasConvention)sourceSet2).getConvention();
        Intrinsics.checkNotNullExpressionValue((Object)convention, (String)"(sourceSet as HasConvention).convention");
        Object v = convention.getPlugins().get("kotlin");
        if (!(v instanceof KotlinSourceSet)) {
            v = null;
        }
        KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)v;
        if (kotlinSourceSet == null) {
            throw (Throwable)new GradleException("Kotlin source set not found. Please report on detekt's issue tracker");
        }
        KotlinSourceSet kotlinSourceSet2 = kotlinSourceSet;
        StringBuilder stringBuilder = new StringBuilder().append("detekt");
        String string = sourceSet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
        SharedTasksKt.registerDetektTask($this$registerJvmDetektTask, stringBuilder.append(StringsKt.capitalize((String)string)).toString(), extension, (Function1<? super Detekt, Unit>)((Function1)new Function1<Detekt, Unit>(this, $this$registerJvmDetektTask, kotlinSourceSet2, sourceSet, extension){
            final /* synthetic */ DetektJvm this$0;
            final /* synthetic */ Project $this_registerJvmDetektTask;
            final /* synthetic */ KotlinSourceSet $kotlinSourceSet;
            final /* synthetic */ SourceSet $sourceSet;
            final /* synthetic */ DetektExtension $extension;

            public final void invoke(@NotNull Detekt $this$registerDetektTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$registerDetektTask), (String)"$receiver");
                $this$registerDetektTask.setSource(this.$kotlinSourceSet.getKotlin().getFiles());
                ConfigurableFileCollection configurableFileCollection = $this$registerDetektTask.getClasspath();
                Object[] objectArray = new Object[2];
                FileCollection fileCollection = this.$sourceSet.getCompileClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceSet.compileClasspath");
                objectArray[0] = DetektJvm.access$existingFiles(this.this$0, fileCollection);
                SourceSetOutput sourceSetOutput = this.$sourceSet.getOutput();
                Intrinsics.checkNotNullExpressionValue((Object)sourceSetOutput, (String)"sourceSet.output");
                FileCollection fileCollection2 = sourceSetOutput.getClassesDirs();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"sourceSet.output.classesDirs");
                objectArray[1] = DetektJvm.access$existingFiles(this.this$0, fileCollection2);
                configurableFileCollection.setFrom(objectArray);
                File file = this.$extension.getBaseline();
                if (file != null) {
                    String string = this.$sourceSet.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
                    if ((file = FileManglingKt.existingVariantOrBaseFile(file, string)) != null) {
                        File file2 = file;
                        boolean bl = false;
                        boolean bl2 = false;
                        File baselineFile = file2;
                        boolean bl3 = false;
                        $this$registerDetektTask.getBaseline().set(this.$this_registerJvmDetektTask.getLayout().file($this$registerDetektTask.getProject().provider((Callable)new Callable<File>(baselineFile){
                            final /* synthetic */ File $baselineFile;

                            public final File call() {
                                return this.$baselineFile;
                            }
                            {
                                this.$baselineFile = file;
                            }
                        })));
                    }
                }
                $this$registerDetektTask.setReports(this.$extension.getReports());
                SharedTasksKt.setDefaultIfUnset($this$registerDetektTask.getReports().getXml(), new File(this.$extension.getReportsDir(), this.$sourceSet.getName() + ".xml"));
                SharedTasksKt.setDefaultIfUnset($this$registerDetektTask.getReports().getHtml(), new File(this.$extension.getReportsDir(), this.$sourceSet.getName() + ".html"));
                SharedTasksKt.setDefaultIfUnset($this$registerDetektTask.getReports().getTxt(), new File(this.$extension.getReportsDir(), this.$sourceSet.getName() + ".txt"));
                SharedTasksKt.setDefaultIfUnset($this$registerDetektTask.getReports().getSarif(), new File(this.$extension.getReportsDir(), this.$sourceSet.getName() + ".sarif"));
                $this$registerDetektTask.setDescription("EXPERIMENTAL: Run detekt analysis for " + this.$sourceSet.getName() + " classes with type resolution");
            }
            {
                this.this$0 = detektJvm;
                this.$this_registerJvmDetektTask = project;
                this.$kotlinSourceSet = kotlinSourceSet;
                this.$sourceSet = sourceSet;
                this.$extension = detektExtension;
                super(1);
            }
        }));
    }

    private final void registerJvmCreateBaselineTask(Project $this$registerJvmCreateBaselineTask, DetektExtension extension, SourceSet sourceSet) {
        SourceSet sourceSet2 = sourceSet;
        if (sourceSet2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.HasConvention");
        }
        Convention convention = ((HasConvention)sourceSet2).getConvention();
        Intrinsics.checkNotNullExpressionValue((Object)convention, (String)"(sourceSet as HasConvention).convention");
        Object v = convention.getPlugins().get("kotlin");
        if (!(v instanceof KotlinSourceSet)) {
            v = null;
        }
        KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)v;
        if (kotlinSourceSet == null) {
            throw (Throwable)new GradleException("Kotlin source set not found. Please report on detekt's issue tracker");
        }
        KotlinSourceSet kotlinSourceSet2 = kotlinSourceSet;
        StringBuilder stringBuilder = new StringBuilder().append("detektBaseline");
        String string = sourceSet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
        SharedTasksKt.registerCreateBaselineTask($this$registerJvmCreateBaselineTask, stringBuilder.append(StringsKt.capitalize((String)string)).toString(), extension, (Function1<? super DetektCreateBaselineTask, Unit>)((Function1)new Function1<DetektCreateBaselineTask, Unit>(this, kotlinSourceSet2, sourceSet, extension){
            final /* synthetic */ DetektJvm this$0;
            final /* synthetic */ KotlinSourceSet $kotlinSourceSet;
            final /* synthetic */ SourceSet $sourceSet;
            final /* synthetic */ DetektExtension $extension;

            public final void invoke(@NotNull DetektCreateBaselineTask $this$registerCreateBaselineTask) {
                File file;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$registerCreateBaselineTask), (String)"$receiver");
                $this$registerCreateBaselineTask.setSource(this.$kotlinSourceSet.getKotlin().getFiles());
                ConfigurableFileCollection configurableFileCollection = $this$registerCreateBaselineTask.getClasspath();
                Object[] objectArray = new Object[2];
                FileCollection fileCollection = this.$sourceSet.getCompileClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceSet.compileClasspath");
                objectArray[0] = DetektJvm.access$existingFiles(this.this$0, fileCollection);
                SourceSetOutput sourceSetOutput = this.$sourceSet.getOutput();
                Intrinsics.checkNotNullExpressionValue((Object)sourceSetOutput, (String)"sourceSet.output");
                FileCollection fileCollection2 = sourceSetOutput.getClassesDirs();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"sourceSet.output.classesDirs");
                objectArray[1] = DetektJvm.access$existingFiles(this.this$0, fileCollection2);
                configurableFileCollection.setFrom(objectArray);
                File file2 = this.$extension.getBaseline();
                if (file2 != null) {
                    String string = this.$sourceSet.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
                    file = FileManglingKt.addVariantName$default(file2, string, null, 2, null);
                } else {
                    file = null;
                }
                File variantBaselineFile = file;
                RegularFileProperty regularFileProperty = $this$registerCreateBaselineTask.getBaseline();
                Project project = $this$registerCreateBaselineTask.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                regularFileProperty.set(project.getLayout().file($this$registerCreateBaselineTask.getProject().provider((Callable)new Callable<File>(variantBaselineFile){
                    final /* synthetic */ File $variantBaselineFile;

                    public final File call() {
                        return this.$variantBaselineFile;
                    }
                    {
                        this.$variantBaselineFile = file;
                    }
                })));
                $this$registerCreateBaselineTask.setDescription("EXPERIMENTAL: Creates detekt baseline for " + this.$sourceSet.getName() + " classes with type resolution");
            }
            {
                this.this$0 = detektJvm;
                this.$kotlinSourceSet = kotlinSourceSet;
                this.$sourceSet = sourceSet;
                this.$extension = detektExtension;
                super(1);
            }
        }));
    }

    private final FileCollection existingFiles(FileCollection $this$existingFiles) {
        return $this$existingFiles.filter((Spec)existingFiles.1.INSTANCE);
    }

    public DetektJvm(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Project access$getProject$p(DetektJvm $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$registerJvmDetektTask(DetektJvm $this, Project $this$access_u24registerJvmDetektTask, DetektExtension extension, SourceSet sourceSet) {
        $this.registerJvmDetektTask($this$access_u24registerJvmDetektTask, extension, sourceSet);
    }

    public static final /* synthetic */ void access$registerJvmCreateBaselineTask(DetektJvm $this, Project $this$access_u24registerJvmCreateBaselineTask, DetektExtension extension, SourceSet sourceSet) {
        $this.registerJvmCreateBaselineTask($this$access_u24registerJvmCreateBaselineTask, extension, sourceSet);
    }

    public static final /* synthetic */ FileCollection access$existingFiles(DetektJvm $this, FileCollection $this$access_u24existingFiles) {
        return $this.existingFiles($this$access_u24existingFiles);
    }
}

