/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.invoke.CliArgument;
import io.gitlab.arturbosch.detekt.invoke.ConfigArgument;
import io.gitlab.arturbosch.detekt.invoke.DetektInvoker;
import io.gitlab.arturbosch.detekt.invoke.DetektWorkAction;
import io.gitlab.arturbosch.detekt.invoke.DetektWorkParameters;
import io.gitlab.arturbosch.detekt.invoke.GenerateConfigArgument;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001%B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010#\u001a\u00020$H\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00020\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011R\u0014\u0010!\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/DetektGenerateConfigTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/provider/ProviderFactory;)V", "arguments", "", "", "getArguments$detekt_gradle_plugin", "()Ljava/util/List;", "config", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConfig", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "configFile", "Lorg/gradle/api/file/RegularFileProperty;", "getConfigFile", "()Lorg/gradle/api/file/RegularFileProperty;", "configurationToUse", "Ljava/io/File;", "getConfigurationToUse$annotations", "()V", "getConfigurationToUse", "()Ljava/io/File;", "defaultConfigPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "detektClasspath", "getDetektClasspath", "pluginClasspath", "getPluginClasspath", "generateConfig", "", "SingleExecutionBuildService", "detekt-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDetektGenerateConfigTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetektGenerateConfigTask.kt\nio/gitlab/arturbosch/detekt/DetektGenerateConfigTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1360#2:104\n1446#2,5:105\n*S KotlinDebug\n*F\n+ 1 DetektGenerateConfigTask.kt\nio/gitlab/arturbosch/detekt/DetektGenerateConfigTask\n*L\n68#1:104\n68#1:105,5\n*E\n"})
public abstract class DetektGenerateConfigTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final ProviderFactory providers;
    @NotNull
    private final RegularFileProperty configFile;
    private final Path defaultConfigPath;

    @Inject
    public DetektGenerateConfigTask(@NotNull ObjectFactory objects, @NotNull WorkerExecutor workerExecutor, @NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.workerExecutor = workerExecutor;
        this.providers = providers;
        this.setDescription("Generate a detekt configuration file inside your project.");
        this.setGroup("verification");
        RegularFileProperty regularFileProperty = objects.fileProperty().convention(() -> DetektGenerateConfigTask.configFile$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"convention(...)");
        this.configFile = regularFileProperty;
        this.defaultConfigPath = this.getProject().getRootDir().toPath().resolve("config/detekt").resolve("detekt.yml");
    }

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getDetektClasspath();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getPluginClasspath();

    @OutputFile
    @NotNull
    public final RegularFileProperty getConfigFile() {
        return this.configFile;
    }

    @Internal
    @Deprecated(message="Replaced with configFile property")
    @NotNull
    public abstract ConfigurableFileCollection getConfig();

    private final File getConfigurationToUse() {
        File file;
        if (this.getConfig().isEmpty()) {
            File file2 = this.defaultConfigPath.toFile();
            Intrinsics.checkNotNull((Object)file2);
            file = file2;
        } else {
            Object object = CollectionsKt.last((Iterable)((Iterable)this.getConfig()));
            Intrinsics.checkNotNull((Object)object);
            file = (File)object;
        }
        return file;
    }

    private static /* synthetic */ void getConfigurationToUse$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Internal
    @NotNull
    public final List<String> getArguments$detekt_gradle_plugin() {
        void $this$flatMapTo$iv$iv;
        Object[] objectArray = new CliArgument[2];
        objectArray[0] = GenerateConfigArgument.INSTANCE;
        Object object = this.configFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        objectArray[1] = new ConfigArgument((RegularFile)object);
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CliArgument p0 = (CliArgument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.toArgument();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @TaskAction
    public final void generateConfig() {
        if (((RegularFile)this.configFile.get()).getAsFile().exists()) {
            this.getLogger().warn("Skipping config file generation; file already exists at " + ((RegularFile)this.configFile.get()).getAsFile());
            return;
        }
        Files.createDirectories(((RegularFile)this.configFile.get()).getAsFile().getParentFile().toPath(), new FileAttribute[0]);
        if (Intrinsics.areEqual((Object)this.providers.gradleProperty("detekt.use.worker.api").getOrElse((Object)"false"), (Object)"true")) {
            this.getLogger().info("Executing " + this.getName() + " using Worker API");
            WorkQueue workQueue2 = this.workerExecutor.processIsolation(arg_0 -> DetektGenerateConfigTask.generateConfig$lambda$1((Function1)new Function1<ProcessWorkerSpec, Unit>(this){
                final /* synthetic */ DetektGenerateConfigTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ProcessWorkerSpec workerSpec) {
                    Object[] objectArray = new Object[]{this.this$0.getDetektClasspath()};
                    workerSpec.getClasspath().from(objectArray);
                    objectArray = new Object[]{this.this$0.getPluginClasspath()};
                    workerSpec.getClasspath().from(objectArray);
                }
            }, arg_0));
            workQueue2.submit(DetektWorkAction.class, arg_0 -> DetektGenerateConfigTask.generateConfig$lambda$2((Function1)new Function1<DetektWorkParameters, Unit>(this){
                final /* synthetic */ DetektGenerateConfigTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(DetektWorkParameters workParameters) {
                    workParameters.getArguments().set((Iterable)this.this$0.getArguments$detekt_gradle_plugin());
                    workParameters.getTaskName().set((Object)this.this$0.getName());
                }
            }, arg_0));
        } else {
            this.getLogger().info("Executing " + this.getName() + " using DetektInvoker");
            DetektInvoker detektInvoker = DetektInvoker.Companion.create$default(DetektInvoker.Companion, false, 1, null);
            List<String> list = this.getArguments$detekt_gradle_plugin();
            FileCollection fileCollection = this.getDetektClasspath().plus((FileCollection)this.getPluginClasspath());
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"plus(...)");
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            DetektInvoker.DefaultImpls.invokeCli$default(detektInvoker, list, fileCollection, string, false, 8, null);
        }
    }

    private static final File configFile$lambda$0(DetektGenerateConfigTask this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getConfigurationToUse();
    }

    private static final void generateConfig$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void generateConfig$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/gitlab/arturbosch/detekt/DetektGenerateConfigTask$SingleExecutionBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "detekt-gradle-plugin"})
    public static abstract class SingleExecutionBuildService
    implements BuildService<BuildServiceParameters.None> {
    }
}

