/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.gradle;

import io.github.detekt.gradle.DetektKotlinCompilerPlugin;
import io.github.detekt.gradle.DetektKotlinCompilerPluginKt;
import io.github.detekt.gradle.extensions.DetektReport;
import io.github.detekt.gradle.extensions.KotlinCompileTaskDetektExtension;
import io.gitlab.arturbosch.detekt.DetektPlugin;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilerPluginSupportPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a8\u0006\u0013"}, d2={"Lio/github/detekt/gradle/DetektKotlinCompilerPlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilerPluginSupportPlugin;", "()V", "apply", "", "target", "Lorg/gradle/api/Project;", "applyToCompilation", "Lorg/gradle/api/provider/Provider;", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getCompilerPluginId", "", "getPluginArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "isApplicable", "", "detekt-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDetektKotlinCompilerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetektKotlinCompilerPlugin.kt\nio/github/detekt/gradle/DetektKotlinCompilerPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1#2:181\n1#2:192\n1603#3,9:182\n1855#3:191\n1856#3:193\n1612#3:194\n*S KotlinDebug\n*F\n+ 1 DetektKotlinCompilerPlugin.kt\nio/github/detekt/gradle/DetektKotlinCompilerPlugin\n*L\n129#1:192\n129#1:182,9\n129#1:191\n129#1:193\n129#1:194\n*E\n"})
public final class DetektKotlinCompilerPlugin
implements KotlinCompilerPluginSupportPlugin {
    public void apply(@NotNull Project target) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.getPluginManager().apply(ReportingBasePlugin.class);
        DetektExtension detektExtension = (DetektExtension)((Object)target.getExtensions().findByType(DetektExtension.class));
        if (detektExtension == null) {
            detektExtension = (DetektExtension)((Object)target.getExtensions().create("detekt", DetektExtension.class, new Object[0]));
        }
        DetektExtension extension = detektExtension;
        extension.setReportsDir(((ReportingExtension)target.getExtensions().getByType(ReportingExtension.class)).file("detekt"));
        File defaultConfigFile = target.file((Object)(target.getRootProject().getLayout().getProjectDirectory().dir("config/detekt") + "/detekt.yml"));
        if (defaultConfigFile.exists()) {
            objectArray = new Object[]{defaultConfigFile};
            extension.getConfig().setFrom((Iterable)target.files(objectArray));
        }
        objectArray = target.getConfigurations().maybeCreate("detektPlugins");
        Configuration $this$apply_u24lambda_u240 = (Configuration)objectArray;
        boolean bl = false;
        $this$apply_u24lambda_u240.setVisible(false);
        $this$apply_u24lambda_u240.setTransitive(true);
        $this$apply_u24lambda_u240.setDescription("The detektPlugins libraries to be used for this project.");
        target.getTasks().withType(KotlinCompile.class).configureEach(arg_0 -> DetektKotlinCompilerPlugin.apply$lambda$1((Function1)new Function1<KotlinCompile, Unit>(target, extension){
            final /* synthetic */ Project $target;
            final /* synthetic */ DetektExtension $extension;
            {
                this.$target = $target;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(KotlinCompile task) {
                Object object = new Object[]{this.$target};
                object = task.getExtensions().create("detekt", KotlinCompileTaskDetektExtension.class, object);
                DetektExtension detektExtension = this.$extension;
                Project project = this.$target;
                KotlinCompileTaskDetektExtension $this$invoke_u24lambda_u246 = (KotlinCompileTaskDetektExtension)object;
                boolean bl = false;
                $this$invoke_u24lambda_u246.isEnabled().convention((Provider)detektExtension.getEnableCompilerPlugin());
                $this$invoke_u24lambda_u246.getBaseline().convention(project.getLayout().file(project.provider(() -> apply.2.invoke$lambda$6$lambda$0(detektExtension))));
                $this$invoke_u24lambda_u246.getDebug().convention(project.provider(() -> apply.2.invoke$lambda$6$lambda$1(detektExtension)));
                $this$invoke_u24lambda_u246.getBuildUponDefaultConfig().convention(project.provider(() -> apply.2.invoke$lambda$6$lambda$2(detektExtension)));
                $this$invoke_u24lambda_u246.getAllRules().convention(project.provider(() -> apply.2.invoke$lambda$6$lambda$3(detektExtension)));
                $this$invoke_u24lambda_u246.getDisableDefaultRuleSets().convention(project.provider(() -> apply.2.invoke$lambda$6$lambda$4(detektExtension)));
                $this$invoke_u24lambda_u246.getParallel().convention(project.provider(() -> apply.2.invoke$lambda$6$lambda$5(detektExtension)));
                Object[] objectArray = new Object[]{detektExtension.getConfig()};
                $this$invoke_u24lambda_u246.getConfig().from(objectArray);
                $this$invoke_u24lambda_u246.getExcludes().convention((Iterable)DetektPlugin.Companion.getDefaultExcludes$detekt_gradle_plugin());
            }

            private static final File invoke$lambda$6$lambda$0(DetektExtension $extension) {
                return $extension.getBaseline();
            }

            private static final Boolean invoke$lambda$6$lambda$1(DetektExtension $extension) {
                return $extension.getDebug();
            }

            private static final Boolean invoke$lambda$6$lambda$2(DetektExtension $extension) {
                return $extension.getBuildUponDefaultConfig();
            }

            private static final Boolean invoke$lambda$6$lambda$3(DetektExtension $extension) {
                return $extension.getAllRules();
            }

            private static final Boolean invoke$lambda$6$lambda$4(DetektExtension $extension) {
                return $extension.getDisableDefaultRuleSets();
            }

            private static final Boolean invoke$lambda$6$lambda$5(DetektExtension $extension) {
                return $extension.getParallel();
            }
        }, arg_0));
    }

    @NotNull
    public Provider<List<SubpluginOption>> applyToCompilation(@NotNull KotlinCompilation<?> kotlinCompilation) {
        ListProperty listProperty;
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Project project = kotlinCompilation.getTarget().getProject();
        DetektExtension projectExtension = (DetektExtension)((Object)project.getExtensions().getByType(DetektExtension.class));
        KotlinCompileTaskDetektExtension taskExtension = (KotlinCompileTaskDetektExtension)kotlinCompilation.getCompileKotlinTask().getExtensions().getByType(KotlinCompileTaskDetektExtension.class);
        Configuration[] configurationArray = new Configuration[]{project.getConfigurations().getAt("detektPlugins")};
        project.getConfigurations().getByName("kotlinCompilerPluginClasspath").extendsFrom(configurationArray);
        ListProperty $this$applyToCompilation_u24lambda_u243 = listProperty = project.getObjects().listProperty(SubpluginOption.class);
        boolean bl = false;
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("debug", String.valueOf(taskExtension.getDebug().get())));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("configDigest", DetektKotlinCompilerPluginKt.toDigest(taskExtension.getConfig())));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("isEnabled", String.valueOf(taskExtension.isEnabled().getOrElse((Object)false))));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("useDefaultConfig", String.valueOf(taskExtension.getBuildUponDefaultConfig().get())));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("allRules", String.valueOf(taskExtension.getAllRules().get())));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("disableDefaultRuleSets", String.valueOf(taskExtension.getDisableDefaultRuleSets().get())));
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("parallel", String.valueOf(taskExtension.getParallel().get())));
        String string = project.getRootDir().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("rootDir", string));
        Object object = taskExtension.getExcludes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$applyToCompilation_u24lambda_u243.add((Object)new SubpluginOption("excludes", DetektKotlinCompilerPluginKt.access$encodeToBase64((Set)object)));
        taskExtension.getReports().all(arg_0 -> DetektKotlinCompilerPlugin.applyToCompilation$lambda$3$lambda$2((Function1)new Function1<DetektReport, Unit>(project, (ListProperty<SubpluginOption>)$this$applyToCompilation_u24lambda_u243, projectExtension, kotlinCompilation){
            final /* synthetic */ Project $project;
            final /* synthetic */ ListProperty<SubpluginOption> $this_apply;
            final /* synthetic */ DetektExtension $projectExtension;
            final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
            {
                this.$project = $project;
                this.$this_apply = $receiver;
                this.$projectExtension = $projectExtension;
                this.$kotlinCompilation = $kotlinCompilation;
                super(1);
            }

            public final void invoke(DetektReport report) {
                report.getEnabled().convention((Object)true);
                report.getDestination().convention(this.$project.getLayout().getProjectDirectory().file(this.$project.getProviders().provider(() -> applyToCompilation.options.1.1.invoke$lambda$0(this.$projectExtension, this.$kotlinCompilation, report))));
                Object object = report.getEnabled().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                if (((Boolean)object).booleanValue()) {
                    this.$this_apply.add((Object)new SubpluginOption("report", report.getName() + ':' + ((File)report.getDestination().getAsFile().get()).getAbsolutePath()));
                }
            }

            private static final String invoke$lambda$0(DetektExtension $projectExtension, KotlinCompilation $kotlinCompilation, DetektReport $report) {
                Intrinsics.checkNotNullParameter((Object)$kotlinCompilation, (String)"$kotlinCompilation");
                return new File($projectExtension.getReportsDir(), $kotlinCompilation.getName() + '.' + $report.getName()).getAbsolutePath();
            }
        }, arg_0));
        ListProperty options2 = listProperty;
        RegularFile regularFile = (RegularFile)taskExtension.getBaseline().getOrNull();
        if (regularFile != null) {
            RegularFile it = regularFile;
            boolean bl2 = false;
            options2.add((Object)new SubpluginOption("baseline", it.toString()));
        }
        if (CollectionsKt.any((Iterable)((Iterable)taskExtension.getConfig()))) {
            options2.add((Object)new SubpluginOption("config", CollectionsKt.joinToString$default((Iterable)((Iterable)taskExtension.getConfig()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        Intrinsics.checkNotNull((Object)options2);
        return (Provider)options2;
    }

    @NotNull
    public String getCompilerPluginId() {
        return "detekt-compiler-plugin";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SubpluginArtifact getPluginArtifact() {
        void $this$mapNotNullTo$iv$iv;
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("detekt-versions.properties");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$mapNotNull$iv = arrayList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            URLConnection uRLConnection;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            URL versions = (URL)element$iv$iv;
            boolean bl2 = false;
            Properties $this$getPluginArtifact_u24lambda_u247_u24lambda_u246 = new Properties();
            boolean bl3 = false;
            URLConnection $this$getPluginArtifact_u24lambda_u247_u24lambda_u246_u24lambda_u245 = uRLConnection = versions.openConnection();
            boolean bl4 = false;
            $this$getPluginArtifact_u24lambda_u247_u24lambda_u246_u24lambda_u245.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            $this$getPluginArtifact_u24lambda_u247_u24lambda_u246.load(inputStream);
            if ($this$getPluginArtifact_u24lambda_u247_u24lambda_u246.getProperty("detektCompilerPluginVersion") == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List distinctVersions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        String string = (String)CollectionsKt.singleOrNull((List)distinctVersions);
        if (string == null) {
            throw new IllegalStateException(("You're importing two detekt compiler plugins which have different versions. (" + CollectionsKt.joinToString$default((Iterable)distinctVersions, null, null, null, (int)0, null, null, (int)63, null) + ") Make sure to align the versions.").toString());
        }
        String version = string;
        return new SubpluginArtifact("io.github.detekt", "detekt-compiler-plugin", version);
    }

    public boolean isApplicable(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Object[] objectArray = new KotlinPlatformType[]{KotlinPlatformType.jvm, KotlinPlatformType.androidJvm};
        return SetsKt.setOf((Object[])objectArray).contains(kotlinCompilation.getPlatformType());
    }

    @Nullable
    public SubpluginArtifact getPluginArtifactForNative() {
        return KotlinCompilerPluginSupportPlugin.DefaultImpls.getPluginArtifactForNative((KotlinCompilerPluginSupportPlugin)this);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void applyToCompilation$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

