/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.gradle.extensions;

import io.github.detekt.gradle.extensions.DetektReport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020$J\u0006\u0010(\u001a\u00020$J\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020$R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\tR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lio/github/detekt/gradle/extensions/KotlinCompileTaskDetektExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "allRules", "Lorg/gradle/api/provider/Property;", "", "getAllRules", "()Lorg/gradle/api/provider/Property;", "baseline", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseline", "()Lorg/gradle/api/file/RegularFileProperty;", "buildUponDefaultConfig", "getBuildUponDefaultConfig", "config", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConfig", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "debug", "getDebug", "disableDefaultRuleSets", "getDisableDefaultRuleSets", "excludes", "Lorg/gradle/api/provider/SetProperty;", "", "getExcludes", "()Lorg/gradle/api/provider/SetProperty;", "isEnabled", "objects", "Lorg/gradle/api/model/ObjectFactory;", "parallel", "getParallel", "reports", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lio/github/detekt/gradle/extensions/DetektReport;", "getReports", "()Lorg/gradle/api/NamedDomainObjectContainer;", "getHtml", "getSarif", "getTxt", "getXml", "detekt-gradle-plugin"})
public class KotlinCompileTaskDetektExtension {
    @NotNull
    private final NamedDomainObjectContainer<DetektReport> reports;
    @NotNull
    private final ObjectFactory objects;
    @NotNull
    private final Property<Boolean> isEnabled;
    @NotNull
    private final Property<Boolean> debug;
    @NotNull
    private final Property<Boolean> buildUponDefaultConfig;
    @NotNull
    private final Property<Boolean> allRules;
    @NotNull
    private final Property<Boolean> disableDefaultRuleSets;
    @NotNull
    private final Property<Boolean> parallel;
    @NotNull
    private final RegularFileProperty baseline;
    @NotNull
    private final ConfigurableFileCollection config;
    @NotNull
    private final SetProperty<String> excludes;

    public KotlinCompileTaskDetektExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NamedDomainObjectContainer namedDomainObjectContainer = project.container(DetektReport.class);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"container(...)");
        this.reports = namedDomainObjectContainer;
        this.reports.create("xml");
        this.reports.create("txt");
        this.reports.create("html");
        this.reports.create("sarif");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        this.objects = objectFactory;
        Property property = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.isEnabled = property;
        Property property2 = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.debug = property2;
        Property property3 = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(...)");
        this.buildUponDefaultConfig = property3;
        Property property4 = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(...)");
        this.allRules = property4;
        Property property5 = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(...)");
        this.disableDefaultRuleSets = property5;
        Property property6 = this.objects.property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(...)");
        this.parallel = property6;
        RegularFileProperty regularFileProperty = this.objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.baseline = regularFileProperty;
        ConfigurableFileCollection configurableFileCollection = this.objects.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.config = configurableFileCollection;
        SetProperty setProperty = this.objects.setProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"setProperty(...)");
        this.excludes = setProperty;
    }

    @NotNull
    public final NamedDomainObjectContainer<DetektReport> getReports() {
        return this.reports;
    }

    @NotNull
    public final Property<Boolean> isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public final Property<Boolean> getDebug() {
        return this.debug;
    }

    @NotNull
    public final Property<Boolean> getBuildUponDefaultConfig() {
        return this.buildUponDefaultConfig;
    }

    @NotNull
    public final Property<Boolean> getAllRules() {
        return this.allRules;
    }

    @NotNull
    public final Property<Boolean> getDisableDefaultRuleSets() {
        return this.disableDefaultRuleSets;
    }

    @NotNull
    public final Property<Boolean> getParallel() {
        return this.parallel;
    }

    @NotNull
    public final RegularFileProperty getBaseline() {
        return this.baseline;
    }

    @NotNull
    public final ConfigurableFileCollection getConfig() {
        return this.config;
    }

    @NotNull
    public final SetProperty<String> getExcludes() {
        return this.excludes;
    }

    @NotNull
    public final DetektReport getXml() {
        Object object = this.reports.getByName("xml");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByName(...)");
        return (DetektReport)object;
    }

    @NotNull
    public final DetektReport getHtml() {
        Object object = this.reports.getByName("html");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByName(...)");
        return (DetektReport)object;
    }

    @NotNull
    public final DetektReport getTxt() {
        Object object = this.reports.getByName("txt");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByName(...)");
        return (DetektReport)object;
    }

    @NotNull
    public final DetektReport getSarif() {
        Object object = this.reports.getByName("sarif");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByName(...)");
        return (DetektReport)object;
    }
}

