/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.DetektGenerateConfigTask;
import io.gitlab.arturbosch.detekt.DetektPlugin;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import io.gitlab.arturbosch.detekt.internal.DetektAndroid;
import io.gitlab.arturbosch.detekt.internal.DetektJvm;
import io.gitlab.arturbosch.detekt.internal.DetektMultiplatform;
import io.gitlab.arturbosch.detekt.internal.DetektPlain;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configurePluginDependencies", "extension", "Lio/gitlab/arturbosch/detekt/extensions/DetektExtension;", "setTaskDefaults", "registerDetektAndroidTasks", "registerDetektJvmTasks", "registerDetektMultiplatformTasks", "registerDetektPlainTask", "registerGenerateConfigTask", "Companion", "detekt-gradle-plugin"})
public final class DetektPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DETEKT_TASK_NAME = "detekt";
    @NotNull
    public static final String BASELINE_TASK_NAME = "detektBaseline";
    @NotNull
    public static final String DETEKT_EXTENSION = "detekt";
    @NotNull
    private static final String GENERATE_CONFIG = "detektGenerateConfig";
    @NotNull
    private static final List<String> defaultExcludes = CollectionsKt.listOf((Object)"build/");
    @NotNull
    private static final List<String> defaultIncludes;
    @NotNull
    public static final String CONFIG_DIR_NAME = "config/detekt";
    @NotNull
    public static final String CONFIG_FILE = "detekt.yml";
    @NotNull
    public static final String DETEKT_ANDROID_DISABLED_PROPERTY = "detekt.android.disabled";
    @NotNull
    public static final String DETEKT_MULTIPLATFORM_DISABLED_PROPERTY = "detekt.multiplatform.disabled";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPluginManager().apply(ReportingBasePlugin.class);
        DetektExtension detektExtension = (DetektExtension)((Object)project.getExtensions().findByType(DetektExtension.class));
        if (detektExtension == null) {
            detektExtension = (DetektExtension)((Object)project.getExtensions().create("detekt", DetektExtension.class, new Object[0]));
        }
        DetektExtension extension = detektExtension;
        extension.setReportsDir(((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).file("detekt"));
        File defaultConfigFile = project.file((Object)(project.getRootProject().getLayout().getProjectDirectory().dir(CONFIG_DIR_NAME) + "/detekt.yml"));
        if (defaultConfigFile.exists()) {
            Object[] objectArray = new Object[]{defaultConfigFile};
            extension.getConfig().setFrom((Iterable)project.files(objectArray));
        }
        Intrinsics.checkNotNull((Object)((Object)extension));
        this.configurePluginDependencies(project, extension);
        this.setTaskDefaults(project);
        this.registerDetektPlainTask(project, extension);
        this.registerDetektJvmTasks(project, extension);
        if (!Intrinsics.areEqual((Object)project.findProperty(DETEKT_ANDROID_DISABLED_PROPERTY), (Object)"true")) {
            this.registerDetektAndroidTasks(project, extension);
        }
        if (!Intrinsics.areEqual((Object)project.findProperty(DETEKT_MULTIPLATFORM_DISABLED_PROPERTY), (Object)"true")) {
            this.registerDetektMultiplatformTasks(project, extension);
        }
        this.registerGenerateConfigTask(project, extension);
    }

    private final void registerDetektJvmTasks(Project $this$registerDetektJvmTasks, DetektExtension extension) {
        $this$registerDetektJvmTasks.getPlugins().withId("org.jetbrains.kotlin.jvm", arg_0 -> DetektPlugin.registerDetektJvmTasks$lambda$0((Function1)new Function1<Plugin<?>, Unit>($this$registerDetektJvmTasks, extension){
            final /* synthetic */ Project $this_registerDetektJvmTasks;
            final /* synthetic */ DetektExtension $extension;
            {
                this.$this_registerDetektJvmTasks = $receiver;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                new DetektJvm(this.$this_registerDetektJvmTasks).registerTasks(this.$extension);
            }
        }, arg_0));
    }

    private final void registerDetektMultiplatformTasks(Project $this$registerDetektMultiplatformTasks, DetektExtension extension) {
        $this$registerDetektMultiplatformTasks.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> DetektPlugin.registerDetektMultiplatformTasks$lambda$1((Function1)new Function1<Plugin<?>, Unit>($this$registerDetektMultiplatformTasks, extension){
            final /* synthetic */ Project $this_registerDetektMultiplatformTasks;
            final /* synthetic */ DetektExtension $extension;
            {
                this.$this_registerDetektMultiplatformTasks = $receiver;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                new DetektMultiplatform(this.$this_registerDetektMultiplatformTasks).registerTasks(this.$extension);
            }
        }, arg_0));
    }

    private final void registerDetektAndroidTasks(Project $this$registerDetektAndroidTasks, DetektExtension extension) {
        $this$registerDetektAndroidTasks.getPlugins().withId("kotlin-android", arg_0 -> DetektPlugin.registerDetektAndroidTasks$lambda$2((Function1)new Function1<Plugin<?>, Unit>($this$registerDetektAndroidTasks, extension){
            final /* synthetic */ Project $this_registerDetektAndroidTasks;
            final /* synthetic */ DetektExtension $extension;
            {
                this.$this_registerDetektAndroidTasks = $receiver;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                new DetektAndroid(this.$this_registerDetektAndroidTasks).registerTasks(this.$extension);
            }
        }, arg_0));
    }

    private final void registerDetektPlainTask(Project $this$registerDetektPlainTask, DetektExtension extension) {
        new DetektPlain($this$registerDetektPlainTask).registerTasks(extension);
    }

    private final void registerGenerateConfigTask(Project $this$registerGenerateConfigTask, DetektExtension extension) {
        Provider detektGenerateConfigSingleExecution2 = $this$registerGenerateConfigTask.getProject().getGradle().getSharedServices().registerIfAbsent("DetektGenerateConfigSingleExecution", DetektGenerateConfigTask.SingleExecutionBuildService.class, arg_0 -> DetektPlugin.registerGenerateConfigTask$lambda$3(registerGenerateConfigTask.detektGenerateConfigSingleExecution.1.INSTANCE, arg_0));
        $this$registerGenerateConfigTask.getTasks().register(GENERATE_CONFIG, DetektGenerateConfigTask.class, arg_0 -> DetektPlugin.registerGenerateConfigTask$lambda$4((Function1)new Function1<DetektGenerateConfigTask, Unit>($this$registerGenerateConfigTask, (Provider<DetektGenerateConfigTask.SingleExecutionBuildService>)detektGenerateConfigSingleExecution2, extension){
            final /* synthetic */ Project $this_registerGenerateConfigTask;
            final /* synthetic */ Provider<DetektGenerateConfigTask.SingleExecutionBuildService> $detektGenerateConfigSingleExecution;
            final /* synthetic */ DetektExtension $extension;
            {
                this.$this_registerGenerateConfigTask = $receiver;
                this.$detektGenerateConfigSingleExecution = $detektGenerateConfigSingleExecution;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(DetektGenerateConfigTask it) {
                Object[] objectArray = new Object[]{this.$this_registerGenerateConfigTask.getProject().provider(() -> registerGenerateConfigTask.1.invoke$lambda$0(this.$extension))};
                it.getConfig().setFrom(objectArray);
                it.usesService(this.$detektGenerateConfigSingleExecution);
            }

            private static final ConfigurableFileCollection invoke$lambda$0(DetektExtension $extension) {
                Intrinsics.checkNotNullParameter((Object)((Object)$extension), (String)"$extension");
                return $extension.getConfig();
            }
        }, arg_0));
    }

    private final void configurePluginDependencies(Project project, DetektExtension extension) {
        Configuration configuration = (Configuration)project.getConfigurations().maybeCreate("detektPlugins");
        boolean bl = false;
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The detektPlugins libraries to be used for this project.");
        configuration.setCanBeResolved(true);
        configuration.setCanBeConsumed(false);
        project.getConfigurations().create("detekt", arg_0 -> DetektPlugin.configurePluginDependencies$lambda$6((Function1)new Function1<Configuration, Unit>(extension, project){
            final /* synthetic */ DetektExtension $extension;
            final /* synthetic */ Project $project;
            {
                this.$extension = $extension;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Configuration configuration) {
                configuration.setVisible(false);
                configuration.setTransitive(true);
                configuration.setDescription("The detekt dependencies to be used for this project.");
                configuration.setCanBeResolved(true);
                configuration.setCanBeConsumed(false);
                configuration.defaultDependencies(arg_0 -> configurePluginDependencies.2.invoke$lambda$0((Function1)new Function1<DependencySet, Unit>(this.$extension, this.$project){
                    final /* synthetic */ DetektExtension $extension;
                    final /* synthetic */ Project $project;
                    {
                        this.$extension = $extension;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(DependencySet dependencySet) {
                        String version = this.$extension.getToolVersion();
                        dependencySet.add((Object)this.$project.getDependencies().create((Object)("io.gitlab.arturbosch.detekt:detekt-cli:" + version)));
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void setTaskDefaults(Project project) {
        project.getTasks().withType(Detekt.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$7((Function1)new Function1<Detekt, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Detekt it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
                it.getPluginClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detektPlugins"));
            }
        }, arg_0));
        project.getTasks().withType(DetektCreateBaselineTask.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$8((Function1)new Function1<DetektCreateBaselineTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(DetektCreateBaselineTask it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
                it.getPluginClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detektPlugins"));
            }
        }, arg_0));
        project.getTasks().withType(DetektGenerateConfigTask.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$9((Function1)new Function1<DetektGenerateConfigTask, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(DetektGenerateConfigTask it) {
                it.getDetektClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detekt"));
                it.getPluginClasspath().setFrom((Iterable)this.$project.getConfigurations().getAt("detektPlugins"));
            }
        }, arg_0));
    }

    private static final void registerDetektJvmTasks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerDetektMultiplatformTasks$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerDetektAndroidTasks$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerGenerateConfigTask$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerGenerateConfigTask$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configurePluginDependencies$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void setTaskDefaults$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void setTaskDefaults$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void setTaskDefaults$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"**/*.kt", "**/*.kts"};
        defaultIncludes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin$Companion;", "", "()V", "BASELINE_TASK_NAME", "", "CONFIG_DIR_NAME", "CONFIG_FILE", "DETEKT_ANDROID_DISABLED_PROPERTY", "DETEKT_EXTENSION", "DETEKT_MULTIPLATFORM_DISABLED_PROPERTY", "DETEKT_TASK_NAME", "GENERATE_CONFIG", "defaultExcludes", "", "getDefaultExcludes$detekt_gradle_plugin", "()Ljava/util/List;", "defaultIncludes", "getDefaultIncludes$detekt_gradle_plugin", "detekt-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDefaultExcludes$detekt_gradle_plugin() {
            return defaultExcludes;
        }

        @NotNull
        public final List<String> getDefaultIncludes$detekt_gradle_plugin() {
            return defaultIncludes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

