/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.internal;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import io.gitlab.arturbosch.detekt.internal.DetektJvm;
import io.gitlab.arturbosch.detekt.internal.DetektMultiplatformKt;
import io.gitlab.arturbosch.detekt.internal.FileManglingKt;
import io.gitlab.arturbosch.detekt.internal.SharedTasksKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaCompilation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\t\u001a\u00020\u0006*\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u000f\u001a\u00020\u0006*\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/internal/DetektJvm;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "registerTasks", "", "extension", "Lio/gitlab/arturbosch/detekt/extensions/DetektExtension;", "registerJvmCreateBaselineTask", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinCommonOptions;", "inputSource", "Lorg/gradle/api/file/FileCollection;", "registerJvmDetektTask", "detekt-gradle-plugin"})
public final class DetektJvm {
    @NotNull
    private final Project project;

    public DetektJvm(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void registerTasks(@NotNull DetektExtension extension) {
        Intrinsics.checkNotNullParameter((Object)((Object)extension), (String)"extension");
        ((KotlinJvmProjectExtension)this.project.getExtensions().getByType(KotlinJvmProjectExtension.class)).getTarget().getCompilations().all(arg_0 -> DetektJvm.registerTasks$lambda$0((Function1)new Function1<KotlinWithJavaCompilation<KotlinJvmOptions, KotlinJvmCompilerOptions>, Unit>(this, extension){
            final /* synthetic */ DetektJvm this$0;
            final /* synthetic */ DetektExtension $extension;
            {
                this.this$0 = $receiver;
                this.$extension = $extension;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(KotlinWithJavaCompilation<KotlinJvmOptions, KotlinJvmCompilerOptions> compilation) {
                void $this$fold$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)compilation.getKotlinSourceSets();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKotlin().getSourceDirectories());
                }
                $this$map$iv = (List)destination$iv$iv;
                ConfigurableFileCollection configurableFileCollection = DetektJvm.access$getProject$p(this.this$0).files(new Object[0]);
                Intrinsics.checkNotNull((Object)configurableFileCollection, (String)"null cannot be cast to non-null type org.gradle.api.file.FileCollection");
                FileCollection initial$iv = (FileCollection)configurableFileCollection;
                boolean $i$f$fold = false;
                FileCollection accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void next;
                    Object item$iv$iv;
                    item$iv$iv = (FileCollection)element$iv;
                    FileCollection collection = accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)collection.plus((FileCollection)next), (String)"plus(...)");
                }
                FileCollection inputSource = accumulator$iv;
                Project project = DetektJvm.access$getProject$p(this.this$0);
                Intrinsics.checkNotNull(compilation);
                DetektJvm.access$registerJvmDetektTask(this.this$0, project, (KotlinCompilation)compilation, this.$extension, inputSource);
                DetektJvm.access$registerJvmCreateBaselineTask(this.this$0, DetektJvm.access$getProject$p(this.this$0), (KotlinCompilation)compilation, this.$extension, inputSource);
            }
        }, arg_0));
    }

    private final void registerJvmDetektTask(Project $this$registerJvmDetektTask, KotlinCompilation<? extends KotlinCommonOptions> compilation, DetektExtension extension, FileCollection inputSource) {
        SharedTasksKt.registerDetektTask($this$registerJvmDetektTask, "detekt" + StringsKt.capitalize((String)compilation.getName()), extension, (Function1<? super Detekt, Unit>)((Function1)new Function1<Detekt, Unit>(inputSource, compilation, extension, $this$registerJvmDetektTask){
            final /* synthetic */ FileCollection $inputSource;
            final /* synthetic */ KotlinCompilation<KotlinCommonOptions> $compilation;
            final /* synthetic */ DetektExtension $extension;
            final /* synthetic */ Project $this_registerJvmDetektTask;
            {
                this.$inputSource = $inputSource;
                this.$compilation = $compilation;
                this.$extension = $extension;
                this.$this_registerJvmDetektTask = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Detekt $this$registerDetektTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$registerDetektTask), (String)"$this$registerDetektTask");
                $this$registerDetektTask.setSource(this.$inputSource);
                Object[] objectArray = new Object[]{this.$compilation.getOutput().getClassesDirs(), this.$compilation.getCompileDependencyFiles()};
                $this$registerDetektTask.getClasspath().setFrom(objectArray);
                File file = this.$extension.getBaseline();
                if (file != null && (file = FileManglingKt.existingVariantOrBaseFile(file, this.$compilation.getName())) != null) {
                    File file2 = file;
                    Project project = this.$this_registerJvmDetektTask;
                    File baselineFile = file2;
                    boolean bl = false;
                    $this$registerDetektTask.getBaseline().convention(project.getLayout().file(project.provider(() -> registerJvmDetektTask.1.invoke$lambda$1$lambda$0(baselineFile))));
                }
                DetektMultiplatformKt.setReportOutputConventions(this.$this_registerJvmDetektTask, $this$registerDetektTask.getReports(), this.$extension, this.$compilation.getName());
                $this$registerDetektTask.setDescription("EXPERIMENTAL: Run detekt analysis for " + this.$compilation.getName() + " classes with type resolution");
            }

            private static final File invoke$lambda$1$lambda$0(File $baselineFile) {
                Intrinsics.checkNotNullParameter((Object)$baselineFile, (String)"$baselineFile");
                return $baselineFile;
            }
        }));
    }

    private final void registerJvmCreateBaselineTask(Project $this$registerJvmCreateBaselineTask, KotlinCompilation<? extends KotlinCommonOptions> compilation, DetektExtension extension, FileCollection inputSource) {
        SharedTasksKt.registerCreateBaselineTask($this$registerJvmCreateBaselineTask, "detektBaseline" + StringsKt.capitalize((String)compilation.getName()), extension, (Function1<? super DetektCreateBaselineTask, Unit>)((Function1)new Function1<DetektCreateBaselineTask, Unit>(inputSource, compilation, extension, $this$registerJvmCreateBaselineTask){
            final /* synthetic */ FileCollection $inputSource;
            final /* synthetic */ KotlinCompilation<KotlinCommonOptions> $compilation;
            final /* synthetic */ DetektExtension $extension;
            final /* synthetic */ Project $this_registerJvmCreateBaselineTask;
            {
                this.$inputSource = $inputSource;
                this.$compilation = $compilation;
                this.$extension = $extension;
                this.$this_registerJvmCreateBaselineTask = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DetektCreateBaselineTask $this$registerCreateBaselineTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$registerCreateBaselineTask), (String)"$this$registerCreateBaselineTask");
                $this$registerCreateBaselineTask.setSource(this.$inputSource);
                Object[] objectArray = new Object[]{this.$compilation.getOutput().getClassesDirs(), this.$compilation.getCompileDependencyFiles()};
                $this$registerCreateBaselineTask.getClasspath().setFrom(objectArray);
                File file = this.$extension.getBaseline();
                File variantBaselineFile = file != null ? FileManglingKt.addVariantName$default(file, this.$compilation.getName(), null, 2, null) : null;
                $this$registerCreateBaselineTask.getBaseline().convention(this.$this_registerJvmCreateBaselineTask.getLayout().file(this.$this_registerJvmCreateBaselineTask.provider(() -> registerJvmCreateBaselineTask.1.invoke$lambda$0(variantBaselineFile))));
                $this$registerCreateBaselineTask.setDescription("EXPERIMENTAL: Creates detekt baseline for " + this.$compilation.getName() + " classes with type resolution");
            }

            private static final File invoke$lambda$0(File $variantBaselineFile) {
                return $variantBaselineFile;
            }
        }));
    }

    private static final void registerTasks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(DetektJvm $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$registerJvmDetektTask(DetektJvm $this, Project $receiver, KotlinCompilation compilation, DetektExtension extension, FileCollection inputSource) {
        $this.registerJvmDetektTask($receiver, (KotlinCompilation<? extends KotlinCommonOptions>)compilation, extension, inputSource);
    }

    public static final /* synthetic */ void access$registerJvmCreateBaselineTask(DetektJvm $this, Project $receiver, KotlinCompilation compilation, DetektExtension extension, FileCollection inputSource) {
        $this.registerJvmCreateBaselineTask($receiver, (KotlinCompilation<? extends KotlinCommonOptions>)compilation, extension, inputSource);
    }
}

