/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules;

import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\f\u0010\n\u001a\u00020\b*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\b*\u00020\u000bH\u0002\u001a\n\u0010\r\u001a\u00020\b*\u00020\t\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\t\u001a\n\u0010\u000f\u001a\u00020\b*\u00020\u000b\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"knownAnys", "", "", "extractMethodNameAndParams", "Lkotlin/Pair;", "", "methodSignature", "hasCorrectEqualsParameter", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "hasMainParameter", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasMainSignature", "isEqualsFunction", "isHashCodeFunction", "isMainFunction", "isMainInsideObject", "detekt-psi-utils"})
public final class MethodSignatureKt {
    private static final Set<String> knownAnys = SetsKt.setOf((Object[])new String[]{"Any?", "kotlin.Any?"});

    public static final boolean isEqualsFunction(@NotNull KtFunction $this$isEqualsFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualsFunction, (String)"$this$isEqualsFunction");
        return Intrinsics.areEqual((Object)$this$isEqualsFunction.getName(), (Object)"equals") && KtModifierListKt.isOverride((KtModifierListOwner)$this$isEqualsFunction) && MethodSignatureKt.hasCorrectEqualsParameter($this$isEqualsFunction);
    }

    public static final boolean isHashCodeFunction(@NotNull KtFunction $this$isHashCodeFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isHashCodeFunction, (String)"$this$isHashCodeFunction");
        return Intrinsics.areEqual((Object)$this$isHashCodeFunction.getName(), (Object)"hashCode") && KtModifierListKt.isOverride((KtModifierListOwner)$this$isHashCodeFunction) && $this$isHashCodeFunction.getValueParameters().isEmpty();
    }

    public static final boolean hasCorrectEqualsParameter(@NotNull KtFunction $this$hasCorrectEqualsParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectEqualsParameter, (String)"$this$hasCorrectEqualsParameter");
        Iterable iterable = knownAnys;
        List list = $this$hasCorrectEqualsParameter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list);
        return CollectionsKt.contains((Iterable)iterable, ktParameter != null && (ktParameter = ktParameter.getTypeReference()) != null ? ktParameter.getText() : null);
    }

    public static final boolean isMainFunction(@NotNull KtNamedFunction $this$isMainFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isMainFunction, (String)"$this$isMainFunction");
        return MethodSignatureKt.hasMainSignature($this$isMainFunction) && ($this$isMainFunction.isTopLevel() || MethodSignatureKt.isMainInsideObject($this$isMainFunction));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, List<String>> extractMethodNameAndParams(@NotNull String methodSignature) {
        List list;
        String string;
        String string2;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)methodSignature, (String)"methodSignature");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)methodSignature, (String[])new String[]{"(", ")"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Iterator iterator = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string2 = it;
            boolean bl2 = false;
            void v0 = string2;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            collection.add(string);
        }
        List tokens = (List)destination$iv$iv;
        String methodName = StringsKt.replace$default((String)((String)CollectionsKt.first((List)tokens)), (String)"`", (String)"", (boolean)false, (int)4, null);
        if (tokens.size() > 1) {
            void $this$filterTo$iv$iv;
            boolean bl;
            CharSequence charSequence;
            String it;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)tokens.get(1)), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                string2 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                charSequence = it;
                bl = false;
                void v1 = charSequence;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl4 = false;
                charSequence = it;
                bl = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = null;
        }
        List params = list;
        return TuplesKt.to((Object)methodName, params);
    }

    private static final boolean hasMainSignature(KtNamedFunction $this$hasMainSignature) {
        return Intrinsics.areEqual((Object)$this$hasMainSignature.getName(), (Object)"main") && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$hasMainSignature) && MethodSignatureKt.hasMainParameter($this$hasMainSignature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasMainParameter(KtNamedFunction $this$hasMainParameter) {
        if ($this$hasMainParameter.getValueParameters().isEmpty()) return true;
        if ($this$hasMainParameter.getValueParameters().size() != 1) return false;
        Object e = $this$hasMainParameter.getValueParameters().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
        KtTypeReference ktTypeReference = ((KtParameter)e).getTypeReference();
        if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)"Array<String>")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMainInsideObject(KtNamedFunction $this$isMainInsideObject) {
        if (!Intrinsics.areEqual((Object)$this$isMainInsideObject.getName(), (Object)"main")) return false;
        if (!KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$isMainInsideObject)) return false;
        PsiElement psiElement = $this$isMainInsideObject.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof KtObjectDeclaration)) return false;
        if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)$this$isMainInsideObject, "JvmStatic", "kotlin.jvm.JvmStatic")) return false;
        return true;
    }
}

