/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.bugs.ImplicitDefaultLocaleKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitDefaultLocale;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkCaseConversion", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "checkStringFormatting", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "detekt-rules-errorprone"})
public final class ImplicitDefaultLocale
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitDotQualifiedExpression(expression);
        this.checkStringFormatting((KtQualifiedExpression)expression);
        this.checkCaseConversion((KtQualifiedExpression)expression);
    }

    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitSafeQualifiedExpression(expression);
        this.checkStringFormatting((KtQualifiedExpression)expression);
        this.checkCaseConversion((KtQualifiedExpression)expression);
    }

    private final void checkStringFormatting(KtQualifiedExpression expression) {
        if (Intrinsics.areEqual((Object)expression.getReceiverExpression().getText(), (Object)"String")) {
            KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny((KtElement)((KtElement)expression));
            if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"format") && ImplicitDefaultLocaleKt.access$containsStringTemplate(expression)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), expression.getText() + " uses implicitly default locale for string formatting.", null, null, 24, null));
            }
        }
    }

    private final void checkCaseConversion(KtQualifiedExpression expression) {
        if (KotlinBuiltIns.isStringOrNullableString((KotlinType)CallUtilKt.getType((KtExpression)expression.getReceiverExpression(), (BindingContext)this.getBindingContext())) && ImplicitDefaultLocaleKt.access$isCalleeCaseConversion(expression) && ImplicitDefaultLocaleKt.access$isCalleeNoArgs(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), expression.getText() + " uses implicitly default locale for case conversion.", null, null, 24, null));
        }
    }

    public ImplicitDefaultLocale(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ImplicitDefaultLocale", Severity.CodeSmell, "Implicit default locale used for string processing. Consider using explicit locale.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ImplicitDefaultLocale(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ImplicitDefaultLocale() {
        this(null, 1, null);
    }
}

