/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\n*\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\n*\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnconditionalJumpStatementInLoop;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasJumpStatement", "", "body", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitLoopExpression", "", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "containsElvisContinue", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isAfterConditionalJumpStatement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isConditionalJumpStatement", "isJumpStatement", "detekt-rules-errorprone"})
public final class UnconditionalJumpStatementInLoop
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
        if (this.hasJumpStatement(loopExpression.getBody())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)loopExpression), (int)0, (int)2, null), "This loop contains an unconditional jump expression which essentially renders it useless as it will exit the loop during the first iteration.", null, null, 24, null));
        }
        super.visitLoopExpression(loopExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasJumpStatement(KtExpression body) {
        if (this.isJumpStatement((PsiElement)body)) return true;
        PsiElement[] psiElementArray = body;
        if (body == null) return false;
        PsiElement[] psiElementArray2 = psiElementArray.getChildren();
        psiElementArray = psiElementArray2;
        if (psiElementArray2 == null) return false;
        PsiElement[] $this$any$iv = psiElementArray;
        boolean $i$f$any = false;
        PsiElement[] psiElementArray3 = $this$any$iv;
        int n = psiElementArray3.length;
        int n2 = 0;
        while (n2 < n) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray3[n2];
            boolean bl = false;
            if (this.isJumpStatement(it)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final boolean isJumpStatement(PsiElement $this$isJumpStatement) {
        return $this$isJumpStatement instanceof KtReturnExpression && !this.containsElvisContinue((KtReturnExpression)$this$isJumpStatement) && !this.isAfterConditionalJumpStatement($this$isJumpStatement) || $this$isJumpStatement instanceof KtBreakExpression || $this$isJumpStatement instanceof KtContinueExpression;
    }

    private final boolean containsElvisContinue(KtReturnExpression $this$containsElvisContinue) {
        KtExpression expr = $this$containsElvisContinue.getReturnedExpression();
        return expr instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expr).getOperationToken(), (Object)KtTokens.ELVIS) && ((KtBinaryExpression)expr).getRight() instanceof KtContinueExpression;
    }

    private final boolean isAfterConditionalJumpStatement(PsiElement $this$isAfterConditionalJumpStatement) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiUtilsKt.siblings((PsiElement)$this$isAfterConditionalJumpStatement, (boolean)false, (boolean)false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!this.isConditionalJumpStatement(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConditionalJumpStatement(PsiElement $this$isConditionalJumpStatement) {
        void result$iv$iv$iv;
        void $this$anyDescendantOfType$iv;
        if (!($this$isConditionalJumpStatement instanceof KtIfExpression)) {
            if (!($this$isConditionalJumpStatement instanceof KtWhenExpression)) return false;
        }
        PsiElement psiElement = $this$isConditionalJumpStatement;
        Function1 predicate$iv = (Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ UnconditionalJumpStatementInLoop this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return UnconditionalJumpStatementInLoop.access$isJumpStatement(this.this$0, it);
            }
            {
                this.this$0 = unconditionalJumpStatementInLoop;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }

    public UnconditionalJumpStatementInLoop(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "An unconditional jump statement in a loop is useless. The loop itself is only executed once.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ UnconditionalJumpStatementInLoop(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnconditionalJumpStatementInLoop() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isJumpStatement(UnconditionalJumpStatementInLoop $this, PsiElement $this$access_u24isJumpStatement) {
        return $this.isJumpStatement($this$access_u24isJumpStatement);
    }
}

