/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCatchBlock;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "catchClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isSubclassOf", "", "detekt-rules-errorprone"})
public final class UnreachableCatchBlock
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        boolean bl;
        block9: {
            List prevCatchClauses;
            KtCatchClause it;
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            super.visitCatchSection(catchClause);
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)catchClause;
            boolean $i$f$getStrictParentOfType = false;
            KtTryExpression ktTryExpression = (KtTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTryExpression.class, (boolean)true);
            if (ktTryExpression == null) {
                return;
            }
            KtTryExpression tryExpression = ktTryExpression;
            List list = tryExpression.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tryExpression.catchClauses");
            Iterable $this$takeWhile$iv = list;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                it = (KtCatchClause)item$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)catchClause) ^ true)) break;
                list$iv.add(item$iv);
            }
            if ((prevCatchClauses = (List)list$iv).isEmpty()) {
                return;
            }
            ClassDescriptor classDescriptor = this.catchClassDescriptor(catchClause);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor catchClassDescriptor = classDescriptor;
            Iterable $this$any$iv = prevCatchClauses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KtCatchClause)element$iv;
                    boolean bl3 = false;
                    KtCatchClause ktCatchClause = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktCatchClause, (String)"it");
                    if (!this.isSubclassOf(catchClassDescriptor, ktCatchClause)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchClause), (int)0, (int)2, null), "This catch block is unreachable.", null, null, 24, null));
        }
    }

    private final ClassDescriptor catchClassDescriptor(KtCatchClause $this$catchClassDescriptor) {
        ClassDescriptor classDescriptor;
        KtParameter ktParameter = $this$catchClassDescriptor.getCatchParameter();
        if (ktParameter == null || (ktParameter = ktParameter.getTypeReference()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"catchParameter?.typeReference ?: return null");
        KtParameter typeReference = ktParameter;
        KotlinType kotlinType = (KotlinType)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null) {
            KotlinType $this$safeAs$iv = kotlinType;
            boolean $i$f$safeAs = false;
            KotlinType kotlinType2 = $this$safeAs$iv;
            if (!(kotlinType2 instanceof ClassDescriptor)) {
                kotlinType2 = null;
            }
            classDescriptor = (ClassDescriptor)kotlinType2;
        } else {
            classDescriptor = null;
        }
        return classDescriptor;
    }

    private final boolean isSubclassOf(ClassDescriptor $this$isSubclassOf, KtCatchClause catchClause) {
        ClassDescriptor classDescriptor = this.catchClassDescriptor(catchClause);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor catchClassDescriptor = classDescriptor;
        return DescriptorUtilsKt.isSubclassOf((ClassDescriptor)$this$isSubclassOf, (ClassDescriptor)catchClassDescriptor);
    }

    public UnreachableCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "Unreachable catch block detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnreachableCatchBlock(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnreachableCatchBlock() {
        this(null, 1, null);
    }
}

