/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u0006*\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreLabeled", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "canFilterLabeledExpression", "returnStmt", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isReturnFromTargetFunction", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "returnStmts", "visitTryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "typeEqualsTo", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Companion", "detekt-rules-exceptions"})
public final class ReturnFromFinally
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean ignoreLabeled;
    @NotNull
    public static final String IGNORE_LABELED = "ignoreLabeled";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryExpression(@NotNull KtTryExpression expression) {
        void $this$forEachDescendantOfType$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitTryExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtFinallySection ktFinallySection = expression.getFinallyBlock();
        if (ktFinallySection == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktFinallySection, (String)"expression.finallyBlock ?: return");
        KtFinallySection finallyBlock = ktFinallySection;
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext()) && this.typeEqualsTo(finallyBlock, CallUtilKt.getType((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext()))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)finallyBlock), (int)0, (int)2, null), "Contents of the finally block do not affect the result of the expression.", null, null, 24, null));
        }
        KtBlockExpression ktBlockExpression = finallyBlock.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finallyBlock.finalExpression");
        PsiElement psiElement = (PsiElement)ktBlockExpression;
        Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(this, finallyBlock){
            final /* synthetic */ ReturnFromFinally this$0;
            final /* synthetic */ KtFinallySection $finallyBlock;

            public final boolean invoke(@NotNull KtReturnExpression returnExpression) {
                Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
                KtBlockExpression ktBlockExpression = this.$finallyBlock.getFinalExpression();
                Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finallyBlock.finalExpression");
                return ReturnFromFinally.access$isReturnFromTargetFunction(this.this$0, ktBlockExpression, returnExpression) && ReturnFromFinally.access$canFilterLabeledExpression(this.this$0, returnExpression);
            }
            {
                this.this$0 = returnFromFinally;
                this.$finallyBlock = ktFinallySection;
                super(1);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        ArrayList result$iv$iv = new ArrayList();
        void var9_13 = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = result$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isReturnFromTargetFunction(KtBlockExpression blockExpression, KtReturnExpression returnStmts) {
        KtCallableDeclaration ktCallableDeclaration = BindingContextUtilsKt.getTargetFunction((KtReturnExpression)returnStmts, (BindingContext)this.getBindingContext());
        if (ktCallableDeclaration == null) {
            return false;
        }
        KtCallableDeclaration targetFunction = ktCallableDeclaration;
        Iterable targetFunctionBodyExpressionStatements = SequencesKt.asIterable((Sequence)KtPsiUtilKt.blockExpressionsOrSingle((KtElement)((KtElement)targetFunction)));
        return PsiUtilsKt.isInsideOf((PsiElement)((PsiElement)blockExpression), (Iterable)targetFunctionBodyExpressionStatements);
    }

    private final boolean canFilterLabeledExpression(KtReturnExpression returnStmt) {
        return !this.ignoreLabeled || returnStmt.getLabeledExpression() == null;
    }

    private final boolean typeEqualsTo(KtFinallySection $this$typeEqualsTo, KotlinType type) {
        KtBlockExpression finallyExpression;
        KtBlockExpression ktBlockExpression = finallyExpression = $this$typeEqualsTo.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finallyExpression");
        if (ktBlockExpression.getStatements().isEmpty()) {
            return false;
        }
        KtBlockExpression ktBlockExpression2 = $this$typeEqualsTo.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression2, (String)"finalExpression");
        return Intrinsics.areEqual((Object)CallUtilKt.getType((KtExpression)((KtExpression)ktBlockExpression2), (BindingContext)this.getBindingContext()), (Object)type);
    }

    public ReturnFromFinally(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ReturnFromFinally", Severity.Defect, "Do not return within a finally statement. This can discard exceptions.", Debt.Companion.getTWENTY_MINS());
        this.ignoreLabeled = (Boolean)this.valueOrDefault(IGNORE_LABELED, false);
    }

    public /* synthetic */ ReturnFromFinally(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ReturnFromFinally() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isReturnFromTargetFunction(ReturnFromFinally $this, KtBlockExpression blockExpression, KtReturnExpression returnStmts) {
        return $this.isReturnFromTargetFunction(blockExpression, returnStmts);
    }

    public static final /* synthetic */ boolean access$canFilterLabeledExpression(ReturnFromFinally $this, KtReturnExpression returnStmt) {
        return $this.canFilterLabeledExpression(returnStmt);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally$Companion;", "", "()V", "IGNORE_LABELED", "", "detekt-rules-exceptions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

