/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maximumVariableNameLength", "", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-naming"})
public final class VariableMaxLength
extends Rule {
    @NotNull
    private final Issue issue;
    private final int maximumVariableNameLength;
    @NotNull
    public static final String MAXIMUM_VARIABLE_NAME_LENGTH = "maximumVariableNameLength";
    private static final int DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH = 64;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property)).length() > this.maximumVariableNameLength) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), "Variable names should be at most " + this.maximumVariableNameLength + " characters long.", null, null, 24, null));
        }
    }

    public VariableMaxLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Variable names should not be longer than the maximum set in the configuration.", Debt.Companion.getFIVE_MINS());
        this.maximumVariableNameLength = ((Number)this.valueOrDefault(MAXIMUM_VARIABLE_NAME_LENGTH, 64)).intValue();
    }

    public /* synthetic */ VariableMaxLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public VariableMaxLength() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength$Companion;", "", "()V", "DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH", "", "MAXIMUM_VARIABLE_NAME_LENGTH", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

