/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.ClassOrdering;
import io.gitlab.arturbosch.detekt.rules.style.ClassOrderingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "comparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lkotlin/Comparator;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassBody", "", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "detekt-rules-style"})
public final class ClassOrdering
extends Rule {
    @NotNull
    private final Issue issue;
    private final Comparator<KtDeclaration> comparator;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassBody(@NotNull KtClassBody classBody) {
        Intrinsics.checkNotNullParameter((Object)classBody, (String)"classBody");
        super.visitClassBody(classBody);
        List misorders = ClassOrderingKt.access$findOutOfOrder(this.comparator, classBody.getDeclarations());
        Iterable iterable = misorders;
        boolean bl = false;
        if (!iterable.isEmpty()) {
            Collection<CodeSmell> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = misorders;
            ClassOrdering classOrdering = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it.getFirst()), (int)0, (int)2, null), ClassOrderingKt.access$getDescription$p((KtDeclaration)it.getFirst()) + " should not come before " + ClassOrderingKt.access$getDescription$p((KtDeclaration)it.getSecond()), null, CollectionsKt.listOf((Object)Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classBody), (int)0, (int)2, null)), 8, null);
                collection.add(codeSmell);
            }
            collection = (List)destination$iv$iv;
            classOrdering.report((List)collection);
        }
    }

    public ClassOrdering(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Class contents should be in this order: Property declarations/initializer blocks; secondary constructors; method declarations then companion objects.", Debt.Companion.getFIVE_MINS());
        this.comparator = comparator.1.INSTANCE;
    }

    public /* synthetic */ ClassOrdering(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ClassOrdering() {
        this(null, 1, null);
    }
}

