/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DestructuringDeclarationWithTooManyEntries;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxDestructuringEntries", "", "visitDestructuringDeclaration", "", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "Companion", "detekt-rules-style"})
public final class DestructuringDeclarationWithTooManyEntries
extends Rule {
    @NotNull
    private final Issue issue;
    private final int maxDestructuringEntries;
    @NotNull
    public static final String MAX_DESTRUCTURING_ENTRIES = "maxDestructuringEntries";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        if (destructuringDeclaration.getEntries().size() > this.maxDestructuringEntries) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)destructuringDeclaration), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitDestructuringDeclaration(destructuringDeclaration);
    }

    public DestructuringDeclarationWithTooManyEntries(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The destructuring declaration contains too many entries, making it difficult to read. Consider refactoring to avoid using a destructuring declaration for this case.", Debt.Companion.getTEN_MINS());
        this.maxDestructuringEntries = ((Number)this.valueOrDefault(MAX_DESTRUCTURING_ENTRIES, 3)).intValue();
    }

    public /* synthetic */ DestructuringDeclarationWithTooManyEntries(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public DestructuringDeclarationWithTooManyEntries() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DestructuringDeclarationWithTooManyEntries$Companion;", "", "()V", "MAX_DESTRUCTURING_ENTRIES", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

