/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n*\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u000f*\u0004\u0018\u00010\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ktAndJavaCollections", "", "", "ktCollections", "mapAccessMethods", "isGetOrPut", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isMapMethod", "visitCallExpression", "", "collectTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "isEligibleCollection", "detekt-rules-style"})
public final class ExplicitCollectionElementAccessMethod
extends Rule {
    private final Set<String> ktCollections;
    private final Set<String> mapAccessMethods;
    private final Set<String> ktAndJavaCollections;
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isMapMethod(expression) && this.isGetOrPut(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Prefer usage of indexed access operator [].", null, null, 24, null));
        }
        super.visitCallExpression(expression);
    }

    private final boolean isGetOrPut(KtCallExpression expression) {
        KtExpression ktExpression = expression.getCalleeExpression();
        return CollectionsKt.contains((Iterable)this.mapAccessMethods, (Object)(ktExpression != null ? ktExpression.getText() : null));
    }

    private final boolean isMapMethod(KtCallExpression expression) {
        ResolvedCall resolvedCall;
        PsiElement psiElement;
        PsiElement dotExpression;
        PsiElement psiElement2 = dotExpression = expression.getPrevSibling();
        Object object = psiElement = psiElement2 != null ? psiElement2.getParent() : null;
        if (!(psiElement instanceof KtDotQualifiedExpression)) {
            return false;
        }
        PsiElement caller = dotExpression.getPrevSibling();
        PsiElement psiElement3 = caller;
        if (!(psiElement3 instanceof KtElement)) {
            psiElement3 = null;
        }
        return this.isEligibleCollection((resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)psiElement3), (BindingContext)this.getBindingContext())) != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? resolvedCall.getReturnType() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEligibleCollection(KotlinType $this$isEligibleCollection) {
        KotlinType it;
        KotlinType kotlinType = $this$isEligibleCollection;
        if (kotlinType != null && (kotlinType = DescriptorUtilsKt.getNameIfStandardType((KotlinType)kotlinType)) != null) {
            KotlinType kotlinType2 = kotlinType;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it2 = kotlinType2;
            return this.ktCollections.contains(it2.toString());
        }
        KotlinType kotlinType3 = $this$isEligibleCollection;
        Object object = kotlinType3;
        if (kotlinType3 == null) return false;
        Set<KotlinType> set = this.collectTypes((KotlinType)object);
        object = set;
        if (set == null) return false;
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
        } while (!this.ktAndJavaCollections.contains(it.getConstructor().toString()));
        return true;
    }

    private final Set<KotlinType> collectTypes(KotlinType $this$collectTypes) {
        boolean bl = false;
        Set result = new LinkedHashSet();
        Collection collection = $this$collectTypes.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this\n            .constr\u2026r\n            .supertypes");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinType type = (KotlinType)element$iv;
            boolean bl2 = false;
            KotlinType kotlinType = type;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
            result.add(kotlinType);
            Iterable $this$forEach$iv2 = TypeUtilsKt.supertypes((KotlinType)type);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinType it = (KotlinType)element$iv2;
                boolean bl3 = false;
                result.addAll((Collection)this.collectTypes(it));
            }
        }
        return result;
    }

    public ExplicitCollectionElementAccessMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.ktCollections = SetsKt.setOf((Object[])new String[]{"Map", "MutableMap", "List", "MutableList"});
        this.mapAccessMethods = SetsKt.setOf((Object[])new String[]{"get", "put"});
        this.ktAndJavaCollections = SetsKt.plus(this.ktCollections, (Iterable)SetsKt.setOf((Object[])new String[]{"AbstractMap", "AbstractList"}));
        this.issue = new Issue("ExplicitCollectionElementAccessMethod", Severity.Style, "Prefer usage of indexed access operator [] for map element access or insert methods", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ExplicitCollectionElementAccessMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ExplicitCollectionElementAccessMethod() {
        this(null, 1, null);
    }
}

