/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.ExpressionBodySyntax;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "includeLineWrapping", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isLineWrapped", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "containsReturnStmtsInNullableArguments", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "singleReturnStatement", "Companion", "detekt-rules-style"})
public final class ExpressionBodySyntax
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean includeLineWrapping;
    @NotNull
    public static final String INCLUDE_LINE_WRAPPING = "includeLineWrapping";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        KtExpression stmt;
        Object object;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression != null && (ktExpression = this.singleReturnStatement(ktExpression)) != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtExpression it = ktExpression2;
            boolean bl3 = false;
            object = !this.containsReturnStmtsInNullableArguments((KtReturnExpression)it) ? ktExpression2 : null;
        } else {
            object = stmt = null;
        }
        if (stmt != null && (this.includeLineWrapping || !this.isLineWrapped(stmt))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)stmt), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final KtReturnExpression singleReturnStatement(KtExpression $this$singleReturnStatement) {
        KtExpression ktExpression;
        Object object;
        KtExpression ktExpression2 = $this$singleReturnStatement;
        if (!(ktExpression2 instanceof KtBlockExpression)) {
            ktExpression2 = null;
        }
        if (!(((object = (KtBlockExpression)ktExpression2) != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : (ktExpression = null)) instanceof KtReturnExpression)) {
            ktExpression = null;
        }
        return (KtReturnExpression)ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsReturnStmtsInNullableArguments(KtReturnExpression $this$containsReturnStmtsInNullableArguments) {
        void result$iv$iv$iv;
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsReturnStmtsInNullableArguments;
        Function1 predicate$iv = containsReturnStmtsInNullableArguments.1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isLineWrapped(KtExpression expression) {
        boolean bl;
        block1: {
            PsiElement[] psiElementArray = expression.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"expression.children");
            PsiElement[] $this$any$iv = psiElementArray;
            boolean $i$f$any = false;
            PsiElement[] psiElementArray2 = $this$any$iv;
            int n = psiElementArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiElement element$iv;
                PsiElement it = element$iv = psiElementArray2[i];
                boolean bl2 = false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                String string = psiElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                if (!StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public ExpressionBodySyntax(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Functions with exact one statement, the return statement, can be rewritten with ExpressionBodySyntax.", Debt.Companion.getFIVE_MINS());
        this.includeLineWrapping = (Boolean)this.valueOrDefault(INCLUDE_LINE_WRAPPING, false);
    }

    public /* synthetic */ ExpressionBodySyntax(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ExpressionBodySyntax() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax$Companion;", "", "()V", "INCLUDE_LINE_WRAPPING", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

