/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantExplicitType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "typeIsSameAs", "", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-style"})
public final class RedundantExplicitType
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitProperty(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (!property.isLocal()) {
            return;
        }
        KtTypeReference ktTypeReference = property.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"property.typeReference ?: return");
        KtTypeReference typeReference = ktTypeReference;
        Object object = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property);
        if (!(object instanceof VariableDescriptor)) {
            object = null;
        }
        if ((variableDescriptor = (VariableDescriptor)object) == null || (variableDescriptor = variableDescriptor.getType()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"(bindingContext[BindingC\u2026scriptor)?.type ?: return");
        VariableDescriptor type = variableDescriptor;
        if (type instanceof AbbreviatedType) {
            return;
        }
        KtExpression initializer = property.getInitializer();
        if (initializer instanceof KtConstantExpression) {
            if (!this.typeIsSameAs((KtConstantExpression)initializer, (KotlinType)type)) {
                return;
            }
        } else if (initializer instanceof KtStringTemplateExpression) {
            if (!KotlinBuiltIns.isString((KotlinType)type)) {
                return;
            }
        } else if (initializer instanceof KtNameReferenceExpression) {
            if (Intrinsics.areEqual((Object)typeReference.getText(), (Object)((KtNameReferenceExpression)initializer).getReferencedName()) ^ true) {
                return;
            }
        } else if (initializer instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)initializer).getCalleeExpression();
            if (Intrinsics.areEqual((Object)typeReference.getText(), (Object)(ktExpression != null ? ktExpression.getText() : null)) ^ true) {
                return;
            }
        } else {
            return;
        }
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), this.getIssue().getDescription(), null, null, 24, null));
        super.visitProperty(property);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean typeIsSameAs(KtConstantExpression $this$typeIsSameAs, KotlinType type) {
        boolean bl;
        ASTNode aSTNode = $this$typeIsSameAs.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            bl = TypeUtilsKt.isBoolean((KotlinType)type);
            return bl;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
            bl = TypeUtilsKt.isChar((KotlinType)type);
            return bl;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            String string = $this$typeIsSameAs.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            if (StringsKt.endsWith$default((String)string, (String)"L", (boolean)false, (int)2, null)) {
                bl = TypeUtilsKt.isLong((KotlinType)type);
                return bl;
            }
            bl = TypeUtilsKt.isInt((KotlinType)type);
            return bl;
        }
        if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            return false;
        }
        String string = $this$typeIsSameAs.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.endsWith$default((String)string, (String)"f", (boolean)false, (int)2, null)) {
            String string2 = $this$typeIsSameAs.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
            if (!StringsKt.endsWith$default((String)string2, (String)"F", (boolean)false, (int)2, null)) {
                bl = TypeUtilsKt.isDouble((KotlinType)type);
                return bl;
            }
        }
        bl = TypeUtilsKt.isFloat((KotlinType)type);
        return bl;
    }

    public RedundantExplicitType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantExplicitType", Severity.Style, "Type does not need to be stated explicitly and can be removed.", Debt.Companion.getFIVE_MINS());
    }
}

