/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "excludeAnnotatedClasses", "", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "noAbstractMember", "noConcreteMember", "hasNoConstructorParameter", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "report", "", "finding", "Lio/gitlab/arturbosch/detekt/api/Finding;", "visitClass", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "NamedClassMembers", "detekt-rules-style"})
public final class UnnecessaryAbstractClass
extends Rule {
    private final String noConcreteMember;
    private final String noAbstractMember;
    @NotNull
    private final Issue issue;
    private final List<String> excludeAnnotatedClasses;
    private AnnotationExcluder annotationExcluder;
    @NotNull
    public static final String EXCLUDE_ANNOTATED_CLASSES = "excludeAnnotatedClasses";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.excludeAnnotatedClasses);
        super.visitKtFile(file);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isInterface() && KtPsiUtilKt.isAbstract((KtClass)klass)) {
            KtClassBody body = klass.getBody();
            if (body != null) {
                void $this$filterTo$iv$iv;
                PsiElement[] psiElementArray = body.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"body.children");
                PsiElement[] $this$filter$iv = psiElementArray;
                boolean $i$f$filter = false;
                PsiElement[] psiElementArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var9_8 = $this$filterTo$iv$iv;
                int n = ((void)var9_8).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var9_8[i];
                    boolean bl = false;
                    if (!(it instanceof KtProperty || it instanceof KtNamedFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List namedMembers = (List)destination$iv$iv;
                NamedClassMembers namedClassMembers = new NamedClassMembers(klass, namedMembers);
                namedClassMembers.detectAbstractAndConcreteType();
            } else if (klass.getSuperTypeListEntries().isEmpty() && !this.hasNoConstructorParameter(klass)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), this.noAbstractMember, null, null, 24, null), klass);
            }
        }
        super.visitClass(klass);
    }

    private final void report(Finding finding, KtClass klass) {
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
        }
        List list = klass.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"klass.annotationEntries");
        if (!annotationExcluder.shouldExclude(list)) {
            this.report(finding);
        }
    }

    private final boolean hasNoConstructorParameter(KtClass klass) {
        KtPrimaryConstructor primaryConstructor = klass.getPrimaryConstructor();
        return primaryConstructor == null || !CollectionsKt.any((Iterable)primaryConstructor.getValueParameters());
    }

    /*
     * WARNING - void declaration
     */
    public UnnecessaryAbstractClass(@NotNull Config config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.noConcreteMember = "An abstract class without a concrete member can be refactored to an interface.";
        this.noAbstractMember = "An abstract class without an abstract member can be refactored to a concrete class.";
        this.issue = new Issue("UnnecessaryAbstractClass", Severity.Style, "An abstract class is unnecessary and can be refactored. An abstract class should have both abstract and concrete properties or functions. " + this.noConcreteMember + " " + this.noAbstractMember, Debt.Companion.getFIVE_MINS());
        Iterable iterable = PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)EXCLUDE_ANNOTATED_CLASSES, (List)CollectionsKt.listOf((Object)"dagger.Module"));
        UnnecessaryAbstractClass unnecessaryAbstractClass = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*");
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        unnecessaryAbstractClass.excludeAnnotatedClasses = collection;
    }

    public /* synthetic */ UnnecessaryAbstractClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnnecessaryAbstractClass() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass$NamedClassMembers;", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "namedMembers", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "getKlass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "getNamedMembers", "()Ljava/util/List;", "detectAbstractAndConcreteType", "", "hasInheritedMember", "", "isAbstract", "hasNoConcreteMemberLeft", "indexOfFirstMember", "", "members", "isAbstractClassWithoutConcreteMembers", "indexOfFirstAbstractMember", "detekt-rules-style"})
    private final class NamedClassMembers {
        @NotNull
        private final KtClass klass;
        @NotNull
        private final List<PsiElement> namedMembers;

        public final void detectAbstractAndConcreteType() {
            int firstAbstractMemberIndex = NamedClassMembers.indexOfFirstMember$default(this, true, null, 2, null);
            if (firstAbstractMemberIndex == -1 && !this.hasInheritedMember(true)) {
                UnnecessaryAbstractClass.this.report((Finding)new CodeSmell(UnnecessaryAbstractClass.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)this.klass), (int)0, (int)2, null), UnnecessaryAbstractClass.this.noAbstractMember, null, null, 24, null), this.klass);
            } else if (this.isAbstractClassWithoutConcreteMembers(firstAbstractMemberIndex) && !this.hasInheritedMember(false)) {
                UnnecessaryAbstractClass.this.report((Finding)new CodeSmell(UnnecessaryAbstractClass.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)this.klass), (int)0, (int)2, null), UnnecessaryAbstractClass.this.noConcreteMember, null, null, 24, null), this.klass);
            }
        }

        private final int indexOfFirstMember(boolean isAbstract, List<? extends PsiElement> members) {
            int n;
            block2: {
                List<? extends PsiElement> $this$indexOfFirst$iv = members;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends PsiElement> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    PsiElement item$iv;
                    PsiElement it = item$iv = iterator.next();
                    boolean bl = false;
                    if (it instanceof KtNamedDeclaration && KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)it)) == isAbstract) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        static /* synthetic */ int indexOfFirstMember$default(NamedClassMembers namedClassMembers, boolean bl, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = namedClassMembers.namedMembers;
            }
            return namedClassMembers.indexOfFirstMember(bl, list);
        }

        private final boolean isAbstractClassWithoutConcreteMembers(int indexOfFirstAbstractMember) {
            return indexOfFirstAbstractMember == 0 && this.hasNoConcreteMemberLeft() && UnnecessaryAbstractClass.this.hasNoConstructorParameter(this.klass);
        }

        private final boolean hasNoConcreteMemberLeft() {
            return this.indexOfFirstMember(false, CollectionsKt.drop((Iterable)this.namedMembers, (int)1)) == -1;
        }

        private final boolean hasInheritedMember(boolean isAbstract) {
            boolean bl;
            block10: {
                if (this.klass.getSuperTypeListEntries().isEmpty()) {
                    bl = false;
                } else if (Intrinsics.areEqual((Object)UnnecessaryAbstractClass.this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                    bl = true;
                } else {
                    ClassDescriptor descriptor;
                    ClassDescriptor classDescriptor;
                    Object object = UnnecessaryAbstractClass.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.klass);
                    if (!(object instanceof ClassDescriptor)) {
                        object = null;
                    }
                    Collection collection = (classDescriptor = (descriptor = (ClassDescriptor)object)) != null && (classDescriptor = classDescriptor.getUnsubstitutedMemberScope()) != null ? ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)((ResolutionScope)classDescriptor), null, null, (int)3, null) : null;
                    boolean bl2 = false;
                    Collection collection2 = collection;
                    if (collection2 == null) {
                        collection2 = CollectionsKt.emptyList();
                    }
                    Iterable $this$any$iv = collection2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                            boolean bl3 = false;
                            DeclarationDescriptor declarationDescriptor = it;
                            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                                declarationDescriptor = null;
                            }
                            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
                            if (!((memberDescriptor != null ? memberDescriptor.getModality() : null) == Modality.ABSTRACT == isAbstract)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }

        @NotNull
        public final KtClass getKlass() {
            return this.klass;
        }

        @NotNull
        public final List<PsiElement> getNamedMembers() {
            return this.namedMembers;
        }

        public NamedClassMembers(@NotNull KtClass klass, List<? extends PsiElement> namedMembers) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter(namedMembers, (String)"namedMembers");
            this.klass = klass;
            this.namedMembers = namedMembers;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass$Companion;", "", "()V", "EXCLUDE_ANNOTATED_CLASSES", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

