/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isEmptyElement", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "detekt-rules-style"})
public final class UseOrEmpty
extends Rule {
    @NotNull
    private final Issue issue;
    private static final Map<String, FqName> emptyFunctions;
    private static final Map<String, FqName> factoryFunctions;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS) ^ true) {
            return;
        }
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.left ?: return");
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.right ?: return");
        KtExpression right = ktExpression2;
        if (!this.isEmptyElement(right)) {
            return;
        }
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)left, (BindingContext)this.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        if (!KotlinTypeKt.isNullable((KotlinType)leftType)) {
            return;
        }
        KotlinType kotlinType2 = CallUtilKt.getType((KtExpression)right, (BindingContext)this.getBindingContext());
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightType = kotlinType2;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)TypeUtilsKt.makeNotNullable((KotlinType)leftType), (KotlinType)rightType)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("This '");
        KtSingleValueToken ktSingleValueToken = KtTokens.ELVIS;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.ELVIS");
        String message = stringBuilder.append(ktSingleValueToken.getValue()).append(' ').append(right.getText()).append("' can be replaced with 'orEmpty()' call").toString();
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final boolean isEmptyElement(KtExpression $this$isEmptyElement) {
        KtExpression ktExpression = $this$isEmptyElement;
        if (ktExpression instanceof KtCallExpression) {
            Object object = ((KtCallExpression)$this$isEmptyElement).getCalleeExpression();
            if (object == null || (object = object.getText()) == null) {
                return false;
            }
            Object calleeText = object;
            FqName emptyFunction = emptyFunctions.get(calleeText);
            FqName factoryFunction = factoryFunctions.get(calleeText);
            if (emptyFunction == null && factoryFunction == null) {
                return false;
            }
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isEmptyElement), (BindingContext)this.getBindingContext());
            if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null || (resolvedCall = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall))) == null) {
                return false;
            }
            ResolvedCall fqName = resolvedCall;
            return Intrinsics.areEqual((Object)fqName, (Object)emptyFunction) || Intrinsics.areEqual((Object)fqName, (Object)factoryFunction) && ((KtCallExpression)$this$isEmptyElement).getValueArguments().isEmpty();
        }
        if (ktExpression instanceof KtStringTemplateExpression) {
            KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)$this$isEmptyElement).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"entries");
            KtStringTemplateEntry[] ktStringTemplateEntryArray2 = ktStringTemplateEntryArray;
            boolean bl = false;
            return ktStringTemplateEntryArray2.length == 0;
        }
        return false;
    }

    public UseOrEmpty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseOrEmpty", Severity.Style, "Use 'orEmpty()' call instead of '?: emptyList()'", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseOrEmpty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UseOrEmpty() {
        this(null, 1, null);
    }

    static {
        FqName fqName;
        String it;
        Map map;
        Iterable $this$associateTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$associate$iv = CollectionsKt.listOf((Object[])new String[]{"kotlin.collections.emptyList", "kotlin.collections.emptySet", "kotlin.collections.emptyMap", "kotlin.sequences.emptySequence", "kotlin.emptyArray"});
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (String)element$iv$iv;
            boolean bl = false;
            fqName = new FqName(it);
            it = TuplesKt.to((Object)fqName.shortName().asString(), (Object)fqName);
            bl = false;
            map.put(it.getFirst(), it.getSecond());
        }
        emptyFunctions = destination$iv$iv;
        $this$associate$iv = CollectionsKt.listOf((Object[])new String[]{"kotlin.collections.listOf", "kotlin.collections.setOf", "kotlin.collections.mapOf", "kotlin.sequences.sequenceOf", "kotlin.arrayOf"});
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            it = (String)element$iv$iv;
            boolean bl = false;
            fqName = new FqName(it);
            Pair pair = TuplesKt.to((Object)fqName.shortName().asString(), (Object)fqName);
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        factoryFunctions = destination$iv$iv;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseOrEmpty$Companion;", "", "()V", "emptyFunctions", "", "", "Lorg/jetbrains/kotlin/name/FqName;", "factoryFunctions", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

